/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.SpdxException;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseException;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseReferenceExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSimpleExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseWithExceptionExpression;", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "license", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSimpleExpression;", "exception", "", "(Lorg/ossreviewtoolkit/utils/spdx/SpdxSimpleExpression;Ljava/lang/String;)V", "getException", "()Ljava/lang/String;", "getLicense", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxSimpleExpression;", "decompose", "", "equals", "", "other", "", "getLicenseUrl", "hashCode", "", "licenses", "", "normalize", "mapDeprecated", "simpleLicense", "toString", "validate", "", "strictness", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression$Strictness;", "Companion", "spdx-utils"})
public final class SpdxLicenseWithExceptionExpression
extends SpdxSingleLicenseExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpdxSimpleExpression license;
    @NotNull
    private final String exception;
    @NotNull
    private static final Regex EXCEPTION_STRING_PATTERN = new Regex("\\bexception\\b", RegexOption.IGNORE_CASE);

    public SpdxLicenseWithExceptionExpression(@NotNull SpdxSimpleExpression license, @NotNull String exception) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        super(null);
        this.license = license;
        this.exception = exception;
    }

    @NotNull
    public final SpdxSimpleExpression getLicense() {
        return this.license;
    }

    @NotNull
    public final String getException() {
        return this.exception;
    }

    @NotNull
    public Set<SpdxLicenseWithExceptionExpression> decompose() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    @NotNull
    public List<String> licenses() {
        return this.license.licenses();
    }

    @Override
    @NotNull
    public String simpleLicense() {
        return this.license.toString();
    }

    @Override
    @NotNull
    public String exception() {
        return this.exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public SpdxLicenseWithExceptionExpression normalize(boolean mapDeprecated) {
        SpdxLicenseWithExceptionExpression spdxLicenseWithExceptionExpression;
        SpdxExpression spdxExpression = this.license.normalize(mapDeprecated);
        Intrinsics.checkNotNull((Object)spdxExpression, (String)"null cannot be cast to non-null type org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression");
        SpdxSingleLicenseExpression normalizedLicense = (SpdxSingleLicenseExpression)spdxExpression;
        if (normalizedLicense instanceof SpdxSimpleExpression) {
            spdxLicenseWithExceptionExpression = new SpdxLicenseWithExceptionExpression((SpdxSimpleExpression)normalizedLicense, this.exception);
            return spdxLicenseWithExceptionExpression;
        } else {
            if (!(normalizedLicense instanceof SpdxLicenseWithExceptionExpression)) throw new NoWhenBranchMatchedException();
            if (!Intrinsics.areEqual((Object)((SpdxLicenseWithExceptionExpression)normalizedLicense).exception, (Object)this.exception)) throw new SpdxException("'" + this + "' cannot be normalized, because the license '" + this.license + "' contains the exception '" + ((SpdxLicenseWithExceptionExpression)normalizedLicense).exception + "' which is different from '" + this.exception + "'.");
            spdxLicenseWithExceptionExpression = (SpdxLicenseWithExceptionExpression)normalizedLicense;
        }
        return spdxLicenseWithExceptionExpression;
    }

    @Override
    public void validate(@NotNull SpdxExpression.Strictness strictness) {
        boolean isCurrentLicenseException;
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        this.license.validate(strictness);
        if (strictness == SpdxExpression.Strictness.ALLOW_ANY) {
            return;
        }
        SpdxLicenseException spdxLicenseException = SpdxLicenseException.Companion.forId(this.exception);
        if (strictness == SpdxExpression.Strictness.ALLOW_DEPRECATED && spdxLicenseException != null) {
            return;
        }
        SpdxLicenseException spdxLicenseException2 = spdxLicenseException;
        boolean bl = spdxLicenseException2 != null ? !spdxLicenseException2.getDeprecated() : (isCurrentLicenseException = false);
        if (strictness == SpdxExpression.Strictness.ALLOW_CURRENT && isCurrentLicenseException) {
            return;
        }
        if (strictness == SpdxExpression.Strictness.ALLOW_LICENSEREF_EXCEPTIONS) {
            boolean isValidLicenseRef = new SpdxLicenseReferenceExpression(this.exception).isValid(strictness);
            CharSequence charSequence = this.exception;
            boolean isExceptionString = EXCEPTION_STRING_PATTERN.containsMatchIn(charSequence);
            if (isCurrentLicenseException || isValidLicenseRef && isExceptionString) {
                return;
            }
        }
        throw new SpdxException("'" + this.exception + "' is not a valid SPDX license exception string.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (object instanceof SpdxLicenseWithExceptionExpression) {
            if (!Intrinsics.areEqual((Object)this.license, (Object)((SpdxLicenseWithExceptionExpression)other).license)) return false;
            if (!Intrinsics.areEqual((Object)this.exception, (Object)((SpdxLicenseWithExceptionExpression)other).exception)) return false;
            return true;
        }
        if (!(object instanceof SpdxExpression)) return false;
        Set<SpdxSingleLicenseExpression> decomposed = ((SpdxExpression)other).decompose();
        if (decomposed.size() != 1) return false;
        SpdxSingleLicenseExpression it = (SpdxSingleLicenseExpression)CollectionsKt.first((Iterable)decomposed);
        boolean bl = false;
        if (!(it instanceof SpdxLicenseWithExceptionExpression)) return false;
        if (!Intrinsics.areEqual((Object)((SpdxLicenseWithExceptionExpression)it).license, (Object)this.license)) return false;
        if (!Intrinsics.areEqual((Object)((SpdxLicenseWithExceptionExpression)it).exception, (Object)this.exception)) return false;
        return true;
    }

    public int hashCode() {
        return this.license.hashCode() + 31 * this.exception.hashCode();
    }

    @NotNull
    public String toString() {
        return this.license + " WITH " + this.exception;
    }

    @Override
    @Nullable
    public String getLicenseUrl() {
        return this.license.getLicenseUrl();
    }

    @JsonCreator
    @JvmStatic
    @NotNull
    public static final SpdxLicenseWithExceptionExpression parse(@NotNull String expression) {
        return Companion.parse(expression);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseWithExceptionExpression$Companion;", "", "()V", "EXCEPTION_STRING_PATTERN", "Lkotlin/text/Regex;", "parse", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseWithExceptionExpression;", "expression", "", "spdx-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JsonCreator
        @JvmStatic
        @NotNull
        public final SpdxLicenseWithExceptionExpression parse(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            SpdxExpression spdxExpression = SpdxExpression.Companion.parse(expression);
            Intrinsics.checkNotNull((Object)spdxExpression, (String)"null cannot be cast to non-null type org.ossreviewtoolkit.utils.spdx.SpdxLicenseWithExceptionExpression");
            return (SpdxLicenseWithExceptionExpression)spdxExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

