/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.spdx.SpdxModelMapperKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u0002H\f\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0012\u001a\u0002H\f\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\b\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0001J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0001J*\u0010\u0019\u001a\u00020\u001a\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u0002H\fH\u0086\b\u00a2\u0006\u0002\u0010\u001bR\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxModelMapper;", "", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJsonMapper$annotations", "getJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "yamlMapper", "getYamlMapper$annotations", "getYamlMapper", "fromJson", "T", "json", "", "(Ljava/lang/String;)Ljava/lang/Object;", "fromYaml", "yaml", "read", "file", "Ljava/io/File;", "(Ljava/io/File;)Ljava/lang/Object;", "toJson", "value", "toYaml", "write", "", "(Ljava/io/File;Ljava/lang/Object;)V", "FileFormat", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxModelMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxModelMapper.kt\norg/ossreviewtoolkit/utils/spdx/SpdxModelMapper\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,108:1\n48#2:109\n43#2:110\n50#2:111\n43#2:112\n50#2:113\n43#2:114\n*S KotlinDebug\n*F\n+ 1 SpdxModelMapper.kt\norg/ossreviewtoolkit/utils/spdx/SpdxModelMapper\n*L\n74#1:109\n74#1:110\n85#1:111\n85#1:112\n96#1:113\n96#1:114\n*E\n"})
public final class SpdxModelMapper {
    @NotNull
    public static final SpdxModelMapper INSTANCE = new SpdxModelMapper();
    @NotNull
    private static final ObjectMapper jsonMapper;
    @NotNull
    private static final ObjectMapper yamlMapper;

    private SpdxModelMapper() {
    }

    public final /* synthetic */ <T> T read(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$read = false;
        ObjectMapper $this$readValue$iv = FileFormat.Companion.forFile(file).getMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        Intrinsics.needClassReification();
        return (T)$this$readValue$iv.readValue(file, new TypeReference<T>(){});
    }

    public final /* synthetic */ <T> void write(File file, T value) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$write = false;
        FileFormat.Companion.forFile(file).getMapper().writeValue(file, value);
    }

    @NotNull
    public final ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    @PublishedApi
    public static /* synthetic */ void getJsonMapper$annotations() {
    }

    public final /* synthetic */ <T> T fromJson(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        boolean $i$f$fromJson = false;
        ObjectMapper $this$readValue$iv = this.getJsonMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        Intrinsics.needClassReification();
        return (T)$this$readValue$iv.readValue(json, new TypeReference<T>(){});
    }

    @NotNull
    public final String toJson(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = jsonMapper.writeValueAsString(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    @PublishedApi
    public static /* synthetic */ void getYamlMapper$annotations() {
    }

    public final /* synthetic */ <T> T fromYaml(String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        boolean $i$f$fromYaml = false;
        ObjectMapper $this$readValue$iv = this.getYamlMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        Intrinsics.needClassReification();
        return (T)$this$readValue$iv.readValue(yaml, new TypeReference<T>(){});
    }

    @NotNull
    public final String toYaml(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = yamlMapper.writeValueAsString(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    static {
        JsonMapper jsonMapper = new JsonMapper();
        SpdxModelMapperKt.access$getMapperConfig$p().invoke((Object)jsonMapper);
        SpdxModelMapper.jsonMapper = (ObjectMapper)jsonMapper;
        jsonMapper = new YAMLMapper();
        SpdxModelMapperKt.access$getMapperConfig$p().invoke((Object)jsonMapper);
        yamlMapper = (ObjectMapper)jsonMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxModelMapper$FileFormat;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "fileExtension", "", "aliases", "", "(Ljava/lang/String;ILcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;[Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "fileExtensions", "", "getFileExtensions", "()Ljava/util/List;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "JSON", "YAML", "Companion", "spdx-utils"})
    public static final class FileFormat
    extends Enum<FileFormat> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final ObjectMapper mapper;
        @NotNull
        private final String fileExtension;
        @NotNull
        private final List<String> fileExtensions;
        public static final /* enum */ FileFormat JSON;
        public static final /* enum */ FileFormat YAML;
        private static final /* synthetic */ FileFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FileFormat(ObjectMapper mapper, String fileExtension, String ... aliases) {
            this.mapper = mapper;
            this.fileExtension = fileExtension;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)this.fileExtension);
            spreadBuilder.addSpread((Object)aliases);
            this.fileExtensions = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return this.mapper;
        }

        @NotNull
        public final String getFileExtension() {
            return this.fileExtension;
        }

        @NotNull
        public final List<String> getFileExtensions() {
            return this.fileExtensions;
        }

        public static FileFormat[] values() {
            return (FileFormat[])$VALUES.clone();
        }

        public static FileFormat valueOf(String value) {
            return Enum.valueOf(FileFormat.class, value);
        }

        @NotNull
        public static EnumEntries<FileFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            JSON = new FileFormat(INSTANCE.getJsonMapper(), "json", new String[0]);
            String[] stringArray = new String[]{"yaml"};
            YAML = new FileFormat(INSTANCE.getYamlMapper(), "yml", stringArray);
            $VALUES = fileFormatArray = new FileFormat[]{FileFormat.JSON, FileFormat.YAML};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxModelMapper$FileFormat$Companion;", "", "()V", "forExtension", "Lorg/ossreviewtoolkit/utils/spdx/SpdxModelMapper$FileFormat;", "extension", "", "forFile", "file", "Ljava/io/File;", "spdx-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileFormat forExtension(@NotNull String extension) {
                Object v1;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    String string = extension.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    String lowerCaseExtension = string;
                    boolean bl = false;
                    Iterable iterable = (Iterable)FileFormat.getEntries();
                    for (Object t : iterable) {
                        FileFormat it = (FileFormat)((Object)t);
                        boolean bl2 = false;
                        if (!it.getFileExtensions().contains(lowerCaseExtension)) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                FileFormat fileFormat = v1;
                if (fileFormat == null) {
                    throw new IllegalArgumentException("Unknown file format for file extension '" + extension + "'.");
                }
                return fileFormat;
            }

            @NotNull
            public final FileFormat forFile(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.forExtension(FilesKt.getExtension((File)file));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

