/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseException;
import org.ossreviewtoolkit.utils.spdx.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002\u001a\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b\u0015\u001a+\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0007\u00a2\u0006\u0002\b\u0019\u001a+\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0007\u00a2\u0006\u0002\b\u001b\u001a*\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u00132\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u001a\u001a\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0007H\u0002\u001a0\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u00132\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u001a\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002\u001a(\u0010&\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00132\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"LICENSE_REF_FILENAME_REGEX", "Lkotlin/text/Regex;", "getLICENSE_REF_FILENAME_REGEX", "()Lkotlin/text/Regex;", "LICENSE_REF_FILENAME_REGEX$delegate", "Lkotlin/Lazy;", "scanCodeLicenseTextDir", "Ljava/io/File;", "getScanCodeLicenseTextDir", "()Ljava/io/File;", "scanCodeLicenseTextDir$delegate", "yamlMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getYamlMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "addScanCodeLicenseTextsDir", "", "licenseTextDirectories", "calculatePackageVerificationCode", "", "directory", "calculatePackageVerificationCodeForDirectory", "files", "Lkotlin/sequences/Sequence;", "excludes", "calculatePackageVerificationCodeForFiles", "sha1sums", "calculatePackageVerificationCodeForStrings", "getLicenseText", "id", "handleExceptions", "", "getLicenseTextFile", "dir", "getLicenseTextReader", "Lkotlin/Function0;", "getLicenseTextResource", "Ljava/net/URL;", "hasLicenseText", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/ossreviewtoolkit/utils/spdx/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1284#2,2:165\n1286#2:168\n1#3:167\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/ossreviewtoolkit/utils/spdx/UtilsKt\n*L\n63#1:165,2\n63#1:168\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final ObjectMapper yamlMapper = com.fasterxml.jackson.module.kotlin.ExtensionsKt.registerKotlinModule((ObjectMapper)((ObjectMapper)new YAMLMapper()));
    @NotNull
    private static final Lazy scanCodeLicenseTextDir$delegate = LazyKt.lazy((Function0)scanCodeLicenseTextDir.2.INSTANCE);
    @NotNull
    private static final Lazy LICENSE_REF_FILENAME_REGEX$delegate = LazyKt.lazy((Function0)LICENSE_REF_FILENAME_REGEX.2.INSTANCE);

    @NotNull
    public static final ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    @Nullable
    public static final File getScanCodeLicenseTextDir() {
        Lazy lazy = scanCodeLicenseTextDir$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="calculatePackageVerificationCodeForStrings")
    @NotNull
    public static final String calculatePackageVerificationCodeForStrings(@NotNull Sequence<String> sha1sums, @NotNull Sequence<String> excludes) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(sha1sums, (String)"sha1sums");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Sequence sequence = SequencesKt.sorted(sha1sums);
        MessageDigest initial$iv = MessageDigest.getInstance("SHA-1");
        boolean $i$f$fold = false;
        MessageDigest accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void sha1sum;
            MessageDigest messageDigest;
            String string = (String)element$iv;
            MessageDigest digest = accumulator$iv;
            boolean bl = false;
            MessageDigest $this$calculatePackageVerificationCode_u24lambda_u241_u24lambda_u240 = messageDigest = digest;
            boolean bl2 = false;
            byte[] byArray = sha1sum.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            $this$calculatePackageVerificationCode_u24lambda_u241_u24lambda_u240.update(byArray);
            accumulator$iv = messageDigest;
        }
        byte[] byArray = accumulator$iv.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        String sha1sum = ExtensionsKt.encodeHex((byte[])byArray);
        return SequencesKt.none(excludes) ? sha1sum : sha1sum + " (excludes: " + SequencesKt.joinToString$default(excludes, null, null, null, (int)0, null, null, (int)63, null) + ")";
    }

    public static /* synthetic */ String calculatePackageVerificationCodeForStrings$default(Sequence sequence, Sequence sequence2, int n, Object object) {
        if ((n & 2) != 0) {
            sequence2 = SequencesKt.emptySequence();
        }
        return UtilsKt.calculatePackageVerificationCodeForStrings((Sequence<String>)sequence, (Sequence<String>)sequence2);
    }

    @JvmName(name="calculatePackageVerificationCodeForFiles")
    @NotNull
    public static final String calculatePackageVerificationCodeForFiles(@NotNull Sequence<? extends File> files2, @NotNull Sequence<String> excludes) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        return UtilsKt.calculatePackageVerificationCodeForStrings((Sequence<String>)SequencesKt.map(files2, (Function1)calculatePackageVerificationCode.1.INSTANCE), excludes);
    }

    public static /* synthetic */ String calculatePackageVerificationCodeForFiles$default(Sequence sequence, Sequence sequence2, int n, Object object) {
        if ((n & 2) != 0) {
            sequence2 = SequencesKt.emptySequence();
        }
        return UtilsKt.calculatePackageVerificationCodeForFiles((Sequence<? extends File>)sequence, (Sequence<String>)sequence2);
    }

    @JvmName(name="calculatePackageVerificationCodeForDirectory")
    @NotNull
    public static final String calculatePackageVerificationCodeForDirectory(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Sequence allFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory, null, (int)1, null).onEnter((Function1)calculatePackageVerificationCode.allFiles.1.INSTANCE)), (Function1)calculatePackageVerificationCode.allFiles.2.INSTANCE);
        Sequence spdxFiles2 = SequencesKt.filter((Sequence)allFiles2, (Function1)calculatePackageVerificationCode.spdxFiles.1.INSTANCE);
        Sequence files2 = SequencesKt.filter((Sequence)allFiles2, (Function1)calculatePackageVerificationCode.files.1.INSTANCE);
        Sequence sortedExcludes2 = SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)spdxFiles2, (Function1)((Function1)new Function1<File, String>(directory){
            final /* synthetic */ File $directory;
            {
                this.$directory = $directory;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "./" + FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)it, (File)this.$directory));
            }
        })), (Comparator)org.ossreviewtoolkit.utils.common.UtilsKt.getPATH_STRING_COMPARATOR());
        return UtilsKt.calculatePackageVerificationCodeForFiles((Sequence<? extends File>)files2, (Sequence<String>)sortedExcludes2);
    }

    @Nullable
    public static final String getLicenseText(@NotNull String id, boolean handleExceptions, @NotNull List<? extends File> licenseTextDirectories) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(licenseTextDirectories, (String)"licenseTextDirectories");
        Function0<String> function0 = UtilsKt.getLicenseTextReader(id, handleExceptions, UtilsKt.addScanCodeLicenseTextsDir(licenseTextDirectories));
        return function0 != null ? (String)function0.invoke() : null;
    }

    public static /* synthetic */ String getLicenseText$default(String string, boolean bl, List list, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return UtilsKt.getLicenseText(string, bl, list);
    }

    public static final boolean hasLicenseText(@NotNull String id, boolean handleExceptions, @NotNull List<? extends File> licenseTextDirectories) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(licenseTextDirectories, (String)"licenseTextDirectories");
        return UtilsKt.getLicenseTextReader(id, handleExceptions, UtilsKt.addScanCodeLicenseTextsDir(licenseTextDirectories)) != null;
    }

    public static /* synthetic */ boolean hasLicenseText$default(String string, boolean bl, List list, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return UtilsKt.hasLicenseText(string, bl, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Function0<String> getLicenseTextReader(@NotNull String id, boolean handleExceptions, @NotNull List<? extends File> licenseTextDirectories) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(licenseTextDirectories, (String)"licenseTextDirectories");
        if (StringsKt.startsWith$default((String)id, (String)"LicenseRef-", (boolean)false, (int)2, null)) {
            URL uRL = UtilsKt.getLicenseTextResource(id);
            if (uRL != null) {
                URL it2 = uRL;
                boolean bl = false;
                object = (Function0)new Function0<String>(it2){
                    final /* synthetic */ URL $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        URL uRL = this.$it;
                        Charset charset = Charsets.UTF_8;
                        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                        return new String(byArray, charset);
                    }
                };
                return object;
            } else {
                Function0 function0;
                File it;
                Iterator it2 = ((Iterable)UtilsKt.addScanCodeLicenseTextsDir(licenseTextDirectories)).iterator();
                do {
                    if (!it2.hasNext()) return null;
                    it = (File)it2.next();
                    boolean bl = false;
                    if (UtilsKt.getLicenseTextFile(id, it) != null) {
                        File file;
                        boolean bl2 = false;
                        function0 = (Function0)new Function0<String>(file){
                            final /* synthetic */ File $file;
                            {
                                this.$file = $file;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return FilesKt.readText$default((File)this.$file, null, (int)1, null);
                            }
                        };
                        continue;
                    }
                    function0 = null;
                } while ((it = function0) == null);
                object = it;
            }
            return object;
        } else {
            SpdxLicense spdxLicense2 = SpdxLicense.Companion.forId(StringsKt.removeSuffix((String)id, (CharSequence)"+"));
            if (spdxLicense2 != null) {
                SpdxLicense it = spdxLicense2;
                boolean bl = false;
                object = (Function0)new Function0<String>(it){
                    final /* synthetic */ SpdxLicense $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$it.getText();
                    }
                };
                return object;
            } else {
                SpdxLicenseException spdxLicenseException;
                SpdxLicenseException spdxLicenseException3 = SpdxLicenseException.Companion.forId(id);
                spdxLicenseException3 = spdxLicenseException3;
                if (spdxLicenseException2 == null) return null;
                SpdxLicenseException it = spdxLicenseException = spdxLicenseException3;
                boolean bl = false;
                if (!handleExceptions) return null;
                SpdxLicenseException spdxLicenseException3 = spdxLicenseException;
                spdxLicenseException3 = spdxLicenseException3;
                if (spdxLicenseException4 == null) return null;
                it = spdxLicenseException3;
                boolean bl3 = false;
                object = (Function0)new Function0<String>(it){
                    final /* synthetic */ SpdxLicenseException $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$it.getText();
                    }
                };
            }
        }
        return object;
    }

    public static /* synthetic */ Function0 getLicenseTextReader$default(String string, boolean bl, List list, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return UtilsKt.getLicenseTextReader(string, bl, list);
    }

    private static final URL getLicenseTextResource(String id) {
        return new Object(){}.getClass().getResource("/licenserefs/" + id);
    }

    private static final Regex getLICENSE_REF_FILENAME_REGEX() {
        Lazy lazy = LICENSE_REF_FILENAME_REGEX$delegate;
        return (Regex)lazy.getValue();
    }

    private static final File getLicenseTextFile(String id, File dir) {
        Object object;
        block1: {
            Object object2;
            CharSequence charSequence = id;
            Regex regex = UtilsKt.getLICENSE_REF_FILENAME_REGEX();
            String string = "";
            String idWithoutLicenseRefNamespace = regex.replace(charSequence, string);
            boolean bl = false;
            Object[] objectArray = new String[5];
            objectArray[0] = id;
            objectArray[1] = StringsKt.removePrefix((String)id, (CharSequence)"LicenseRef-");
            objectArray[2] = idWithoutLicenseRefNamespace;
            objectArray[3] = idWithoutLicenseRefNamespace + ".LICENSE";
            Object object3 = object2 = "x11-xconsortium_veillard.LICENSE";
            int n = 4;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            boolean bl3 = Intrinsics.areEqual((Object)id, (Object)"LicenseRef-scancode-x11-xconsortium-veillard");
            objectArray2[n] = bl3 ? object2 : null;
            for (String filename : (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)) {
                File file;
                boolean bl4 = false;
                File it = file = FilesKt.resolve((File)dir, (String)filename);
                boolean bl5 = false;
                object3 = it.isFile() ? file : null;
                if (object3 == null) continue;
                object = object3;
                break block1;
            }
            object = null;
        }
        return object;
    }

    private static final List<File> addScanCodeLicenseTextsDir(List<? extends File> licenseTextDirectories) {
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)UtilsKt.getScanCodeLicenseTextDir()), (Iterable)licenseTextDirectories));
    }
}

