/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx.model;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum;", "", "algorithm", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum$Algorithm;", "checksumValue", "", "(Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum$Algorithm;Ljava/lang/String;)V", "getAlgorithm", "()Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum$Algorithm;", "getChecksumValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Algorithm", "Companion", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxChecksum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxChecksum.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class SpdxChecksum {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Algorithm algorithm;
    @NotNull
    private final String checksumValue;
    @NotNull
    private static final Regex HEX_SYMBOLS_REGEX = new Regex("^[0-9a-f]+$");

    public SpdxChecksum(@NotNull Algorithm algorithm, @NotNull String checksumValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)checksumValue, (String)"checksumValue");
        this.algorithm = algorithm;
        this.checksumValue = checksumValue;
        if (!(!StringsKt.isBlank((CharSequence)this.checksumValue))) {
            boolean $i$a$-require-SpdxChecksum$42 = false;
            String $i$a$-require-SpdxChecksum$42 = "The checksum value must not be blank.";
            throw new IllegalArgumentException($i$a$-require-SpdxChecksum$42.toString());
        }
        CharSequence charSequence = this.checksumValue;
        if (!HEX_SYMBOLS_REGEX.matches(charSequence)) {
            boolean $i$a$-require-SpdxChecksum$52 = false;
            String $i$a$-require-SpdxChecksum$52 = "The checksum value must only contain lower case hexadecimal symbols.";
            throw new IllegalArgumentException($i$a$-require-SpdxChecksum$52.toString());
        }
        if (!(this.algorithm.getChecksumHexDigits() == -1 || this.checksumValue.length() == this.algorithm.getChecksumHexDigits())) {
            boolean bl = false;
            String string = "Expected a checksum value with " + this.algorithm.getChecksumHexDigits() + " hexadecimal symbols, but found " + this.checksumValue.length() + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String getChecksumValue() {
        return this.checksumValue;
    }

    @NotNull
    public final Algorithm component1() {
        return this.algorithm;
    }

    @NotNull
    public final String component2() {
        return this.checksumValue;
    }

    @NotNull
    public final SpdxChecksum copy(@NotNull Algorithm algorithm, @NotNull String checksumValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)checksumValue, (String)"checksumValue");
        return new SpdxChecksum(algorithm, checksumValue);
    }

    public static /* synthetic */ SpdxChecksum copy$default(SpdxChecksum spdxChecksum, Algorithm algorithm, String string, int n, Object object) {
        if ((n & 1) != 0) {
            algorithm = spdxChecksum.algorithm;
        }
        if ((n & 2) != 0) {
            string = spdxChecksum.checksumValue;
        }
        return spdxChecksum.copy(algorithm, string);
    }

    @NotNull
    public String toString() {
        return "SpdxChecksum(algorithm=" + this.algorithm + ", checksumValue=" + this.checksumValue + ")";
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = result * 31 + this.checksumValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpdxChecksum)) {
            return false;
        }
        SpdxChecksum spdxChecksum = (SpdxChecksum)other;
        if (this.algorithm != spdxChecksum.algorithm) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checksumValue, (Object)spdxChecksum.checksumValue);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum$Algorithm;", "", "checksumHexDigits", "", "(Ljava/lang/String;II)V", "getChecksumHexDigits", "()I", "MD2", "MD4", "MD5", "MD6", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "spdx-utils"})
    public static final class Algorithm
    extends Enum<Algorithm> {
        private final int checksumHexDigits;
        public static final /* enum */ Algorithm MD2 = new Algorithm(32);
        public static final /* enum */ Algorithm MD4 = new Algorithm(32);
        public static final /* enum */ Algorithm MD5 = new Algorithm(32);
        public static final /* enum */ Algorithm MD6 = new Algorithm(-1);
        public static final /* enum */ Algorithm SHA1 = new Algorithm(40);
        public static final /* enum */ Algorithm SHA224 = new Algorithm(56);
        public static final /* enum */ Algorithm SHA256 = new Algorithm(64);
        public static final /* enum */ Algorithm SHA384 = new Algorithm(96);
        public static final /* enum */ Algorithm SHA512 = new Algorithm(128);
        private static final /* synthetic */ Algorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Algorithm(int checksumHexDigits) {
            this.checksumHexDigits = checksumHexDigits;
        }

        public final int getChecksumHexDigits() {
            return this.checksumHexDigits;
        }

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String value) {
            return Enum.valueOf(Algorithm.class, value);
        }

        @NotNull
        public static EnumEntries<Algorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algorithmArray = new Algorithm[]{Algorithm.MD2, Algorithm.MD4, Algorithm.MD5, Algorithm.MD6, Algorithm.SHA1, Algorithm.SHA224, Algorithm.SHA256, Algorithm.SHA384, Algorithm.SHA512};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum$Companion;", "", "()V", "HEX_SYMBOLS_REGEX", "Lkotlin/text/Regex;", "getHEX_SYMBOLS_REGEX$spdx_utils", "()Lkotlin/text/Regex;", "spdx-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getHEX_SYMBOLS_REGEX$spdx_utils() {
            return HEX_SYMBOLS_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

