/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.model.SpdxChecksum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxExternalDocumentReference;", "", "externalDocumentId", "", "spdxDocument", "checksum", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum;", "(Ljava/lang/String;Ljava/lang/String;Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum;)V", "getChecksum", "()Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum;", "getExternalDocumentId", "()Ljava/lang/String;", "getSpdxDocument", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxExternalDocumentReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxExternalDocumentReference.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxExternalDocumentReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class SpdxExternalDocumentReference {
    @NotNull
    private final String externalDocumentId;
    @NotNull
    private final String spdxDocument;
    @NotNull
    private final SpdxChecksum checksum;

    public SpdxExternalDocumentReference(@NotNull String externalDocumentId, @NotNull String spdxDocument, @NotNull SpdxChecksum checksum) {
        Intrinsics.checkNotNullParameter((Object)externalDocumentId, (String)"externalDocumentId");
        Intrinsics.checkNotNullParameter((Object)spdxDocument, (String)"spdxDocument");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        this.externalDocumentId = externalDocumentId;
        this.spdxDocument = spdxDocument;
        this.checksum = checksum;
        if (!(!StringsKt.isBlank((CharSequence)this.externalDocumentId))) {
            boolean $i$a$-require-SpdxExternalDocumentReference$52 = false;
            String $i$a$-require-SpdxExternalDocumentReference$52 = "The external document ID must not be blank.";
            throw new IllegalArgumentException($i$a$-require-SpdxExternalDocumentReference$52.toString());
        }
        if (!StringsKt.startsWith$default((String)this.externalDocumentId, (String)"DocumentRef-", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-SpdxExternalDocumentReference$62 = false;
            String $i$a$-require-SpdxExternalDocumentReference$62 = "The external document ID must start with 'DocumentRef-'.";
            throw new IllegalArgumentException($i$a$-require-SpdxExternalDocumentReference$62.toString());
        }
        if (!(((CharSequence)this.spdxDocument).length() > 0)) {
            boolean $i$a$-require-SpdxExternalDocumentReference$72 = false;
            String $i$a$-require-SpdxExternalDocumentReference$72 = "The SPDX document must not be empty.";
            throw new IllegalArgumentException($i$a$-require-SpdxExternalDocumentReference$72.toString());
        }
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.spdxDocument)).toString(), (Object)this.spdxDocument)) {
            boolean bl = false;
            String string = "The SPDX document must not contain any leading or trailing whitespace.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getExternalDocumentId() {
        return this.externalDocumentId;
    }

    @NotNull
    public final String getSpdxDocument() {
        return this.spdxDocument;
    }

    @NotNull
    public final SpdxChecksum getChecksum() {
        return this.checksum;
    }

    @NotNull
    public final String component1() {
        return this.externalDocumentId;
    }

    @NotNull
    public final String component2() {
        return this.spdxDocument;
    }

    @NotNull
    public final SpdxChecksum component3() {
        return this.checksum;
    }

    @NotNull
    public final SpdxExternalDocumentReference copy(@NotNull String externalDocumentId, @NotNull String spdxDocument, @NotNull SpdxChecksum checksum) {
        Intrinsics.checkNotNullParameter((Object)externalDocumentId, (String)"externalDocumentId");
        Intrinsics.checkNotNullParameter((Object)spdxDocument, (String)"spdxDocument");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        return new SpdxExternalDocumentReference(externalDocumentId, spdxDocument, checksum);
    }

    public static /* synthetic */ SpdxExternalDocumentReference copy$default(SpdxExternalDocumentReference spdxExternalDocumentReference, String string, String string2, SpdxChecksum spdxChecksum, int n, Object object) {
        if ((n & 1) != 0) {
            string = spdxExternalDocumentReference.externalDocumentId;
        }
        if ((n & 2) != 0) {
            string2 = spdxExternalDocumentReference.spdxDocument;
        }
        if ((n & 4) != 0) {
            spdxChecksum = spdxExternalDocumentReference.checksum;
        }
        return spdxExternalDocumentReference.copy(string, string2, spdxChecksum);
    }

    @NotNull
    public String toString() {
        return "SpdxExternalDocumentReference(externalDocumentId=" + this.externalDocumentId + ", spdxDocument=" + this.spdxDocument + ", checksum=" + this.checksum + ")";
    }

    public int hashCode() {
        int result = this.externalDocumentId.hashCode();
        result = result * 31 + this.spdxDocument.hashCode();
        result = result * 31 + this.checksum.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpdxExternalDocumentReference)) {
            return false;
        }
        SpdxExternalDocumentReference spdxExternalDocumentReference = (SpdxExternalDocumentReference)other;
        if (!Intrinsics.areEqual((Object)this.externalDocumentId, (Object)spdxExternalDocumentReference.externalDocumentId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spdxDocument, (Object)spdxExternalDocumentReference.spdxDocument)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checksum, (Object)spdxExternalDocumentReference.checksum);
    }
}

