/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.model.SpdxAnnotation;
import org.ossreviewtoolkit.utils.spdx.model.SpdxChecksum;

@JsonIgnoreProperties(value={"ranges"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u00018B\u00a7\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0003\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0001\u0010\r\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0003\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0014J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u00c6\u0003J\u00af\u0001\u00101\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0003\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0003\u0010\r\u001a\u00020\u00032\u000e\b\u0003\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\b\b\u0003\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0003\u0010\u0013\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019\u00a8\u00069"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxFile;", "", "spdxId", "", "annotations", "", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxAnnotation;", "checksums", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxChecksum;", "comment", "copyrightText", "fileContributors", "fileDependencies", "filename", "fileTypes", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxFile$Type;", "licenseComments", "licenseConcluded", "licenseInfoInFiles", "noticeText", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAnnotations", "()Ljava/util/List;", "getChecksums", "getComment", "()Ljava/lang/String;", "getCopyrightText", "getFileContributors", "getFileDependencies", "getFileTypes", "getFilename", "getLicenseComments", "getLicenseConcluded", "getLicenseInfoInFiles", "getNoticeText", "getSpdxId", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "Type", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxFile.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1747#2,3:200\n819#2:204\n847#2,2:205\n1#3:203\n*S KotlinDebug\n*F\n+ 1 SpdxFile.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxFile\n*L\n176#1:200,3\n191#1:204\n191#1:205,2\n*E\n"})
public final class SpdxFile {
    @NotNull
    private final String spdxId;
    @NotNull
    private final List<SpdxAnnotation> annotations;
    @NotNull
    private final List<SpdxChecksum> checksums;
    @NotNull
    private final String comment;
    @NotNull
    private final String copyrightText;
    @NotNull
    private final List<String> fileContributors;
    @NotNull
    private final List<String> fileDependencies;
    @NotNull
    private final String filename;
    @NotNull
    private final List<Type> fileTypes;
    @NotNull
    private final String licenseComments;
    @NotNull
    private final String licenseConcluded;
    @NotNull
    private final List<String> licenseInfoInFiles;
    @NotNull
    private final String noticeText;

    /*
     * WARNING - void declaration
     */
    public SpdxFile(@JsonProperty(value="SPDXID") @NotNull String spdxId, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<SpdxAnnotation> annotations, @NotNull List<SpdxChecksum> checksums, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String comment, @NotNull String copyrightText, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> fileContributors, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> fileDependencies, @JsonProperty(value="fileName") @NotNull String filename, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<? extends Type> fileTypes, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String licenseComments, @NotNull String licenseConcluded, @NotNull List<String> licenseInfoInFiles, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String noticeText) {
        void $this$filterNotTo$iv$iv;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)spdxId, (String)"spdxId");
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter(checksums, (String)"checksums");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)copyrightText, (String)"copyrightText");
            Intrinsics.checkNotNullParameter(fileContributors, (String)"fileContributors");
            Intrinsics.checkNotNullParameter(fileDependencies, (String)"fileDependencies");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter(fileTypes, (String)"fileTypes");
            Intrinsics.checkNotNullParameter((Object)licenseComments, (String)"licenseComments");
            Intrinsics.checkNotNullParameter((Object)licenseConcluded, (String)"licenseConcluded");
            Intrinsics.checkNotNullParameter(licenseInfoInFiles, (String)"licenseInfoInFiles");
            Intrinsics.checkNotNullParameter((Object)noticeText, (String)"noticeText");
            this.spdxId = spdxId;
            this.annotations = annotations;
            this.checksums = checksums;
            this.comment = comment;
            this.copyrightText = copyrightText;
            this.fileContributors = fileContributors;
            this.fileDependencies = fileDependencies;
            this.filename = filename;
            this.fileTypes = fileTypes;
            this.licenseComments = licenseComments;
            this.licenseConcluded = licenseConcluded;
            this.licenseInfoInFiles = licenseInfoInFiles;
            this.noticeText = noticeText;
            if (!StringsKt.startsWith$default((String)this.spdxId, (String)"SPDXRef-", (boolean)false, (int)2, null)) {
                boolean $i$a$-require-SpdxFile$22 = false;
                String $i$a$-require-SpdxFile$22 = "The SPDX ID '" + this.spdxId + "' has to start with 'SPDXRef-'.";
                throw new IllegalArgumentException($i$a$-require-SpdxFile$22.toString());
            }
            Iterable $this$any$iv = this.checksums;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SpdxChecksum it = (SpdxChecksum)element$iv;
                    boolean bl2 = false;
                    if (!(it.getAlgorithm() == SpdxChecksum.Algorithm.SHA1)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean $i$a$-require-SpdxFile$72 = false;
            String $i$a$-require-SpdxFile$72 = "At least one SHA1 checksum must be provided.";
            throw new IllegalArgumentException($i$a$-require-SpdxFile$72.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.copyrightText))) {
            boolean $i$a$-require-SpdxFile$82 = false;
            String $i$a$-require-SpdxFile$82 = "The copyright text must not be blank.";
            throw new IllegalArgumentException($i$a$-require-SpdxFile$82.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.filename))) {
            boolean $i$a$-require-SpdxFile$92 = false;
            String $i$a$-require-SpdxFile$92 = "The filename must not be blank.";
            throw new IllegalArgumentException($i$a$-require-SpdxFile$92.toString());
        }
        if (!ExtensionsKt.isSpdxExpressionOrNotPresent$default(this.licenseConcluded, null, 1, null)) {
            boolean $i$a$-require-SpdxFile$102 = false;
            String $i$a$-require-SpdxFile$102 = "The license concluded must be either an SpdxExpression, 'NONE' or 'NOASSERTION', but was " + this.licenseConcluded + ".";
            throw new IllegalArgumentException($i$a$-require-SpdxFile$102.toString());
        }
        Iterable $this$filterNot$iv = this.licenseInfoInFiles;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (ExtensionsKt.isSpdxExpressionOrNotPresent(it, SpdxExpression.Strictness.ALLOW_LICENSEREF_EXCEPTIONS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl4 = false;
        if (!it.isEmpty()) {
            boolean bl5 = false;
            String string = "The entries in licenseInfoInFiles must each be either an SpdxExpression, 'NONE' or 'NOASSERTION', but found " + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SpdxFile(String string, List list, List list2, String string2, String string3, List list3, List list4, String string4, List list5, String string5, String string6, List list6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            string3 = "NOASSERTION";
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            string5 = "";
        }
        if ((n & 0x800) != 0) {
            list6 = CollectionsKt.listOf((Object)"NOASSERTION");
        }
        if ((n & 0x1000) != 0) {
            string7 = "";
        }
        this(string, list, list2, string2, string3, list3, list4, string4, list5, string5, string6, list6, string7);
    }

    @NotNull
    public final String getSpdxId() {
        return this.spdxId;
    }

    @NotNull
    public final List<SpdxAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final List<SpdxChecksum> getChecksums() {
        return this.checksums;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    @NotNull
    public final String getCopyrightText() {
        return this.copyrightText;
    }

    @NotNull
    public final List<String> getFileContributors() {
        return this.fileContributors;
    }

    @NotNull
    public final List<String> getFileDependencies() {
        return this.fileDependencies;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @NotNull
    public final List<Type> getFileTypes() {
        return this.fileTypes;
    }

    @NotNull
    public final String getLicenseComments() {
        return this.licenseComments;
    }

    @NotNull
    public final String getLicenseConcluded() {
        return this.licenseConcluded;
    }

    @NotNull
    public final List<String> getLicenseInfoInFiles() {
        return this.licenseInfoInFiles;
    }

    @NotNull
    public final String getNoticeText() {
        return this.noticeText;
    }

    @NotNull
    public final String component1() {
        return this.spdxId;
    }

    @NotNull
    public final List<SpdxAnnotation> component2() {
        return this.annotations;
    }

    @NotNull
    public final List<SpdxChecksum> component3() {
        return this.checksums;
    }

    @NotNull
    public final String component4() {
        return this.comment;
    }

    @NotNull
    public final String component5() {
        return this.copyrightText;
    }

    @NotNull
    public final List<String> component6() {
        return this.fileContributors;
    }

    @NotNull
    public final List<String> component7() {
        return this.fileDependencies;
    }

    @NotNull
    public final String component8() {
        return this.filename;
    }

    @NotNull
    public final List<Type> component9() {
        return this.fileTypes;
    }

    @NotNull
    public final String component10() {
        return this.licenseComments;
    }

    @NotNull
    public final String component11() {
        return this.licenseConcluded;
    }

    @NotNull
    public final List<String> component12() {
        return this.licenseInfoInFiles;
    }

    @NotNull
    public final String component13() {
        return this.noticeText;
    }

    @NotNull
    public final SpdxFile copy(@JsonProperty(value="SPDXID") @NotNull String spdxId, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<SpdxAnnotation> annotations, @NotNull List<SpdxChecksum> checksums, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String comment, @NotNull String copyrightText, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> fileContributors, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> fileDependencies, @JsonProperty(value="fileName") @NotNull String filename, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<? extends Type> fileTypes, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String licenseComments, @NotNull String licenseConcluded, @NotNull List<String> licenseInfoInFiles, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String noticeText) {
        Intrinsics.checkNotNullParameter((Object)spdxId, (String)"spdxId");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(checksums, (String)"checksums");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)copyrightText, (String)"copyrightText");
        Intrinsics.checkNotNullParameter(fileContributors, (String)"fileContributors");
        Intrinsics.checkNotNullParameter(fileDependencies, (String)"fileDependencies");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(fileTypes, (String)"fileTypes");
        Intrinsics.checkNotNullParameter((Object)licenseComments, (String)"licenseComments");
        Intrinsics.checkNotNullParameter((Object)licenseConcluded, (String)"licenseConcluded");
        Intrinsics.checkNotNullParameter(licenseInfoInFiles, (String)"licenseInfoInFiles");
        Intrinsics.checkNotNullParameter((Object)noticeText, (String)"noticeText");
        return new SpdxFile(spdxId, annotations, checksums, comment, copyrightText, fileContributors, fileDependencies, filename, fileTypes, licenseComments, licenseConcluded, licenseInfoInFiles, noticeText);
    }

    public static /* synthetic */ SpdxFile copy$default(SpdxFile spdxFile, String string, List list, List list2, String string2, String string3, List list3, List list4, String string4, List list5, String string5, String string6, List list6, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string = spdxFile.spdxId;
        }
        if ((n & 2) != 0) {
            list = spdxFile.annotations;
        }
        if ((n & 4) != 0) {
            list2 = spdxFile.checksums;
        }
        if ((n & 8) != 0) {
            string2 = spdxFile.comment;
        }
        if ((n & 0x10) != 0) {
            string3 = spdxFile.copyrightText;
        }
        if ((n & 0x20) != 0) {
            list3 = spdxFile.fileContributors;
        }
        if ((n & 0x40) != 0) {
            list4 = spdxFile.fileDependencies;
        }
        if ((n & 0x80) != 0) {
            string4 = spdxFile.filename;
        }
        if ((n & 0x100) != 0) {
            list5 = spdxFile.fileTypes;
        }
        if ((n & 0x200) != 0) {
            string5 = spdxFile.licenseComments;
        }
        if ((n & 0x400) != 0) {
            string6 = spdxFile.licenseConcluded;
        }
        if ((n & 0x800) != 0) {
            list6 = spdxFile.licenseInfoInFiles;
        }
        if ((n & 0x1000) != 0) {
            string7 = spdxFile.noticeText;
        }
        return spdxFile.copy(string, list, list2, string2, string3, list3, list4, string4, list5, string5, string6, list6, string7);
    }

    @NotNull
    public String toString() {
        return "SpdxFile(spdxId=" + this.spdxId + ", annotations=" + this.annotations + ", checksums=" + this.checksums + ", comment=" + this.comment + ", copyrightText=" + this.copyrightText + ", fileContributors=" + this.fileContributors + ", fileDependencies=" + this.fileDependencies + ", filename=" + this.filename + ", fileTypes=" + this.fileTypes + ", licenseComments=" + this.licenseComments + ", licenseConcluded=" + this.licenseConcluded + ", licenseInfoInFiles=" + this.licenseInfoInFiles + ", noticeText=" + this.noticeText + ")";
    }

    public int hashCode() {
        int result = this.spdxId.hashCode();
        result = result * 31 + ((Object)this.annotations).hashCode();
        result = result * 31 + ((Object)this.checksums).hashCode();
        result = result * 31 + this.comment.hashCode();
        result = result * 31 + this.copyrightText.hashCode();
        result = result * 31 + ((Object)this.fileContributors).hashCode();
        result = result * 31 + ((Object)this.fileDependencies).hashCode();
        result = result * 31 + this.filename.hashCode();
        result = result * 31 + ((Object)this.fileTypes).hashCode();
        result = result * 31 + this.licenseComments.hashCode();
        result = result * 31 + this.licenseConcluded.hashCode();
        result = result * 31 + ((Object)this.licenseInfoInFiles).hashCode();
        result = result * 31 + this.noticeText.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpdxFile)) {
            return false;
        }
        SpdxFile spdxFile = (SpdxFile)other;
        if (!Intrinsics.areEqual((Object)this.spdxId, (Object)spdxFile.spdxId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.annotations, spdxFile.annotations)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.checksums, spdxFile.checksums)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.comment, (Object)spdxFile.comment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.copyrightText, (Object)spdxFile.copyrightText)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileContributors, spdxFile.fileContributors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileDependencies, spdxFile.fileDependencies)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filename, (Object)spdxFile.filename)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileTypes, spdxFile.fileTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseComments, (Object)spdxFile.licenseComments)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseConcluded, (Object)spdxFile.licenseConcluded)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licenseInfoInFiles, spdxFile.licenseInfoInFiles)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.noticeText, (Object)spdxFile.noticeText);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxFile$Type;", "", "(Ljava/lang/String;I)V", "APPLICATION", "ARCHIVE", "AUDIO", "BINARY", "DOCUMENTATION", "IMAGE", "OTHER", "SOURCE", "SPDX", "TEXT", "VIDEO", "spdx-utils"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type APPLICATION = new Type();
        public static final /* enum */ Type ARCHIVE = new Type();
        public static final /* enum */ Type AUDIO = new Type();
        public static final /* enum */ Type BINARY = new Type();
        public static final /* enum */ Type DOCUMENTATION = new Type();
        public static final /* enum */ Type IMAGE = new Type();
        public static final /* enum */ Type OTHER = new Type();
        public static final /* enum */ Type SOURCE = new Type();
        public static final /* enum */ Type SPDX = new Type();
        public static final /* enum */ Type TEXT = new Type();
        public static final /* enum */ Type VIDEO = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.APPLICATION, Type.ARCHIVE, Type.AUDIO, Type.BINARY, Type.DOCUMENTATION, Type.IMAGE, Type.OTHER, Type.SOURCE, Type.SPDX, Type.TEXT, Type.VIDEO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

