/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.model.SpdxChecksum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxPackageVerificationCode;", "", "packageVerificationCodeExcludedFiles", "", "", "packageVerificationCodeValue", "(Ljava/util/List;Ljava/lang/String;)V", "getPackageVerificationCodeExcludedFiles", "()Ljava/util/List;", "getPackageVerificationCodeValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "spdx-utils"})
public final class SpdxPackageVerificationCode {
    @NotNull
    private final List<String> packageVerificationCodeExcludedFiles;
    @NotNull
    private final String packageVerificationCodeValue;

    public SpdxPackageVerificationCode(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> packageVerificationCodeExcludedFiles, @NotNull String packageVerificationCodeValue) {
        Intrinsics.checkNotNullParameter(packageVerificationCodeExcludedFiles, (String)"packageVerificationCodeExcludedFiles");
        Intrinsics.checkNotNullParameter((Object)packageVerificationCodeValue, (String)"packageVerificationCodeValue");
        this.packageVerificationCodeExcludedFiles = packageVerificationCodeExcludedFiles;
        this.packageVerificationCodeValue = packageVerificationCodeValue;
        CharSequence charSequence = this.packageVerificationCodeValue;
        if (!SpdxChecksum.Companion.getHEX_SYMBOLS_REGEX$spdx_utils().matches(charSequence)) {
            boolean $i$a$-require-SpdxPackageVerificationCode$32 = false;
            String $i$a$-require-SpdxPackageVerificationCode$32 = "The package verification code must only contain lower case hexadecimal digits but was '" + this.packageVerificationCodeValue + "'.";
            throw new IllegalArgumentException($i$a$-require-SpdxPackageVerificationCode$32.toString());
        }
        if (!(SpdxChecksum.Algorithm.SHA1.getChecksumHexDigits() == this.packageVerificationCodeValue.length())) {
            boolean bl = false;
            String string = "Expected a checksum value with " + SpdxChecksum.Algorithm.SHA1.getChecksumHexDigits() + " hexadecimal digits, but found " + this.packageVerificationCodeValue.length() + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SpdxPackageVerificationCode(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list, string);
    }

    @NotNull
    public final List<String> getPackageVerificationCodeExcludedFiles() {
        return this.packageVerificationCodeExcludedFiles;
    }

    @NotNull
    public final String getPackageVerificationCodeValue() {
        return this.packageVerificationCodeValue;
    }

    @NotNull
    public final List<String> component1() {
        return this.packageVerificationCodeExcludedFiles;
    }

    @NotNull
    public final String component2() {
        return this.packageVerificationCodeValue;
    }

    @NotNull
    public final SpdxPackageVerificationCode copy(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> packageVerificationCodeExcludedFiles, @NotNull String packageVerificationCodeValue) {
        Intrinsics.checkNotNullParameter(packageVerificationCodeExcludedFiles, (String)"packageVerificationCodeExcludedFiles");
        Intrinsics.checkNotNullParameter((Object)packageVerificationCodeValue, (String)"packageVerificationCodeValue");
        return new SpdxPackageVerificationCode(packageVerificationCodeExcludedFiles, packageVerificationCodeValue);
    }

    public static /* synthetic */ SpdxPackageVerificationCode copy$default(SpdxPackageVerificationCode spdxPackageVerificationCode, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = spdxPackageVerificationCode.packageVerificationCodeExcludedFiles;
        }
        if ((n & 2) != 0) {
            string = spdxPackageVerificationCode.packageVerificationCodeValue;
        }
        return spdxPackageVerificationCode.copy(list, string);
    }

    @NotNull
    public String toString() {
        return "SpdxPackageVerificationCode(packageVerificationCodeExcludedFiles=" + this.packageVerificationCodeExcludedFiles + ", packageVerificationCodeValue=" + this.packageVerificationCodeValue + ")";
    }

    public int hashCode() {
        int result = ((Object)this.packageVerificationCodeExcludedFiles).hashCode();
        result = result * 31 + this.packageVerificationCodeValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpdxPackageVerificationCode)) {
            return false;
        }
        SpdxPackageVerificationCode spdxPackageVerificationCode = (SpdxPackageVerificationCode)other;
        if (!Intrinsics.areEqual(this.packageVerificationCodeExcludedFiles, spdxPackageVerificationCode.packageVerificationCodeExcludedFiles)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.packageVerificationCodeValue, (Object)spdxPackageVerificationCode.packageVerificationCodeValue);
    }
}

