/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.model.SpdxAnnotation;

@JsonIgnoreProperties(value={"ranges"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001Bg\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0003\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0003\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003Jo\u0010#\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0003\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0003\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0003\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006*"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/model/SpdxSnippet;", "", "spdxId", "", "annotations", "", "Lorg/ossreviewtoolkit/utils/spdx/model/SpdxAnnotation;", "comment", "copyrightText", "licenseComments", "licenseConcluded", "licenseInfoInSnippets", "name", "snippetFromFile", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getAnnotations", "()Ljava/util/List;", "getComment", "()Ljava/lang/String;", "getCopyrightText", "getLicenseComments", "getLicenseConcluded", "getLicenseInfoInSnippets", "getName", "getSnippetFromFile", "getSpdxId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxSnippet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxSnippet.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxSnippet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n819#2:119\n847#2,2:120\n*S KotlinDebug\n*F\n+ 1 SpdxSnippet.kt\norg/ossreviewtoolkit/utils/spdx/model/SpdxSnippet\n*L\n106#1:119\n106#1:120,2\n*E\n"})
public final class SpdxSnippet {
    @NotNull
    private final String spdxId;
    @NotNull
    private final List<SpdxAnnotation> annotations;
    @NotNull
    private final String comment;
    @NotNull
    private final String copyrightText;
    @NotNull
    private final String licenseComments;
    @NotNull
    private final String licenseConcluded;
    @NotNull
    private final List<String> licenseInfoInSnippets;
    @NotNull
    private final String name;
    @NotNull
    private final String snippetFromFile;

    /*
     * WARNING - void declaration
     */
    public SpdxSnippet(@JsonProperty(value="SPDXID") @NotNull String spdxId, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<SpdxAnnotation> annotations, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String comment, @NotNull String copyrightText, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String licenseComments, @NotNull String licenseConcluded, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> licenseInfoInSnippets, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String name, @NotNull String snippetFromFile) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spdxId, (String)"spdxId");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)copyrightText, (String)"copyrightText");
        Intrinsics.checkNotNullParameter((Object)licenseComments, (String)"licenseComments");
        Intrinsics.checkNotNullParameter((Object)licenseConcluded, (String)"licenseConcluded");
        Intrinsics.checkNotNullParameter(licenseInfoInSnippets, (String)"licenseInfoInSnippets");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)snippetFromFile, (String)"snippetFromFile");
        this.spdxId = spdxId;
        this.annotations = annotations;
        this.comment = comment;
        this.copyrightText = copyrightText;
        this.licenseComments = licenseComments;
        this.licenseConcluded = licenseConcluded;
        this.licenseInfoInSnippets = licenseInfoInSnippets;
        this.name = name;
        this.snippetFromFile = snippetFromFile;
        if (!StringsKt.startsWith$default((String)this.spdxId, (String)"SPDXRef-", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-SpdxSnippet$42 = false;
            String $i$a$-require-SpdxSnippet$42 = "The SPDX ID '" + this.spdxId + "' has to start with 'SPDXRef-'.";
            throw new IllegalArgumentException($i$a$-require-SpdxSnippet$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.copyrightText))) {
            boolean $i$a$-require-SpdxSnippet$52 = false;
            String $i$a$-require-SpdxSnippet$52 = "The copyright text must not be blank.";
            throw new IllegalArgumentException($i$a$-require-SpdxSnippet$52.toString());
        }
        if (!ExtensionsKt.isSpdxExpressionOrNotPresent$default(this.licenseConcluded, null, 1, null)) {
            boolean $i$a$-require-SpdxSnippet$72 = false;
            String $i$a$-require-SpdxSnippet$72 = "The license concluded must be either an SpdxExpression, 'NONE' or 'NOASSERTION', but was " + this.licenseConcluded + ".";
            throw new IllegalArgumentException($i$a$-require-SpdxSnippet$72.toString());
        }
        Iterable $this$filterNot$iv = this.licenseInfoInSnippets;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (ExtensionsKt.isSpdxExpressionOrNotPresent$default(it, null, 1, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invalidEntries = (List)destination$iv$iv;
        boolean bl = false;
        if (!invalidEntries.isEmpty()) {
            boolean bl2 = false;
            String string = "The entries in licenseInfoInSnippets must each be either an SpdxExpression, 'NONE' or 'NOASSERTION', but found " + CollectionsKt.joinToString$default((Iterable)invalidEntries, null, null, null, (int)0, null, null, (int)63, null) + ".";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.snippetFromFile))) {
            boolean bl3 = false;
            String string = "The snippet from file must not be blank.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SpdxSnippet(String string, List list, String string2, String string3, String string4, String string5, List list2, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "NOASSERTION";
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string6 = "";
        }
        this(string, list, string2, string3, string4, string5, list2, string6, string7);
    }

    @NotNull
    public final String getSpdxId() {
        return this.spdxId;
    }

    @NotNull
    public final List<SpdxAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    @NotNull
    public final String getCopyrightText() {
        return this.copyrightText;
    }

    @NotNull
    public final String getLicenseComments() {
        return this.licenseComments;
    }

    @NotNull
    public final String getLicenseConcluded() {
        return this.licenseConcluded;
    }

    @NotNull
    public final List<String> getLicenseInfoInSnippets() {
        return this.licenseInfoInSnippets;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getSnippetFromFile() {
        return this.snippetFromFile;
    }

    @NotNull
    public final String component1() {
        return this.spdxId;
    }

    @NotNull
    public final List<SpdxAnnotation> component2() {
        return this.annotations;
    }

    @NotNull
    public final String component3() {
        return this.comment;
    }

    @NotNull
    public final String component4() {
        return this.copyrightText;
    }

    @NotNull
    public final String component5() {
        return this.licenseComments;
    }

    @NotNull
    public final String component6() {
        return this.licenseConcluded;
    }

    @NotNull
    public final List<String> component7() {
        return this.licenseInfoInSnippets;
    }

    @NotNull
    public final String component8() {
        return this.name;
    }

    @NotNull
    public final String component9() {
        return this.snippetFromFile;
    }

    @NotNull
    public final SpdxSnippet copy(@JsonProperty(value="SPDXID") @NotNull String spdxId, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<SpdxAnnotation> annotations, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String comment, @NotNull String copyrightText, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String licenseComments, @NotNull String licenseConcluded, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<String> licenseInfoInSnippets, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull String name, @NotNull String snippetFromFile) {
        Intrinsics.checkNotNullParameter((Object)spdxId, (String)"spdxId");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)copyrightText, (String)"copyrightText");
        Intrinsics.checkNotNullParameter((Object)licenseComments, (String)"licenseComments");
        Intrinsics.checkNotNullParameter((Object)licenseConcluded, (String)"licenseConcluded");
        Intrinsics.checkNotNullParameter(licenseInfoInSnippets, (String)"licenseInfoInSnippets");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)snippetFromFile, (String)"snippetFromFile");
        return new SpdxSnippet(spdxId, annotations, comment, copyrightText, licenseComments, licenseConcluded, licenseInfoInSnippets, name, snippetFromFile);
    }

    public static /* synthetic */ SpdxSnippet copy$default(SpdxSnippet spdxSnippet, String string, List list, String string2, String string3, String string4, String string5, List list2, String string6, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string = spdxSnippet.spdxId;
        }
        if ((n & 2) != 0) {
            list = spdxSnippet.annotations;
        }
        if ((n & 4) != 0) {
            string2 = spdxSnippet.comment;
        }
        if ((n & 8) != 0) {
            string3 = spdxSnippet.copyrightText;
        }
        if ((n & 0x10) != 0) {
            string4 = spdxSnippet.licenseComments;
        }
        if ((n & 0x20) != 0) {
            string5 = spdxSnippet.licenseConcluded;
        }
        if ((n & 0x40) != 0) {
            list2 = spdxSnippet.licenseInfoInSnippets;
        }
        if ((n & 0x80) != 0) {
            string6 = spdxSnippet.name;
        }
        if ((n & 0x100) != 0) {
            string7 = spdxSnippet.snippetFromFile;
        }
        return spdxSnippet.copy(string, list, string2, string3, string4, string5, list2, string6, string7);
    }

    @NotNull
    public String toString() {
        return "SpdxSnippet(spdxId=" + this.spdxId + ", annotations=" + this.annotations + ", comment=" + this.comment + ", copyrightText=" + this.copyrightText + ", licenseComments=" + this.licenseComments + ", licenseConcluded=" + this.licenseConcluded + ", licenseInfoInSnippets=" + this.licenseInfoInSnippets + ", name=" + this.name + ", snippetFromFile=" + this.snippetFromFile + ")";
    }

    public int hashCode() {
        int result = this.spdxId.hashCode();
        result = result * 31 + ((Object)this.annotations).hashCode();
        result = result * 31 + this.comment.hashCode();
        result = result * 31 + this.copyrightText.hashCode();
        result = result * 31 + this.licenseComments.hashCode();
        result = result * 31 + this.licenseConcluded.hashCode();
        result = result * 31 + ((Object)this.licenseInfoInSnippets).hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.snippetFromFile.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpdxSnippet)) {
            return false;
        }
        SpdxSnippet spdxSnippet = (SpdxSnippet)other;
        if (!Intrinsics.areEqual((Object)this.spdxId, (Object)spdxSnippet.spdxId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.annotations, spdxSnippet.annotations)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.comment, (Object)spdxSnippet.comment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.copyrightText, (Object)spdxSnippet.copyrightText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseComments, (Object)spdxSnippet.licenseComments)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseConcluded, (Object)spdxSnippet.licenseConcluded)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licenseInfoInSnippets, spdxSnippet.licenseInfoInSnippets)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)spdxSnippet.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.snippetFromFile, (Object)spdxSnippet.snippetFromFile);
    }
}

