/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.test;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.downloader.WorkingTree;
import org.ossreviewtoolkit.model.AdvisorRecord;
import org.ossreviewtoolkit.model.AdvisorResult;
import org.ossreviewtoolkit.model.AdvisorRun;
import org.ossreviewtoolkit.model.ArtifactProvenance;
import org.ossreviewtoolkit.model.CopyrightFinding;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.FileList;
import org.ossreviewtoolkit.model.Hash;
import org.ossreviewtoolkit.model.HashAlgorithm;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.LicenseFinding;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.ProvenanceResolutionResult;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.ScannerRun;
import org.ossreviewtoolkit.model.SnippetFinding;
import org.ossreviewtoolkit.model.config.AdvisorConfiguration;
import org.ossreviewtoolkit.model.utils.ExtensionsKt;
import org.ossreviewtoolkit.model.utils.PurlUtilsKt;
import org.ossreviewtoolkit.utils.ort.Environment;
import org.ossreviewtoolkit.utils.test.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aC\u0010\u000b\u001a\u00020\f26\u0010\r\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f0\u000e\"\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u001a.\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a0\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\b2\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001b\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015\u001aC\u0010$\u001a\u00020%26\u0010&\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00110\u000f0\u000e\"\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00110\u000f\u00a2\u0006\u0002\u0010(\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"ENV_TOOL_REGEX", "Lkotlin/text/Regex;", "ENV_VAR_REGEX", "JAVA_VERSION_REGEX", "ORT_VERSION_REGEX", "START_AND_END_TIME_REGEX", "TIMESTAMP_REGEX", "USER_DIR", "Ljava/io/File;", "getUSER_DIR", "()Ljava/io/File;", "advisorRunOf", "Lorg/ossreviewtoolkit/model/AdvisorRun;", "results", "", "Lkotlin/Pair;", "Lorg/ossreviewtoolkit/model/Identifier;", "", "Lorg/ossreviewtoolkit/model/AdvisorResult;", "([Lkotlin/Pair;)Lorg/ossreviewtoolkit/model/AdvisorRun;", "getAssetAsString", "", "path", "getAssetFile", "patchActualResult", "result", "custom", "", "patchStartAndEndTime", "", "patchExpectedResult", "expectedResultFile", "definitionFile", "readOrtResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "file", "scannerRunOf", "Lorg/ossreviewtoolkit/model/ScannerRun;", "pkgScanResults", "Lorg/ossreviewtoolkit/model/ScanResult;", "([Lkotlin/Pair;)Lorg/ossreviewtoolkit/model/ScannerRun;", "test-utils"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/ossreviewtoolkit/utils/test/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,212:1\n1789#2,3:213\n1789#2,3:216\n1549#2:225\n1620#2,2:226\n1622#2:229\n1620#2,3:231\n1603#2,9:234\n1855#2:243\n1620#2,3:244\n1620#2,3:247\n1620#2,3:250\n1856#2:254\n1612#2:255\n1490#2:256\n1520#2,3:257\n1523#2,3:267\n1238#2,4:272\n1620#2,3:278\n1620#2,3:286\n50#3:219\n43#3:220\n8406#4,2:221\n9088#4,2:223\n9091#4:230\n8406#4,2:282\n9088#4,2:284\n9091#4:289\n1#5:228\n1#5:253\n372#6,7:260\n453#6:270\n403#6:271\n152#7,2:276\n154#7:281\n152#7,3:290\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/ossreviewtoolkit/utils/test/UtilsKt\n*L\n115#1:213,3\n134#1:216,3\n152#1:225\n152#1:226,2\n152#1:229\n164#1:231,3\n171#1:234,9\n171#1:243\n175#1:244,3\n176#1:247,3\n177#1:250,3\n171#1:254\n171#1:255\n181#1:256\n181#1:257,3\n181#1:267,3\n181#1:272,4\n186#1:278,3\n192#1:286,3\n145#1:219\n145#1:220\n151#1:221,2\n151#1:223,2\n151#1:230\n191#1:282,2\n191#1:284,2\n191#1:289\n171#1:253\n181#1:260,7\n181#1:270\n181#1:271\n183#1:276,2\n183#1:281\n196#1:290,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final File USER_DIR = new File(System.getProperty("user.dir"));
    @NotNull
    private static final Regex ORT_VERSION_REGEX = new Regex("(ort_version): \".*\"");
    @NotNull
    private static final Regex JAVA_VERSION_REGEX = new Regex("(java_version): \".*\"");
    @NotNull
    private static final Regex ENV_VAR_REGEX = new Regex("(\\s{4}variables:)\\n(?:\\s{6}.+)+");
    @NotNull
    private static final Regex ENV_TOOL_REGEX = new Regex("(\\s{4}tool_versions:)\\n(?:\\s{6}.+)+");
    @NotNull
    private static final Regex START_AND_END_TIME_REGEX = new Regex("((start|end)_time): \".*\"");
    @NotNull
    private static final Regex TIMESTAMP_REGEX = new Regex("(timestamp): \".*\"");

    @NotNull
    public static final File getUSER_DIR() {
        return USER_DIR;
    }

    @NotNull
    public static final AdvisorRun advisorRunOf(Pair<Identifier, ? extends List<AdvisorResult>> ... results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Instant instant2 = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        return new AdvisorRun(instant, instant2, new Environment(null, null, null, 0, 0L, null, null, 127, null), new AdvisorConfiguration(null, 1, null), new AdvisorRecord(MapsKt.toMap(results)));
    }

    @NotNull
    public static final String getAssetAsString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.readText$default((File)UtilsKt.getAssetFile(path), null, (int)1, null);
    }

    @NotNull
    public static final File getAssetFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File("src/funTest/assets", path).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String patchExpectedResult(@NotNull File expectedResultFile, @Nullable File definitionFile, @NotNull Map<String, String> custom) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)expectedResultFile, (String)"expectedResultFile");
        Intrinsics.checkNotNullParameter(custom, (String)"custom");
        Object object = MapsKt.createMapBuilder();
        Map $this$patchExpectedResult_u24lambda_u240 = object;
        boolean bl = false;
        $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_JAVA>", System.getProperty("java.version"));
        $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_OS>", System.getProperty("os.name"));
        $this$patchExpectedResult_u24lambda_u240.put("\"<REPLACE_PROCESSORS>\"", String.valueOf(Runtime.getRuntime().availableProcessors()));
        $this$patchExpectedResult_u24lambda_u240.put("\"<REPLACE_MAX_MEMORY>\"", String.valueOf(Runtime.getRuntime().maxMemory()));
        if (definitionFile != null) {
            File projectDir = definitionFile.getParentFile();
            Intrinsics.checkNotNull((Object)projectDir);
            WorkingTree workingTree = VersionControlSystem.Companion.forDirectory(projectDir);
            Intrinsics.checkNotNull((Object)workingTree);
            WorkingTree vcsDir = workingTree;
            String url = vcsDir.getRemoteUrl();
            String path = vcsDir.getPathToRoot(projectDir);
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_DEFINITION_FILE_PATH>", path + "/" + definitionFile.getName());
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_ABSOLUTE_DEFINITION_FILE_PATH>", definitionFile.getAbsolutePath());
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_URL>", url);
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_REVISION>", vcsDir.getRevision());
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_PATH>", path);
            $this$patchExpectedResult_u24lambda_u240.put("<REPLACE_URL_PROCESSED>", org.ossreviewtoolkit.utils.ort.UtilsKt.normalizeVcsUrl((String)url));
        }
        $this$patchExpectedResult_u24lambda_u240.putAll(custom);
        Map replacements = MapsKt.build((Map)object);
        object = replacements.entrySet();
        String initial$iv = FilesKt.readText$default((File)expectedResultFile, null, (int)1, null);
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            String text = accumulator$iv;
            boolean bl2 = false;
            String oldValue = (String)entry.getKey();
            String newValue = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)newValue);
            accumulator$iv = StringsKt.replace$default((String)text, (String)oldValue, (String)newValue, (boolean)false, (int)4, null);
        }
        return accumulator$iv;
    }

    public static /* synthetic */ String patchExpectedResult$default(File file, File file2, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return UtilsKt.patchExpectedResult(file, file2, map);
    }

    @NotNull
    public static final String patchActualResult(@NotNull String result, @NotNull Map<String, String> custom, boolean patchStartAndEndTime) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(custom, (String)"custom");
        Iterable $this$fold$iv = custom.entrySet();
        boolean $i$f$fold = false;
        String accumulator$iv = result;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            String text = accumulator$iv;
            boolean bl = false;
            String pattern = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            CharSequence charSequence = text;
            accumulator$iv = new Regex(pattern).replace(charSequence, replacement);
        }
        CharSequence charSequence = accumulator$iv;
        Regex regex = ORT_VERSION_REGEX;
        Function1 function1 = patchActualResult.2.INSTANCE;
        charSequence = regex.replace(charSequence, function1);
        regex = JAVA_VERSION_REGEX;
        function1 = patchActualResult.3.INSTANCE;
        charSequence = regex.replace(charSequence, function1);
        regex = ENV_VAR_REGEX;
        function1 = patchActualResult.4.INSTANCE;
        charSequence = regex.replace(charSequence, function1);
        regex = ENV_TOOL_REGEX;
        function1 = patchActualResult.5.INSTANCE;
        charSequence = regex.replace(charSequence, function1);
        regex = TIMESTAMP_REGEX;
        function1 = patchActualResult.6.INSTANCE;
        return UtilsKt.patchActualResult$replaceIf(regex.replace(charSequence, function1), patchStartAndEndTime, START_AND_END_TIME_REGEX, (Function1<? super MatchResult, ? extends CharSequence>)((Function1)patchActualResult.7.INSTANCE));
    }

    public static /* synthetic */ String patchActualResult$default(String string, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.patchActualResult(string, map, bl);
    }

    @NotNull
    public static final OrtResult readOrtResult(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.readOrtResult(new File(file));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OrtResult readOrtResult(@NotNull File file) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObjectMapper objectMapper = FileFormatKt.mapper((File)file);
        String content$iv = UtilsKt.patchExpectedResult$default(file, null, null, 6, null);
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (OrtResult)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<OrtResult>(){});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ScannerRun scannerRunOf(Pair<Identifier, ? extends List<ScanResult>> ... pkgScanResults) {
        void destination$iv;
        void $this$mapTo$iv;
        Collection $this$associateTo$iv$iv;
        void destination$iv2;
        Pair<Identifier, ? extends List<ScanResult>>[] item$iv;
        void $this$mapTo$iv2;
        Object filePathsByProvenance;
        Collection $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        void destination$iv3;
        void $this$mapTo$iv3;
        Collection collection;
        Object object2;
        Object object3;
        void $this$associateTo$iv$iv2;
        Intrinsics.checkNotNullParameter(pkgScanResults, (String)"pkgScanResults");
        Pair<Identifier, ? extends List<ScanResult>>[] $this$associate$iv = pkgScanResults;
        boolean $i$f$associate22 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        Pair<Identifier, ? extends List<ScanResult>>[] pairArray = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Provenance element$iv$iv : $this$associateTo$iv$iv2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object3 = destination$iv$iv;
            Pair pair = element$iv$iv;
            boolean bl = false;
            Identifier id = (Identifier)pair.component1();
            List scanResultsForId = (List)pair.component2();
            Iterable iterable = scanResultsForId;
            object2 = id;
            boolean $i$f$map = false;
            void var19_74 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void scanResult;
                void var27_98;
                ScanResult scanResult2 = (ScanResult)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void it = var27_98 = scanResult;
                boolean bl3 = false;
                Object object4 = scanResult.getProvenance() instanceof KnownProvenance ? var27_98 : null;
                if (object4 == null) {
                    object4 = ScanResult.copy$default((ScanResult)scanResult, (Provenance)((Provenance)new ArtifactProvenance(new RemoteArtifact(PurlUtilsKt.toPurl$default((Identifier)id, null, null, (int)3, null), new Hash("", HashAlgorithm.NONE)))), null, null, null, (int)14, null);
                }
                collection.add(object4);
            }
            pair = TuplesKt.to((Object)object2, (Object)((List)destination$iv$iv2));
            object3.put(pair.getFirst(), pair.getSecond());
        }
        Map pkgScanResultsWithKnownProvenance = destination$iv$iv;
        Iterable $i$f$associate22 = CollectionsKt.flatten((Iterable)pkgScanResultsWithKnownProvenance.values());
        Collection capacity$iv22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv3) {
            void scanResult;
            Provenance element$iv$iv;
            ScanResult scanResult3 = (ScanResult)item$iv2;
            object = destination$iv3;
            boolean bl = false;
            element$iv$iv = scanResult.getProvenance();
            RepositoryProvenance repositoryProvenance = element$iv$iv instanceof RepositoryProvenance ? (RepositoryProvenance)element$iv$iv : null;
            object.add(ScanResult.copy$default((ScanResult)scanResult, (Provenance)(repositoryProvenance != null && (repositoryProvenance = ExtensionsKt.clearVcsPath((RepositoryProvenance)repositoryProvenance)) != null && (repositoryProvenance = ExtensionsKt.alignRevisions((RepositoryProvenance)repositoryProvenance)) != null ? (Provenance)repositoryProvenance : scanResult.getProvenance()), null, null, null, (int)14, null));
        }
        Set scanResults = (Set)destination$iv3;
        Iterable $this$mapNotNull$iv = scanResults;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object3 = $this$forEach$iv$iv$iv.iterator();
        while (object3.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object3.next();
            boolean bl = false;
            ScanResult scanResult = (ScanResult)element$iv$iv;
            boolean bl4 = false;
            object2 = scanResult.getProvenance();
            if ((object2 instanceof KnownProvenance ? (KnownProvenance)object2 : null) == null) {
                pair = null;
            } else {
                LicenseFinding it;
                Collection bl2;
                KnownProvenance provenance;
                provenance = provenance;
                Object $this$scannerRunOf_u24lambda_u2411_u24lambda_u2410 = object2 = SetsKt.createSetBuilder();
                boolean bl5 = false;
                Iterable $this$mapTo$iv4 = scanResult.getSummary().getCopyrightFindings();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv3 : $this$mapTo$iv4) {
                    collection = (CopyrightFinding)item$iv3;
                    bl2 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                    boolean bl6 = false;
                    bl2.add(it.getLocation().getPath());
                }
                Collection cfr_ignored_0 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                $this$mapTo$iv4 = scanResult.getSummary().getLicenseFindings();
                $i$f$mapTo2 = false;
                for (Object item$iv3 : $this$mapTo$iv4) {
                    it = (LicenseFinding)item$iv3;
                    bl2 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                    boolean bl7 = false;
                    bl2.add(it.getLocation().getPath());
                }
                Collection cfr_ignored_1 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                $this$mapTo$iv4 = scanResult.getSummary().getSnippetFindings();
                $i$f$mapTo2 = false;
                for (Object item$iv3 : $this$mapTo$iv4) {
                    it = (SnippetFinding)item$iv3;
                    bl2 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                    boolean bl8 = false;
                    bl2.add(it.getSourceLocation().getPath());
                }
                Collection cfr_ignored_2 = (Collection)$this$scannerRunOf_u24lambda_u2411_u24lambda_u2410;
                Set paths = SetsKt.build((Set)object2);
                pair = TuplesKt.to((Object)provenance, (Object)paths);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl9 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object5;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-UtilsKt$scannerRunOf$filePathsByProvenance$42 = false;
            KnownProvenance key$iv$iv = (KnownProvenance)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            Pair $i$a$-groupBy-UtilsKt$scannerRunOf$filePathsByProvenance$42 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((Set)it.getSecond());
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$mapValues22 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean bl11 = false;
            Map.Entry value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl10 = false;
            Set set = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((Iterable)it.getValue())));
            object.put(k, set);
        }
        Object $i$f$mapValues22 = filePathsByProvenance = destination$iv$iv3;
        $this$mapValuesTo$iv$iv = new LinkedHashSet();
        boolean $i$f$mapTo3 = false;
        Iterator $i$f$mapValuesTo22 = $this$mapTo$iv2.entrySet().iterator();
        while ($i$f$mapValuesTo22.hasNext()) {
            void destination$iv4;
            void $this$mapTo$iv5;
            Pair<Identifier, ? extends List<ScanResult>>[] $i$f$associateByTo2 = item$iv = $i$f$mapValuesTo22.next();
            object = destination$iv2;
            boolean bl = false;
            KnownProvenance provenance = (KnownProvenance)$i$f$associateByTo2.getKey();
            Set paths = (Set)$i$f$associateByTo2.getValue();
            Iterable $this$getOrPut$iv$iv$iv = paths;
            Collection bl11 = new LinkedHashSet();
            KnownProvenance it = provenance;
            boolean $i$f$mapTo4 = false;
            for (Object item$iv4 : $this$mapTo$iv5) {
                void it3;
                Object item$iv$iv;
                String $i$f$mapTo5 = (String)item$iv4;
                item$iv$iv = destination$iv4;
                boolean bl12 = false;
                item$iv$iv.add(new FileList.Entry((String)it3, HashAlgorithm.SHA1.calculate(StringsKt.encodeToByteArray((String)it3))));
            }
            Set set = (Set)destination$iv4;
            KnownProvenance knownProvenance = it;
            object.add(new FileList(knownProvenance, set));
        }
        Set files = (Set)destination$iv2;
        Pair<Identifier, ? extends List<ScanResult>>[] $this$associate$iv2 = pkgScanResults;
        boolean $i$f$associate = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv2.length), (int)16);
        item$iv = $this$associate$iv2;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv32);
        boolean $i$f$associateTo2 = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            void destination$iv5;
            void $this$mapTo$iv6;
            Map destination$iv4 = destination$iv$iv4;
            Pair it = element$iv$iv;
            boolean bl = false;
            Identifier id = (Identifier)it.component1();
            List scanResultsForId = (List)it.component2();
            Iterable bl5 = scanResultsForId;
            Collection item$iv4 = new LinkedHashSet();
            Identifier identifier = id;
            boolean $i$f$mapTo6 = false;
            for (Object item$iv5 : $this$mapTo$iv6) {
                void it4;
                ScanResult bl2 = (ScanResult)item$iv5;
                void var27_100 = destination$iv5;
                boolean bl13 = false;
                var27_100.add(it4.getScanner().getName());
            }
            it = TuplesKt.to((Object)identifier, (Object)destination$iv5);
            destination$iv4.put(it.getFirst(), it.getSecond());
        }
        Map scanners = destination$iv$iv4;
        ScannerRun scannerRun = ScannerRun.EMPTY;
        Map capacity$iv32 = pkgScanResultsWithKnownProvenance;
        $this$associateTo$iv$iv = new LinkedHashSet();
        boolean $i$f$mapTo7 = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv6;
            Map.Entry entry = item$iv6 = iterator.next();
            object = destination$iv;
            boolean bl = false;
            Identifier id = (Identifier)entry.getKey();
            List scanResultsForId = (List)entry.getValue();
            ScanResult scanResult = (ScanResult)CollectionsKt.firstOrNull((List)scanResultsForId);
            Object object6 = scanResult != null ? scanResult.getProvenance() : null;
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type org.ossreviewtoolkit.model.KnownProvenance");
            KnownProvenance packageProvenance = (KnownProvenance)object6;
            object.add(new ProvenanceResolutionResult(id, packageProvenance, MapsKt.emptyMap(), null, null));
        }
        Set set = (Set)destination$iv;
        return ScannerRun.copy$default((ScannerRun)scannerRun, null, null, null, null, (Set)set, (Set)scanResults, (Map)scanners, (Set)files, (int)15, null);
    }

    private static final String patchActualResult$replaceIf(String $this$patchActualResult_u24replaceIf, boolean condition, Regex regex, Function1<? super MatchResult, ? extends CharSequence> transform) {
        return condition ? regex.replace((CharSequence)$this$patchActualResult_u24replaceIf, transform) : $this$patchActualResult_u24replaceIf;
    }
}

