/**
 * OW2 Util
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 5830 2011-03-28 19:30:17Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.protocol.osgi.ssh.jsch;

import java.util.Properties;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.protocol.api.IProtocol;
import org.ow2.util.protocol.api.IShellFactory;
import org.ow2.util.protocol.api.ITransferProviderFactory;
import org.ow2.util.protocol.osgi.api.Constants;
import org.ow2.util.protocol.osgi.ssh.api.SshConstants;
import org.ow2.util.protocol.ssh.impl.jsch.*;
import org.ow2.util.protocol.ssh.impl.jsch.SftpTransferProviderFactory;

/**
 *
 * @author Loris Bouzonnet
 */
public class Activator implements BundleActivator {

    private ServiceRegistration sshProtocolReg;

    private ServiceRegistration sshShellReg;

    private ServiceRegistration sftpShellReg;

    private ServiceRegistration scpTransferProviderReg;

    private ServiceRegistration sftpTransferProviderReg;

    public void start(final BundleContext context) throws Exception {

        final IProtocol sshProtocol = new SshProtocol();
        final Properties sshProtocolProps = new Properties();
        sshProtocolProps.put(Constants.PROTOCOL_NAME, SshConstants.PROTOCOL_SSH);
        sshProtocolReg = context.registerService(IProtocol.class.getName(), sshProtocol, sshProtocolProps);

        final IShellFactory<SshProtocolSession> sshShellFactory = new SshShellFactory();
        final Properties sshShellProps = new Properties();
        sshShellProps.put(Constants.SHELL_PROVIDER_NAME, SshConstants.SHELL_SSH);
        sshShellReg = context.registerService(IShellFactory.class.getName(), sshShellFactory, sshShellProps);

        final IShellFactory<SshProtocolSession> sftpShellFactory = new SftpShellFactory();
        final Properties sftpShellProps = new Properties();
        sftpShellProps.put(Constants.SHELL_PROVIDER_NAME, SshConstants.SHELL_SFTP);
        sftpShellReg = context.registerService(IShellFactory.class.getName(), sftpShellFactory, sftpShellProps);

        final ITransferProviderFactory<SshProtocolSession> scpTransferProviderFactory =
                new ScpTransferProviderFactory();
        final Properties scpTransferFactoryProps = new Properties();
        scpTransferFactoryProps.put(Constants.TRANSFERT_PROVIDER_NAME, SshConstants.TRANSFERT_SCP);
        scpTransferProviderReg = context.registerService(
                ITransferProviderFactory.class.getName(), scpTransferProviderFactory, scpTransferFactoryProps);

        final ITransferProviderFactory<SshProtocolSession> sftpTransferProviderFactory =
                new SftpTransferProviderFactory();
        final Properties sftpTransferFactoryProps = new Properties();
        sftpTransferFactoryProps.put(Constants.TRANSFERT_PROVIDER_NAME, SshConstants.TRANSFERT_SFTP);
        sftpTransferProviderReg = context.registerService(
                ITransferProviderFactory.class.getName(), sftpTransferProviderFactory, sftpTransferFactoryProps);

    }

    public void stop(final BundleContext context) throws Exception {

        if (sshProtocolReg != null) {
            sshProtocolReg.unregister();
        }
        if (sshShellReg != null) {
            sshShellReg.unregister();
        }
        if (sftpShellReg != null) {
            sftpShellReg.unregister();
        }
        if (scpTransferProviderReg != null) {
            scpTransferProviderReg.unregister();
        }
        if (sftpTransferProviderReg != null) {
            sftpTransferProviderReg.unregister();
        }
    }

}
