/**
 * OW2 Util
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 6136 2012-01-25 08:33:47Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.protocol.osgi.ssh.jsch;

import java.util.Dictionary;
import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.protocol.api.IProtocol;
import org.ow2.util.protocol.api.IShellFactory;
import org.ow2.util.protocol.api.ITransferProviderFactory;
import org.ow2.util.protocol.osgi.api.Constants;
import org.ow2.util.protocol.osgi.ssh.api.SshConstants;
import org.ow2.util.protocol.ssh.impl.jsch.ScpTransferProviderFactory;
import org.ow2.util.protocol.ssh.impl.jsch.SftpShellFactory;
import org.ow2.util.protocol.ssh.impl.jsch.SftpTransferProviderFactory;
import org.ow2.util.protocol.ssh.impl.jsch.SshProtocol;
import org.ow2.util.protocol.ssh.impl.jsch.SshProtocolSession;
import org.ow2.util.protocol.ssh.impl.jsch.SshShellFactory;

/**
 *
 * @author Loris Bouzonnet
 */
public class Activator implements BundleActivator {

    private ServiceRegistration<IProtocol> sshProtocolReg;

    private ServiceRegistration<IShellFactory> sshShellReg;

    private ServiceRegistration<IShellFactory> sftpShellReg;

    private ServiceRegistration<ITransferProviderFactory> scpTransferProviderReg;

    private ServiceRegistration<ITransferProviderFactory> sftpTransferProviderReg;

    public void start(final BundleContext context) throws Exception {

        final IProtocol sshProtocol = new SshProtocol();
        final Dictionary<String, String> sshProtocolProps = new Hashtable<String, String>();
        sshProtocolProps.put(Constants.PROTOCOL_NAME, SshConstants.PROTOCOL_SSH);
        sshProtocolReg = context.registerService(IProtocol.class, sshProtocol, sshProtocolProps);

        final IShellFactory<SshProtocolSession> sshShellFactory = new SshShellFactory();
        final Dictionary<String, String> sshShellProps = new Hashtable<String, String>();
        sshShellProps.put(Constants.SHELL_PROVIDER_NAME, SshConstants.SHELL_SSH);
        sshShellReg = context.registerService(IShellFactory.class, sshShellFactory, sshShellProps);

        final IShellFactory<SshProtocolSession> sftpShellFactory = new SftpShellFactory();
        final Dictionary<String, String> sftpShellProps = new Hashtable<String, String>();
        sftpShellProps.put(Constants.SHELL_PROVIDER_NAME, SshConstants.SHELL_SFTP);
        sftpShellReg = context.registerService(IShellFactory.class, sftpShellFactory, sftpShellProps);

        final ITransferProviderFactory<SshProtocolSession> scpTransferProviderFactory =
                new ScpTransferProviderFactory();
        final Dictionary<String, String> scpTransferFactoryProps = new Hashtable<String, String>();
        scpTransferFactoryProps.put(Constants.TRANSFERT_PROVIDER_NAME, SshConstants.TRANSFERT_SCP);
        scpTransferProviderReg = context.registerService(
                ITransferProviderFactory.class, scpTransferProviderFactory, scpTransferFactoryProps);

        final ITransferProviderFactory<SshProtocolSession> sftpTransferProviderFactory =
                new SftpTransferProviderFactory();
        final Dictionary<String, String> sftpTransferFactoryProps = new Hashtable<String, String>();
        sftpTransferFactoryProps.put(Constants.TRANSFERT_PROVIDER_NAME, SshConstants.TRANSFERT_SFTP);
        sftpTransferProviderReg = context.registerService(
                ITransferProviderFactory.class, sftpTransferProviderFactory, sftpTransferFactoryProps);

    }

    public void stop(final BundleContext context) throws Exception {

        if (sshProtocolReg != null) {
            sshProtocolReg.unregister();
        }
        if (sshShellReg != null) {
            sshShellReg.unregister();
        }
        if (sftpShellReg != null) {
            sftpShellReg.unregister();
        }
        if (scpTransferProviderReg != null) {
            scpTransferProviderReg.unregister();
        }
        if (sftpTransferProviderReg != null) {
            sftpTransferProviderReg.unregister();
        }
    }

}
