/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TreeMap;

public class Console
extends Thread {
    private String name;
    private TreeMap<String, TokenInfos> listToken = new TreeMap();
    private InputStreamReader is = new InputStreamReader(System.in);
    private BufferedReader in = new BufferedReader(this.is);
    private String cmdLine;
    private String[] cmdWords;

    public Console(String name) {
        this.name = name;
        this.addToken("quit", 0, null, "leaves the console!");
    }

    private void displayHelp() {
        for (String tok : this.listToken.keySet()) {
            TokenInfos tokInf = this.listToken.get(tok);
            System.out.println(" - " + tok + ": " + tokInf.help);
        }
    }

    public void addToken(String tok, int nbArgs, TokenHandlerITF handler, String help) {
        TokenInfos tokInf = new TokenInfos(nbArgs, handler, help);
        this.listToken.put(tok, tokInf);
    }

    public void run() {
        System.out.println("Starting " + this.name + "...");
        do {
            System.out.print(this.name + ">");
            try {
                this.cmdLine = this.in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.cmdWords = this.cmdLine.split(" ");
            if (this.cmdWords[0].compareTo("?") == 0) {
                this.displayHelp();
                continue;
            }
            TokenInfos tokInf = this.listToken.get(this.cmdWords[0]);
            if (tokInf == null) {
                System.out.println("Unknown command");
                continue;
            }
            if (tokInf.nbArgs != this.cmdWords.length - 1) {
                System.out.println("Wrong number of arguments:" + (this.cmdWords.length - 1) + " instead of " + tokInf.nbArgs);
                continue;
            }
            if (tokInf.handler == null) continue;
            tokInf.handler.setArgs(this.cmdWords);
            tokInf.handler.handle();
        } while (this.cmdWords[0].compareToIgnoreCase("quit") != 0);
    }

    private final class TokenInfos {
        private int nbArgs;
        private TokenHandlerITF handler;
        private String help;

        private TokenInfos(int nbArgs, TokenHandlerITF handler, String help) {
            this.nbArgs = nbArgs;
            this.handler = handler;
            this.help = help;
        }
    }

    public static interface TokenHandlerITF {
        public void setArgs(String[] var1);

        public int handle();
    }
}

