/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.cmi.admin.CMIAdmin;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.rmi.JNDIConfig;
import org.ow2.cmi.test.Console;
import org.ow2.cmi.test.IIOPHelloServer;

public class IIOPHelloServerInteractive {
    private static ClusteredObjectInfo clusteredObjectInfo;
    private static CMIAdmin cmiAdmin;
    private static Context ic;
    private String msg;

    private static void displayRegistry(Context ctx) {
        System.out.println();
        System.out.println("/********************/");
        System.out.println("/* REGISTRY:");
        try {
            NamingEnumeration<NameClassPair> list = ctx.list(ctx.getNameInNamespace());
            while (list.hasMore()) {
                NameClassPair current = list.next();
                String name = current.getName();
                System.out.println("/*    - " + name);
                System.out.println("/*  Servers which own an instance of this:");
                List jndiRefs = cmiAdmin.getServerRefs(name, "iiop");
                for (String jndiRef : jndiRefs) {
                    System.out.println("/*  > " + jndiRef.toString());
                }
            }
            System.out.println("/********************/");
            System.out.println();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream("output/reports/errors-iiop.txt");
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);
        URL url = Thread.currentThread().getContextClassLoader().getResource("server-iiop.properties");
        Hashtable env = JNDIConfig.getCMIEnv((URL)url);
        ic = new InitialContext(env);
        cmiAdmin = CMIAdmin.getCMIAdmin();
        Console cons = new Console("server");
        cons.addToken("dispreg", 0, (Console.TokenHandlerITF)new DisplayRegistryHandler(), "displays the registry");
        cons.addToken("bind", 1, (Console.TokenHandlerITF)new BindHandler(), "bind with the name [arg]");
        cons.addToken("rebind", 1, (Console.TokenHandlerITF)new RebindHandler(), "rebind with the name [arg]");
        cons.addToken("unbind", 1, (Console.TokenHandlerITF)new UnbindHandler(), "unbind the name [arg]");
        cons.addToken("disprep", 0, (Console.TokenHandlerITF)new DisplayReplicatedRegistryHandler(), "displays the replicated registry");
        cons.start();
    }

    public void display() throws RemoteException {
        System.out.println("Hello " + this.msg);
    }

    public ClusteredObjectInfo getClusteredObjectInfo() {
        return clusteredObjectInfo;
    }

    static {
        cmiAdmin = null;
    }

    protected static class UnbindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public UnbindHandler() {
        }

        public UnbindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Unbinding \"" + this.args[1] + "\"...");
                ic.unbind(this.args[1]);
                System.out.println("OK");
            }
            catch (NamingException e) {
                System.out.print("Naming exception");
                e.printStackTrace();
                return 1;
            }
            return 0;
        }
    }

    protected static class RebindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public RebindHandler() {
        }

        public RebindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Rebinding \"" + this.args[1] + "\"...");
                IIOPHelloServer s = new IIOPHelloServer(this.args[1]);
                ic.rebind(this.args[1], (Object)s);
                System.out.println("OK");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class BindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public BindHandler() {
        }

        public BindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Binding \"" + this.args[1] + "\"...");
                IIOPHelloServer s = new IIOPHelloServer(this.args[1]);
                ic.bind(this.args[1], (Object)s);
                System.out.println("OK");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DisplayReplicatedRegistryHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            System.out.println();
            System.out.println("/*************************/");
            System.out.println("/* REPLICATED REGISTRY:");
            try {
                Set clusterNames = cmiAdmin.getClusterNames();
                for (String clusterName : clusterNames) {
                    System.out.println();
                    System.out.println("/* In the cluster " + clusterName + ":");
                    Set objectNames = cmiAdmin.getObjectNames(clusterName);
                    for (String objectName : objectNames) {
                        System.out.println("/*   " + objectName + " has:");
                        System.out.println("/*  - instance(s) in the following nodes:");
                        List jndiRefs = cmiAdmin.getServerRefs(objectName);
                        for (String jndiRef : jndiRefs) {
                            System.out.println("/*     >" + jndiRef);
                        }
                        System.out.println("/*  - for LB policy:");
                        System.out.println("/*     >" + cmiAdmin.getPolicyClassName(objectName));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("/*************************/");
            System.out.println();
            return 0;
        }
    }

    protected static class DisplayRegistryHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            IIOPHelloServerInteractive.displayRegistry(ic);
            return 0;
        }
    }
}

