/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.cmi.admin.CMIAdmin;
import org.ow2.cmi.annotation.Cluster;
import org.ow2.cmi.annotation.Policy;
import org.ow2.cmi.lb.policy.RoundRobin;
import org.ow2.cmi.rmi.JNDIConfig;
import org.ow2.cmi.test.Console;
import org.ow2.cmi.test.JRMPHelloServer;
import org.ow2.cmi.test.TestItf;

@Cluster(name="test_cluster")
@Policy(value=RoundRobin.class)
public class JRMPHelloServerInteractive {
    private static CMIAdmin cmiAdmin = null;
    private static Context ic;
    protected static HashMap<String, TestItf> testItfs;

    private static void displayRegistry(Context ctx) {
        System.out.println();
        System.out.println("/********************/");
        System.out.println("/* REGISTRY:");
        try {
            NamingEnumeration<NameClassPair> list = ctx.list(ctx.getNameInNamespace());
            while (list.hasMore()) {
                NameClassPair current = list.next();
                String name = current.getName();
                System.out.println("/*    - " + name);
                System.out.println("/*  Servers which own an instance of this:");
                List jndiRefs = cmiAdmin.getServerRefs(name, "jrmp");
                for (String jndiRef : jndiRefs) {
                    System.out.println("/*  > " + jndiRef.toString());
                }
            }
            System.out.println("/********************/");
            System.out.println();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream("output/reports/errors-jrmp.txt");
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);
        URL url = Thread.currentThread().getContextClassLoader().getResource("server-jrmp.properties");
        Hashtable env = JNDIConfig.getCMIEnv((URL)url);
        ic = new InitialContext(env);
        cmiAdmin = CMIAdmin.getCMIAdmin();
        Console cons = new Console("server");
        cons.addToken("dispreg", 0, (Console.TokenHandlerITF)new DisplayRegistryHandler(), "displays the registry");
        cons.addToken("lookup", 1, (Console.TokenHandlerITF)new LookupHandler(), "lookup with the name [arg]");
        cons.addToken("invoke", 1, (Console.TokenHandlerITF)new InvokeHandler(), "invoke with the name [arg]");
        cons.addToken("bind", 1, (Console.TokenHandlerITF)new BindHandler(), "bind with the name [arg]");
        cons.addToken("rebind", 1, (Console.TokenHandlerITF)new RebindHandler(), "rebind with the name [arg]");
        cons.addToken("unbind", 1, (Console.TokenHandlerITF)new UnbindHandler(), "unbind the name [arg]");
        cons.addToken("disprep", 0, (Console.TokenHandlerITF)new DisplayReplicatedRegistryHandler(), "displays the replicated registry");
        cons.addToken("dispInfos", 1, (Console.TokenHandlerITF)new DispInfosHandler(), "display infos for the name [arg]");
        cons.start();
    }

    static {
        testItfs = new HashMap();
    }

    protected static class DispInfosHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public DispInfosHandler() {
        }

        public DispInfosHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                List jndiRefs = cmiAdmin.getServerRefs(this.args[1], "jrmp");
                System.out.println("/************************/");
                System.out.println("/*     Cluster view     */");
                System.out.println("/* Node list:           */");
                if (jndiRefs != null) {
                    for (String jndiRef : jndiRefs) {
                        System.out.println("/*   " + jndiRef + "  */");
                    }
                }
                System.out.println("/* LB policy:           */");
                System.out.println("/*   " + cmiAdmin.getPolicyClassName(this.args[1]) + "  */");
                System.out.println("/************************/");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class UnbindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public UnbindHandler() {
        }

        public UnbindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Unbinding \"" + this.args[1] + "\"...");
                ic.unbind(this.args[1]);
                System.out.println("OK");
            }
            catch (NamingException e) {
                System.out.print("Naming exception");
                e.printStackTrace();
                return 1;
            }
            return 0;
        }
    }

    protected static class RebindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public RebindHandler() {
        }

        public RebindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Rebinding \"" + this.args[1] + "\"...");
                JRMPHelloServer s = new JRMPHelloServer(this.args[1]);
                ic.rebind(this.args[1], (Object)s);
                System.out.println("OK");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class BindHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public BindHandler() {
        }

        public BindHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Binding \"" + this.args[1] + "\"...");
                JRMPHelloServer s = new JRMPHelloServer(this.args[1]);
                ic.bind(this.args[1], (Object)s);
                System.out.println("OK");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DisplayReplicatedRegistryHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            System.out.println();
            System.out.println("/*************************/");
            System.out.println("/* REPLICATED REGISTRY:");
            try {
                Set clusterNames = cmiAdmin.getClusterNames();
                for (String clusterName : clusterNames) {
                    System.out.println();
                    System.out.println("/* In the cluster " + clusterName + ":");
                    Set objectNames = cmiAdmin.getObjectNames(clusterName);
                    for (String objectName : objectNames) {
                        System.out.println("/*   " + objectName + " has:");
                        System.out.println("/*  - instance(s) in the following nodes:");
                        List jndiRefs = cmiAdmin.getServerRefs(objectName);
                        for (String jndiRef : jndiRefs) {
                            System.out.println("/*     >" + jndiRef);
                        }
                        System.out.println("/*  - for LB policy:");
                        System.out.println("/*     >" + cmiAdmin.getPolicyClassName(objectName));
                        System.out.println("/*  - for LB strategy:");
                        System.out.println("/*     >" + cmiAdmin.getStrategyClassName(objectName));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("/*************************/");
            System.out.println();
            return 0;
        }
    }

    protected static class DisplayRegistryHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            JRMPHelloServerInteractive.displayRegistry(ic);
            return 0;
        }
    }

    protected static class InvokeHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public InvokeHandler() {
        }

        public InvokeHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Invoke \"" + this.args[1] + "\"...");
                testItfs.get(this.args[1]).display();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class LookupHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public LookupHandler() {
        }

        public LookupHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Lookup \"" + this.args[1] + "\"...");
                TestItf testItf = (TestItf)ic.lookup(this.args[1]);
                testItfs.put(this.args[1], testItf);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}

