/**
 * EasyBeans
 * Copyright (C) 2007,2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CmiConfigurationExtension.java 2710 2008-03-26 09:01:47Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.easybeans.component.cmi;

import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.server.EasyBeansConfigurationExtension;

/**
 * Called by Easybeans at runtime to provide a hook for CMI.
 * @author WEI Zhouyue & ZHU Ning
 */
public class CmiConfigurationExtension implements
        EasyBeansConfigurationExtension {

    /**
     * Adapt the given configuration by adding the callback for CMI.
     * @param jcc JContainerConfig instance.
     */
    public void configure(final EZBContainerConfig jcc) {
        // create the callback
        CmiLifeCycleCallback lifeCycleCallback = new CmiLifeCycleCallback();

        // add the callback in the configuration
        jcc.addCallback(lifeCycleCallback);
    }

}
