/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.ow2.easybeans.asm.Type;

public class JMethod {
    private String name = null;
    private int access;
    private String descriptor = null;
    private String signature;
    private final String[] exceptions;

    public JMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.exceptions = exceptions;
    }

    public int getAccess() {
        return this.access;
    }

    public JMethod(Method m) {
        this.name = m.getName();
        this.descriptor = Type.getMethodDescriptor((Method)m);
        this.exceptions = null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JMethod) {
            JMethod other = (JMethod)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.descriptor == null || this.descriptor.equals(other.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        sb.append("[name=");
        sb.append(this.name);
        sb.append(", access=");
        sb.append(this.access);
        if (this.descriptor != null) {
            sb.append(", descriptor=");
            sb.append(this.descriptor);
        }
        if (this.signature != null) {
            sb.append(", signature=");
            sb.append(this.signature);
        }
        if (this.exceptions != null) {
            sb.append(", exceptions=");
            sb.append(Arrays.asList(this.exceptions));
        }
        sb.append("]");
        return sb.toString();
    }
}

