/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import org.ow2.easybeans.asm.AnnotationVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxAnnotationSecurityPermitAllVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxAnnotationSecurityRolesAllowedVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxEjbTransactionAttributeVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxInterceptorExcludeDefaultInterceptorsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxInterceptorInterceptorsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanCommonVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxAnnotationPostConstructVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxAnnotationPreDestroyVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxAnnotationSecurityDenyAllVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxEjbInitVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxEjbPostActivateVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxEjbPrePassivateVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxEjbRemoveVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxEjbTimeoutVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxInterceptorAroundInvokeVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.method.JavaxInterceptorExcludeClassInterceptorsVisitor;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanMethodVisitor
extends ScanCommonVisitor<MethodAnnotationMetadata>
implements MethodVisitor {
    private MethodAnnotationMetadata methodAnnotationMetadata = null;
    private ClassAnnotationMetadata classAnnotationMetadata = null;

    public ScanMethodVisitor(JMethod jMethod, ClassAnnotationMetadata classAnnotationMetadata) {
        this.methodAnnotationMetadata = new MethodAnnotationMetadata(jMethod, classAnnotationMetadata);
        this.classAnnotationMetadata = classAnnotationMetadata;
        this.initVisitors();
    }

    private void initVisitors() {
        super.initVisitors(this.methodAnnotationMetadata);
        this.getAnnotationVisitors().put("Ljavax/ejb/Init;", new JavaxEjbInitVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/Remove;", new JavaxEjbRemoveVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/TransactionAttribute;", new JavaxEjbTransactionAttributeVisitor<MethodAnnotationMetadata>(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/PostConstruct;", new JavaxAnnotationPostConstructVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/PreDestroy;", new JavaxAnnotationPreDestroyVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/PostActivate;", new JavaxEjbPostActivateVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/PrePassivate;", new JavaxEjbPrePassivateVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/Timeout;", new JavaxEjbTimeoutVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/AroundInvoke;", new JavaxInterceptorAroundInvokeVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/Interceptors;", new JavaxInterceptorInterceptorsVisitor<MethodAnnotationMetadata>(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/ExcludeClassInterceptors;", new JavaxInterceptorExcludeClassInterceptorsVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/RolesAllowed;", new JavaxAnnotationSecurityRolesAllowedVisitor<MethodAnnotationMetadata>(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/PermitAll;", new JavaxAnnotationSecurityPermitAllVisitor<MethodAnnotationMetadata>(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/DenyAll;", new JavaxAnnotationSecurityDenyAllVisitor(this.methodAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/ExcludeDefaultInterceptors;", new JavaxInterceptorExcludeDefaultInterceptorsVisitor<MethodAnnotationMetadata>(this.methodAnnotationMetadata));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.getEmptyVisitor();
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return this.getEmptyVisitor();
    }

    public void visitEnd() {
        this.classAnnotationMetadata.addMethodAnnotationMetadata(this.methodAnnotationMetadata);
    }
}

