/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanClassVisitor;
import org.ow2.easybeans.deployment.annotations.exceptions.AnalyzerException;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarAnnotationDeploymentAnalyzer {
    private static Log logger = LogFactory.getLog(WarAnnotationDeploymentAnalyzer.class);
    private IArchive archive = null;
    private ClassLoader classLoader = null;
    private EjbJarAnnotationMetadata ejbJarAnnotationMetadata = null;
    private ScanClassVisitor scanVisitor = null;

    public WarAnnotationDeploymentAnalyzer(IArchive archive, ClassLoader classLoader) {
        this.archive = archive;
        this.ejbJarAnnotationMetadata = new EjbJarAnnotationMetadata();
        this.classLoader = classLoader;
        this.scanVisitor = new ScanClassVisitor(this.ejbJarAnnotationMetadata);
    }

    public void analyze(List<String> classNames) throws AnalyzerException {
        for (String className : classNames) {
            logger.debug((Object)"Analyzing ''{0}'' class of the archive ''{1}''", new Object[]{className, this.archive});
            InputStream is = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
            if (is == null) {
                logger.error((Object)("Unable to analyze the classname '" + className + "' of archive '" + this.archive + "' as it was not found in the classloader '" + this.classLoader + "'"), new Object[0]);
                continue;
            }
            try {
                new ClassReader(is).accept((ClassVisitor)this.scanVisitor, 0);
            }
            catch (Exception ioe) {
                throw new AnalyzerException("Error while analyzing the classname '" + className + "' of archive '" + this.archive + "' found in the classloader '" + this.classLoader + "'", ioe);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new AnalyzerException("Error while closing input stream of the entry '" + className + "' in archive '" + this.archive.getName() + "'", e);
                }
            }
        }
    }

    public EjbJarAnnotationMetadata getEjbJarAnnotationMetadata() {
        return this.ejbJarAnnotationMetadata;
    }
}

