/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.ow2.easybeans.deployment.annotations.ClassType;
import org.ow2.easybeans.deployment.annotations.InterceptorType;
import org.ow2.easybeans.deployment.annotations.JClassInterceptor;
import org.ow2.easybeans.deployment.annotations.JField;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.exceptions.InterceptorsValidationException;
import org.ow2.easybeans.deployment.annotations.impl.JAnnotationResource;
import org.ow2.easybeans.deployment.annotations.impl.JCommonBean;
import org.ow2.easybeans.deployment.annotations.impl.JEjbEJB;
import org.ow2.easybeans.deployment.annotations.impl.JInterceptors;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JMessageDriven;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.impl.JStateful;
import org.ow2.easybeans.deployment.annotations.impl.JStateless;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceContext;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceUnit;
import org.ow2.easybeans.deployment.annotations.metadata.CommonAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.FieldAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.IAnnotationSecurityPermitAll;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.IAnnotationSecurityRolesAllowed;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.IEJBInterceptors;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.IInterceptorExcludeDefaultInterceptors;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.ITransactionAttribute;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnnotationMetadata
extends CommonAnnotationMetadata
implements ITransactionAttribute,
IEJBInterceptors,
IAnnotationSecurityRolesAllowed,
IAnnotationSecurityPermitAll,
IInterceptorExcludeDefaultInterceptors {
    private static Log logger = LogFactory.getLog(ClassAnnotationMetadata.class);
    private Map<JMethod, MethodAnnotationMetadata> methodsAnnotationMetadata = null;
    private Map<JField, FieldAnnotationMetadata> fieldsAnnotationMetadata = null;
    private EjbJarAnnotationMetadata ejbJarAnnotationMetadata = null;
    private JLocal jLocal = null;
    private JRemote jRemote = null;
    private JCommonBean jCommonBean = null;
    private JMessageDriven jMessageDriven = null;
    private JStateless jStateless = null;
    private JStateful jStateful = null;
    private boolean orderedInterceptors = false;
    private String localHome = null;
    private String remoteHome = null;
    private JInterceptors annotationInterceptors = null;
    private List<JClassInterceptor> globalEasyBeansInterceptors = null;
    private Map<InterceptorType, List<JClassInterceptor>> externalUserInterceptors = null;
    private Map<InterceptorType, List<JClassInterceptor>> internalUserInterceptors = null;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private TransactionAttributeType transactionAttributeType = TransactionAttributeType.REQUIRED;
    private ApplicationException applicationException = null;
    private String superName = null;
    private String[] interfaces = null;
    private ClassType classType = null;
    private String className = null;
    private List<MethodAnnotationMetadata> aroundInvokeMethodsMetadata = null;
    private List<JEjbEJB> jEjbEJBs = null;
    private List<JAnnotationResource> jAnnotationResources = null;
    private List<JavaxPersistenceContext> javaxPersistencePersistenceContexts = null;
    private List<JavaxPersistenceUnit> javaxPersistencePersistenceUnits = null;
    private LinkedList<MethodAnnotationMetadata> postConstructMethodsMetadata = null;
    private LinkedList<MethodAnnotationMetadata> preDestroyMethodsMetadata = null;
    private LinkedList<MethodAnnotationMetadata> postActivateMethodsMetadata = null;
    private LinkedList<MethodAnnotationMetadata> prePassivateMethodsMetadata = null;
    private boolean modified = false;
    private List<String> declareRoles = null;
    private List<String> rolesAllowed = null;
    private boolean permitAll = false;
    private String runAs = null;
    private boolean excludeDefaultInterceptors = false;
    private String remoteInterface = null;

    public ClassAnnotationMetadata(String className, EjbJarAnnotationMetadata ejbJarAnnotationMetadata) {
        this.className = className;
        this.methodsAnnotationMetadata = new HashMap<JMethod, MethodAnnotationMetadata>();
        this.fieldsAnnotationMetadata = new HashMap<JField, FieldAnnotationMetadata>();
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
        this.postConstructMethodsMetadata = new LinkedList();
        this.preDestroyMethodsMetadata = new LinkedList();
        this.postActivateMethodsMetadata = new LinkedList();
        this.prePassivateMethodsMetadata = new LinkedList();
    }

    public String getClassName() {
        return this.className;
    }

    public void addMethodAnnotationMetadata(MethodAnnotationMetadata methodAnnotationMetadata) {
        JMethod key = methodAnnotationMetadata.getJMethod();
        this.methodsAnnotationMetadata.put(key, methodAnnotationMetadata);
    }

    public MethodAnnotationMetadata getMethodAnnotationMetadata(JMethod jMethod) {
        return this.methodsAnnotationMetadata.get(jMethod);
    }

    public List<MethodAnnotationMetadata> searchMethodAnnotationMetadata(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Cannot search null methods");
        }
        ArrayList<MethodAnnotationMetadata> list = new ArrayList<MethodAnnotationMetadata>();
        for (MethodAnnotationMetadata method : this.methodsAnnotationMetadata.values()) {
            if (!methodName.equals(method.getMethodName())) continue;
            list.add(method);
        }
        return list;
    }

    public List<FieldAnnotationMetadata> searchFieldAnnotationMetadata(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Cannot search null fields");
        }
        ArrayList<FieldAnnotationMetadata> list = new ArrayList<FieldAnnotationMetadata>();
        for (FieldAnnotationMetadata field : this.fieldsAnnotationMetadata.values()) {
            if (!fieldName.equals(field.getFieldName())) continue;
            list.add(field);
        }
        return list;
    }

    public Collection<MethodAnnotationMetadata> getMethodAnnotationMetadataCollection() {
        return this.methodsAnnotationMetadata.values();
    }

    public void addFieldAnnotationMetadata(FieldAnnotationMetadata fieldAnnotationMetadata) {
        JField key = fieldAnnotationMetadata.getJField();
        if (this.fieldsAnnotationMetadata.containsKey(key)) {
            String msg = logger.getI18n().getMessage("BeanAnnotationMetadata.addFieldAnnotationMetadata.alreadyPresent", new Object[]{key});
            logger.debug((Object)msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.fieldsAnnotationMetadata.put(key, fieldAnnotationMetadata);
    }

    public FieldAnnotationMetadata getFieldAnnotationMetadata(JField jField) {
        return this.fieldsAnnotationMetadata.get(jField);
    }

    public Collection<FieldAnnotationMetadata> getFieldAnnotationMetadataCollection() {
        return this.fieldsAnnotationMetadata.values();
    }

    public void setLocalInterfaces(JLocal jLocal) {
        this.jLocal = jLocal;
    }

    public void setRemoteInterfaces(JRemote jRemote) {
        this.jRemote = jRemote;
    }

    public JLocal getLocalInterfaces() {
        return this.jLocal;
    }

    public JRemote getRemoteInterfaces() {
        return this.jRemote;
    }

    public boolean isStateless() {
        return this.classType != null && this.classType == ClassType.STATELESS;
    }

    public boolean isStateful() {
        return this.classType != null && this.classType == ClassType.STATEFUL;
    }

    public boolean isSession() {
        return this.classType != null && (this.classType == ClassType.STATELESS || this.classType == ClassType.STATEFUL);
    }

    public boolean isMdb() {
        return this.classType != null && this.classType == ClassType.MDB;
    }

    public void setClassType(ClassType cType) {
        this.classType = cType;
    }

    public JMessageDriven getJMessageDriven() {
        return this.jMessageDriven;
    }

    public void setJMessageDriven(JMessageDriven messageDriven) {
        this.jMessageDriven = messageDriven;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        sb.append("[\n");
        sb.append(super.toString());
        ClassAnnotationMetadata.concatStringBuilder("className", this.className, sb);
        ClassAnnotationMetadata.concatStringBuilder("superName", this.superName, sb);
        ClassAnnotationMetadata.concatStringBuilder("interfaces", this.interfaces, sb);
        ClassAnnotationMetadata.concatStringBuilder("classType", (Object)this.classType, sb);
        ClassAnnotationMetadata.concatStringBuilder("jLocal", this.jLocal, sb);
        ClassAnnotationMetadata.concatStringBuilder("aroundInvokeMethodsMetadata", this.aroundInvokeMethodsMetadata, sb);
        ClassAnnotationMetadata.concatStringBuilder("jRemote", this.jRemote, sb);
        ClassAnnotationMetadata.concatStringBuilder("jMessageDriven", this.jMessageDriven, sb);
        ClassAnnotationMetadata.concatStringBuilder("remoteHome", this.remoteHome, sb);
        ClassAnnotationMetadata.concatStringBuilder("localHome", this.localHome, sb);
        ClassAnnotationMetadata.concatStringBuilder("transactionManagementType", this.transactionManagementType, sb);
        ClassAnnotationMetadata.concatStringBuilder("transactionAttributeType", this.transactionAttributeType, sb);
        ClassAnnotationMetadata.concatStringBuilder("annotationInterceptors", this.annotationInterceptors, sb);
        ClassAnnotationMetadata.concatStringBuilder("jAnnotationEJBs", this.jEjbEJBs, sb);
        ClassAnnotationMetadata.concatStringBuilder("jAnnotationResources", this.jAnnotationResources, sb);
        ClassAnnotationMetadata.concatStringBuilder("javaxPersistencePersistenceContexts", this.javaxPersistencePersistenceContexts, sb);
        ClassAnnotationMetadata.concatStringBuilder("javaxPersistencePersistenceUnits", this.javaxPersistencePersistenceUnits, sb);
        for (MethodAnnotationMetadata methodAnnotationMetadata : this.getMethodAnnotationMetadataCollection()) {
            ClassAnnotationMetadata.concatStringBuilder("methods", methodAnnotationMetadata, sb);
        }
        ClassAnnotationMetadata.concatStringBuilder("modified", this.modified, sb);
        ClassAnnotationMetadata.concatStringBuilder("excludeDefaultInterceptors", this.excludeDefaultInterceptors, sb);
        ClassAnnotationMetadata.concatStringBuilder("declareRoles", this.declareRoles, sb);
        ClassAnnotationMetadata.concatStringBuilder("rolesAllowed", this.rolesAllowed, sb);
        ClassAnnotationMetadata.concatStringBuilder("permitAll", this.permitAll, sb);
        ClassAnnotationMetadata.concatStringBuilder("runAs", this.runAs, sb);
        sb.append("]");
        return sb.toString();
    }

    public String getRemoteHome() {
        return this.remoteHome;
    }

    public void setRemoteHome(String remoteHome) {
        this.remoteHome = remoteHome;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    @Override
    public TransactionAttributeType getTransactionAttributeType() {
        return this.transactionAttributeType;
    }

    @Override
    public void setTransactionAttributeType(TransactionAttributeType transactionAttributeType) {
        this.transactionAttributeType = transactionAttributeType;
    }

    public JInterceptors getAnnotationInterceptors() {
        return this.annotationInterceptors;
    }

    @Override
    public void setAnnotationsInterceptors(JInterceptors annotationInterceptors) {
        this.annotationInterceptors = annotationInterceptors;
    }

    public ApplicationException getApplicationException() {
        return this.applicationException;
    }

    public void setApplicationException(ApplicationException applicationException) {
        this.applicationException = applicationException;
    }

    public boolean isBean() {
        return this.isStateless() || this.isStateful() || this.isMdb();
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public String getSuperName() {
        return this.superName;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public EjbJarAnnotationMetadata getEjbJarAnnotationMetadata() {
        return this.ejbJarAnnotationMetadata;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getExternalUserEasyBeansInterceptors() {
        return this.externalUserInterceptors;
    }

    public void setExternalUserInterceptors(Map<InterceptorType, List<JClassInterceptor>> externalUserInterceptors) {
        this.externalUserInterceptors = externalUserInterceptors;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getInternalUserEasyBeansInterceptors() {
        return this.internalUserInterceptors;
    }

    public void setInternalUserInterceptors(Map<InterceptorType, List<JClassInterceptor>> internalUserInterceptors) {
        this.internalUserInterceptors = internalUserInterceptors;
    }

    public List<JClassInterceptor> getGlobalEasyBeansInterceptors() {
        return this.globalEasyBeansInterceptors;
    }

    public void setGlobalEasyBeansInterceptors(List<JClassInterceptor> globalEasyBeansInterceptors) {
        this.globalEasyBeansInterceptors = globalEasyBeansInterceptors;
    }

    public boolean isAroundInvokeMethodMetadata() {
        return this.aroundInvokeMethodsMetadata != null;
    }

    public List<MethodAnnotationMetadata> getAroundInvokeMethodMetadatas() {
        return this.aroundInvokeMethodsMetadata;
    }

    public void addAroundInvokeMethodMetadata(MethodAnnotationMetadata aroundInvokeMethodMetadata) {
        if (this.aroundInvokeMethodsMetadata == null) {
            this.aroundInvokeMethodsMetadata = new ArrayList<MethodAnnotationMetadata>();
        }
        this.aroundInvokeMethodsMetadata.add(aroundInvokeMethodMetadata);
    }

    public LinkedList<MethodAnnotationMetadata> getPostConstructMethodsMetadata() {
        return this.postConstructMethodsMetadata;
    }

    public void addPostConstructMethodMetadata(MethodAnnotationMetadata postConstructMethodMetadata) {
        this.checkLifeCycleDuplicate(postConstructMethodMetadata, InterceptorType.POST_CONSTRUCT, this.getPostConstructMethodsMetadata());
        this.postConstructMethodsMetadata.addFirst(postConstructMethodMetadata);
    }

    private void checkLifeCycleDuplicate(MethodAnnotationMetadata postConstructMethodMetadata, InterceptorType itcType, List<MethodAnnotationMetadata> existingList) {
        ClassAnnotationMetadata wantToAddClassMetadata = postConstructMethodMetadata.getClassAnnotationMetadata();
        if (postConstructMethodMetadata.isInherited()) {
            wantToAddClassMetadata = postConstructMethodMetadata.getOriginalClassAnnotationMetadata();
        }
        for (MethodAnnotationMetadata method : existingList) {
            ClassAnnotationMetadata compareMetaData = method.isInherited() ? method.getOriginalClassAnnotationMetadata() : method.getClassAnnotationMetadata();
            if (!compareMetaData.equals(wantToAddClassMetadata)) continue;
            throw new InterceptorsValidationException("Class " + this.getClassName() + " has already a " + (Object)((Object)itcType) + " method which is " + method.getMethodName() + ", cannot set new method " + postConstructMethodMetadata.getMethodName());
        }
    }

    public LinkedList<MethodAnnotationMetadata> getPreDestroyMethodsMetadata() {
        return this.preDestroyMethodsMetadata;
    }

    public void addPreDestroyMethodMetadata(MethodAnnotationMetadata preDestroyMethodMetadata) {
        this.checkLifeCycleDuplicate(preDestroyMethodMetadata, InterceptorType.PRE_DESTROY, this.getPreDestroyMethodsMetadata());
        this.preDestroyMethodsMetadata.addFirst(preDestroyMethodMetadata);
    }

    public LinkedList<MethodAnnotationMetadata> getPostActivateMethodsMetadata() {
        return this.postActivateMethodsMetadata;
    }

    public void addPostActivateMethodMetadata(MethodAnnotationMetadata postActivateMethodMetadata) {
        this.checkLifeCycleDuplicate(postActivateMethodMetadata, InterceptorType.POST_ACTIVATE, this.getPostActivateMethodsMetadata());
        this.postActivateMethodsMetadata.addFirst(postActivateMethodMetadata);
    }

    public LinkedList<MethodAnnotationMetadata> getPrePassivateMethodsMetadata() {
        return this.prePassivateMethodsMetadata;
    }

    public void addPrePassivateMethodMetadata(MethodAnnotationMetadata prePassivateMethodMetadata) {
        this.checkLifeCycleDuplicate(prePassivateMethodMetadata, InterceptorType.PRE_PASSIVATE, this.getPrePassivateMethodsMetadata());
        this.prePassivateMethodsMetadata.addFirst(prePassivateMethodMetadata);
    }

    public boolean isInterceptor() {
        return this.aroundInvokeMethodsMetadata != null && this.aroundInvokeMethodsMetadata.size() > 0 || this.postConstructMethodsMetadata != null && this.postConstructMethodsMetadata.size() > 0 || this.preDestroyMethodsMetadata != null && this.preDestroyMethodsMetadata.size() > 0 || this.prePassivateMethodsMetadata != null && this.prePassivateMethodsMetadata.size() > 0 || this.postActivateMethodsMetadata != null && this.postActivateMethodsMetadata.size() > 0;
    }

    public List<JEjbEJB> getJEjbEJBs() {
        return this.jEjbEJBs;
    }

    public void setJEjbEJBs(List<JEjbEJB> jEjbEJBs) {
        this.jEjbEJBs = jEjbEJBs;
    }

    public List<JAnnotationResource> getJAnnotationResources() {
        return this.jAnnotationResources;
    }

    public void setJAnnotationResources(List<JAnnotationResource> jAnnotationResources) {
        this.jAnnotationResources = jAnnotationResources;
    }

    public List<JavaxPersistenceContext> getJavaxPersistencePersistenceContexts() {
        return this.javaxPersistencePersistenceContexts;
    }

    public void setJavaxPersistencePersistenceContexts(List<JavaxPersistenceContext> javaxPersistencePersistenceContexts) {
        this.javaxPersistencePersistenceContexts = javaxPersistencePersistenceContexts;
    }

    public List<JavaxPersistenceUnit> getJavaxPersistencePersistenceUnits() {
        return this.javaxPersistencePersistenceUnits;
    }

    public void setJavaxPersistencePersistenceUnits(List<JavaxPersistenceUnit> javaxPersistencePersistenceUnits) {
        this.javaxPersistencePersistenceUnits = javaxPersistencePersistenceUnits;
    }

    public JCommonBean getJCommonBean() {
        return this.jCommonBean;
    }

    public void setJCommonBean(JCommonBean commonBean) {
        String ejbName = commonBean.getName();
        if (ejbName == null || "".equals(ejbName)) {
            commonBean.setName(this.className.substring(this.className.lastIndexOf("/") + 1));
        }
        this.jCommonBean = commonBean;
    }

    public JStateful getJStateful() {
        return this.jStateful;
    }

    public void setJStateful(JStateful jStateful) {
        this.jStateful = jStateful;
    }

    public JStateless getJStateless() {
        return this.jStateless;
    }

    public void setJStateless(JStateless jStateless) {
        this.jStateless = jStateless;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setDeclareRoles(List<String> declareRoles) {
        this.declareRoles = declareRoles;
    }

    public List<String> getDeclareRoles() {
        return this.declareRoles;
    }

    @Override
    public void setRolesAllowed(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    @Override
    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    @Override
    public void setPermitAll(boolean permitAll) {
        this.permitAll = permitAll;
    }

    @Override
    public boolean hasPermitAll() {
        return this.permitAll;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public boolean isExcludedDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    @Override
    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public boolean isOrderedInterceptors() {
        return this.orderedInterceptors;
    }

    public void setOrderedInterceptors(boolean orderedInterceptors) {
        this.orderedInterceptors = orderedInterceptors;
    }

    public void setRemoteInterface(String remoteInterface) {
        this.remoteInterface = remoteInterface;
    }

    public String getRemoteInterface() {
        return this.remoteInterface;
    }
}

