/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.ow2.easybeans.deployment.annotations.InterceptorType;
import org.ow2.easybeans.deployment.annotations.JClassInterceptor;
import org.ow2.easybeans.deployment.annotations.impl.JApplicationException;
import org.ow2.easybeans.deployment.annotations.impl.JCommonBean;
import org.ow2.easybeans.deployment.annotations.impl.JInterceptors;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.xml.struct.EJB3;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarAnnotationMetadata {
    private static Log logger = LogFactory.getLog(EjbJarAnnotationMetadata.class);
    private Map<String, ClassAnnotationMetadata> classesAnnotationMetadata = new HashMap<String, ClassAnnotationMetadata>();
    private EJB3 ejb3 = null;
    private Map<String, ApplicationException> applicationExceptions = null;
    private Map<InterceptorType, List<JClassInterceptor>> defaultInterceptors = null;
    private JInterceptors defaultInterceptorsClasses = null;

    public void addClassAnnotationMetadata(ClassAnnotationMetadata classAnnotationMetadata) {
        String key = classAnnotationMetadata.getClassName();
        if (this.classesAnnotationMetadata.containsKey(key)) {
            String msg = logger.getI18n().getMessage("EjbJarAnnotationMetadata.addClassAnnotationMetadata.alreadyPresent", new Object[]{key});
            logger.debug((Object)msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.classesAnnotationMetadata.put(key, classAnnotationMetadata);
    }

    public ClassAnnotationMetadata getClassAnnotationMetadataForEjbName(String ejbName) {
        for (ClassAnnotationMetadata metadata : this.classesAnnotationMetadata.values()) {
            JCommonBean bean = metadata.getJCommonBean();
            if (bean == null || !ejbName.equals(bean.getName())) continue;
            return metadata;
        }
        return null;
    }

    public ClassAnnotationMetadata getClassAnnotationMetadata(String className) {
        return this.classesAnnotationMetadata.get(className);
    }

    public Collection<ClassAnnotationMetadata> getClassAnnotationMetadataCollection() {
        return this.classesAnnotationMetadata.values();
    }

    public EJB3 getEjb3() {
        return this.ejb3;
    }

    public void setEjb3(EJB3 ejb3) {
        this.ejb3 = ejb3;
    }

    public Map<String, ApplicationException> getApplicationExceptions() {
        if (this.applicationExceptions != null) {
            return this.applicationExceptions;
        }
        this.applicationExceptions = new HashMap<String, ApplicationException>();
        for (ClassAnnotationMetadata classMetadata : this.getClassAnnotationMetadataCollection()) {
            ApplicationException appException = classMetadata.getApplicationException();
            if (appException == null) continue;
            this.applicationExceptions.put(classMetadata.getClassName().replaceAll("/", "."), appException);
        }
        this.applicationExceptions.put("DEFAULT", new JApplicationException());
        return this.applicationExceptions;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(Map<InterceptorType, List<JClassInterceptor>> defaultInterceptors) {
        this.defaultInterceptors = defaultInterceptors;
    }

    public JInterceptors getDefaultInterceptorsClasses() {
        return this.defaultInterceptorsClasses;
    }

    public void setDefaultInterceptorsClasses(JInterceptors defaultInterceptorsClasses) {
        this.defaultInterceptorsClasses = defaultInterceptorsClasses;
    }
}

