/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.xml;

import java.net.URL;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDescException;
import org.ow2.easybeans.deployment.xml.parsing.EJB3DeploymentDescLoader;
import org.ow2.easybeans.deployment.xml.parsing.ParsingException;
import org.ow2.easybeans.deployment.xml.struct.EJB3;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;

public final class EJB3DeploymentDesc {
    private EJB3DeploymentDesc() {
    }

    public static EJB3 getEjb3(IArchive archive) throws EJB3DeploymentDescException {
        URL ejbjarXmlURL = null;
        try {
            ejbjarXmlURL = archive.getResource("META-INF/ejb-jar.xml");
        }
        catch (ArchiveException e) {
            throw new EJB3DeploymentDescException("Cannot get resource 'META-INF/ejb-jar.xml' on the archive '" + archive.getName() + "'.");
        }
        EJB3 ejb3 = null;
        if (ejbjarXmlURL != null) {
            try {
                ejb3 = EJB3DeploymentDescLoader.loadDeploymentDescriptor(ejbjarXmlURL);
            }
            catch (ParsingException e) {
                throw new EJB3DeploymentDescException("Cannot parse URL '" + ejbjarXmlURL + "'.", e);
            }
        }
        return ejb3;
    }
}

