/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.examples.entitybean;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.examples.entitybean.Employee;
import org.ow2.easybeans.examples.entitybean.SessionFacadeRemote;

public final class Client {
    private static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";

    private Client() {
    }

    public static void main(String[] args) throws Exception {
        Employee whale;
        Context initialContext = Client.getInitialContext();
        SessionFacadeRemote facadeBean = (SessionFacadeRemote)initialContext.lookup("org.ow2.easybeans.examples.entitybean.SessionFacade_" + SessionFacadeRemote.class.getName() + "@Remote");
        Employee florent = facadeBean.findEmployee(1);
        if (florent == null) {
            facadeBean.addEmployee(1, "Florent");
        }
        if ((whale = facadeBean.findEmployee(2)) == null) {
            facadeBean.addEmployee(2, "Whale");
        }
        Employee employee = facadeBean.findEmployee(1);
        System.out.println("Employee with id 1 = " + employee.getName());
        employee = facadeBean.findEmployee(2);
        System.out.println("Employee with id 2 = " + employee.getName());
    }

    private static Context getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", Client.getInitialContextFactory());
        return new InitialContext(env);
    }

    private static String getInitialContextFactory() {
        String prop = System.getProperty("easybeans.client.initial-context-factory");
        if (prop == null) {
            prop = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        return prop;
    }
}

