/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.examples.migrationejb21;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.examples.migrationejb21.EJB2RemoteHome;
import org.ow2.easybeans.examples.migrationejb21.EJB2RemoteInterface;
import org.ow2.easybeans.examples.migrationejb21.EJB3RemoteBusinessInterface;

public final class Client {
    private static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";

    private Client() {
    }

    public static void main(String[] args) throws Exception {
        Context initialContext = Client.getInitialContext();
        EJB3RemoteBusinessInterface ejb3Bean = (EJB3RemoteBusinessInterface)initialContext.lookup("org.ow2.easybeans.examples.migrationejb21.EJB2And3Bean_" + EJB3RemoteBusinessInterface.class.getName() + "@Remote");
        System.out.println("Calling hello() method on EJB 3.0 view of the Bean...");
        ejb3Bean.hello();
        EJB2RemoteHome ejb2Home = (EJB2RemoteHome)initialContext.lookup("org.ow2.easybeans.examples.migrationejb21.EJB2And3Bean_" + EJB2RemoteHome.class.getName());
        EJB2RemoteInterface ejb2Bean = ejb2Home.create();
        System.out.println("Calling hello() method on Remote EJB 2.1 view of the Bean...");
        ejb2Bean.hello21Remote();
    }

    private static Context getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", Client.getInitialContextFactory());
        return new InitialContext(env);
    }

    private static String getInitialContextFactory() {
        String prop = System.getProperty("easybeans.client.initial-context-factory");
        if (prop == null) {
            prop = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        return prop;
    }
}

