/**
 * EasyBeans
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JNDIData.java 3775 2008-07-30 07:49:50Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.easybeans.resolver;

import org.ow2.easybeans.resolver.api.EZBJNDIData;

import java.io.Serializable;

/**
 * Data about JNDI Name entry.
 * @author Florent Benoit
 */
public class JNDIData implements EZBJNDIData, Serializable {

    /**
     * JNDI Name.
     */
    private String name;

    /**
     * Bean Name.
     */
    private String beanName;

    /**
     * Constructor.
     * @param name the JNDI name
     * @param beanName the name of the bean
     */
    public JNDIData(final String name, final String beanName) {
        this.name = name;
        this.beanName = beanName;
    }

    /**
     * @return the JNDI Name.
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the bean name associated to this JNDI Name.
     */
    public String getBeanName() {
        return this.beanName;
    }

    /**
     * @return string representation of the class.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(JNDIData.class.getSimpleName());
        sb.append("[name=");
        sb.append(this.name);
        sb.append(", beanName=");
        sb.append(this.beanName);
        sb.append("]");
        return sb.toString();
    }

}
