/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.admin.cmd.AdminCmd;
import fr.dyade.aaa.admin.cmd.DomainCmdException;
import fr.dyade.aaa.admin.cmd.ExceptionCmd;
import fr.dyade.aaa.admin.cmd.JvmArgsCmdException;
import fr.dyade.aaa.admin.cmd.NatCmdException;
import fr.dyade.aaa.admin.cmd.NetworkCmdException;
import fr.dyade.aaa.admin.cmd.NewDomainCmd;
import fr.dyade.aaa.admin.cmd.NewNetworkCmd;
import fr.dyade.aaa.admin.cmd.NewServerCmd;
import fr.dyade.aaa.admin.cmd.NewServiceCmd;
import fr.dyade.aaa.admin.cmd.PropertyCmdException;
import fr.dyade.aaa.admin.cmd.RemoveDomainCmd;
import fr.dyade.aaa.admin.cmd.RemoveNetworkCmd;
import fr.dyade.aaa.admin.cmd.RemoveServerCmd;
import fr.dyade.aaa.admin.cmd.RemoveServiceCmd;
import fr.dyade.aaa.admin.cmd.ServerCmdException;
import fr.dyade.aaa.admin.cmd.ServiceCmdException;
import fr.dyade.aaa.admin.cmd.SetJvmArgsCmd;
import fr.dyade.aaa.admin.cmd.SetNetworkPortCmd;
import fr.dyade.aaa.admin.cmd.SetPropertyCmd;
import fr.dyade.aaa.admin.cmd.SetServerNatCmd;
import fr.dyade.aaa.admin.cmd.SetServerPropertyCmd;
import fr.dyade.aaa.admin.cmd.StartAdminCmd;
import fr.dyade.aaa.admin.cmd.StartNetworkCmd;
import fr.dyade.aaa.admin.cmd.StartServerCmd;
import fr.dyade.aaa.admin.cmd.StartServiceCmd;
import fr.dyade.aaa.admin.cmd.StopAdminCmd;
import fr.dyade.aaa.admin.cmd.StopNetworkCmd;
import fr.dyade.aaa.admin.cmd.StopServiceCmd;
import fr.dyade.aaa.admin.cmd.UnsetJvmArgsCmd;
import fr.dyade.aaa.admin.cmd.UnsetPropertyCmd;
import fr.dyade.aaa.admin.cmd.UnsetServerNatCmd;
import fr.dyade.aaa.admin.cmd.UnsetServerPropertyCmd;
import fr.dyade.aaa.admin.script.Script;
import fr.dyade.aaa.admin.script.StartScript;
import fr.dyade.aaa.admin.script.StopScript;
import fr.dyade.aaa.agent.AdminAckStartStopNot;
import fr.dyade.aaa.agent.AdminReplyNot;
import fr.dyade.aaa.agent.AdminRequestNot;
import fr.dyade.aaa.agent.AdminStartStopNot;
import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class AgentAdmin
extends Agent {
    private static final long serialVersionUID = 1L;
    static Logger logmon;
    public static final int NONE = 0;
    public static final int CONFIGURED = 1;
    public static final int STOPED = 2;
    public static final int STARTED = 3;
    static String[] statusName;
    private boolean silence = false;
    private transient A3CMLConfig a3cmlConfig = null;
    private StartScript startScript = null;
    private StopScript stopScript = null;
    private Script rollback = null;
    private short maxId = 0;

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, 2);
    }

    public static AgentId getDefault() {
        return AgentAdmin.getDefault(AgentServer.getServerId());
    }

    public static void init(String args, boolean firstTime) throws Exception {
        int maxId;
        logmon = Debug.getLogger("fr.dyade.aaa.agent.Admin");
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.init(" + args + ", " + firstTime + ")"));
        }
        if (!firstTime) {
            return;
        }
        if (args == null) {
            maxId = -1;
        } else {
            try {
                maxId = Short.parseShort(args);
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.WARN)) {
                    logmon.log(BasicLevel.WARN, (Object)"", (Throwable)exc);
                }
                maxId = -1;
            }
        }
        AgentAdmin agentAdmin = new AgentAdmin((short)maxId);
        agentAdmin.deploy();
    }

    public static void stopService() {
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
    }

    public AgentAdmin(short maxId) {
        super("AgentAdmin#" + AgentServer.getServerId(), true, AgentId.adminId);
        this.maxId = maxId;
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("\n\n\nAgentAdmin.react(" + from + "," + not + ")"));
        }
        if (not instanceof AdminRequestNot) {
            this.doReact(from, (AdminRequestNot)not);
        } else if (not instanceof AdminStartStopNot) {
            this.doReact(from, (AdminStartStopNot)not);
        } else {
            super.react(from, not);
        }
    }

    private void doReact(AgentId from, AdminRequestNot not) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"AgentAdmin.doReact(AdminRequestNot)");
        }
        this.startScript = new StartScript();
        this.stopScript = new StopScript();
        this.rollback = new Script();
        this.silence = not.silence;
        try {
            this.doReact(not.script);
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.WARN, (Object)"AgentAdmin.react", (Throwable)exc);
            if (exc instanceof ExceptionCmd) {
                AdminReplyNot reply = new AdminReplyNot((ExceptionCmd)exc);
                reply.setContext(not.getContext());
                reply.status = 0;
                this.sendTo(from, (Notification)reply);
                this.doReact(this.rollback);
                this.startScript = null;
                this.stopScript = null;
                this.rollback = null;
            }
            throw exc;
        }
        if (not.autoStart) {
            AdminStartStopNot startstop = new AdminStartStopNot();
            startstop.setContext(not.getContext());
            startstop.startScript = this.startScript;
            startstop.stopScript = this.stopScript;
            this.doReact(from, startstop);
        } else {
            AdminReplyNot reply = new AdminReplyNot();
            reply.setContext(not.getContext());
            reply.startScript = this.startScript;
            reply.stopScript = this.stopScript;
            reply.status = 1;
            this.sendTo(from, (Notification)reply);
        }
    }

    private void doReact(AgentId from, AdminStartStopNot not) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(AdminStartStopNot)\n startScript = " + this.startScript));
        }
        AdminAckStartStopNot ack = new AdminAckStartStopNot();
        ack.setContext(not.getContext());
        ack.status = 1;
        try {
            this.startScript = not.startScript;
            this.stopScript = not.stopScript;
            if (this.stopScript != null) {
                this.stop();
                ack.status = 2;
            }
            if (this.startScript != null) {
                this.start();
                ack.status = 3;
            }
            ack.startScript = this.startScript;
            ack.stopScript = this.stopScript;
            this.sendTo(from, (Notification)ack);
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.WARN, (Object)("AgentAdmin.doReact(AdminStartStopNot) Exception : " + exc));
            if (exc instanceof ExceptionCmd) {
                ack.exc = (ExceptionCmd)exc;
                ack.startScript = this.startScript;
                ack.stopScript = this.stopScript;
                this.sendTo(from, (Notification)ack);
            }
            throw exc;
        }
    }

    private void start() throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.start()\nstartScript = " + this.startScript));
        }
        if (this.startScript == null) {
            return;
        }
        Vector<StartAdminCmd> toRemove = new Vector<StartAdminCmd>();
        try {
            StartAdminCmd cmd;
            Enumeration e = this.startScript.serverDesc.elements();
            while (e.hasMoreElements()) {
                AgentServer.addServerDesc((ServerDesc)e.nextElement());
            }
            e = this.startScript.elements();
            while (e.hasMoreElements()) {
                cmd = (StartAdminCmd)e.nextElement();
                if (cmd instanceof StartNetworkCmd) {
                    this.doReact((StartNetworkCmd)cmd);
                } else if (cmd instanceof StartServiceCmd) {
                    this.doReact((StartServiceCmd)cmd);
                } else if (cmd instanceof StartServerCmd) {
                    this.doReact((StartServerCmd)cmd);
                }
                toRemove.addElement(cmd);
            }
            e = toRemove.elements();
            while (e.hasMoreElements()) {
                cmd = (StartAdminCmd)e.nextElement();
                this.startScript.remove(cmd);
            }
            if (this.startScript.size() == 0) {
                this.startScript = null;
            }
        }
        catch (Exception exc) {
            Enumeration e = toRemove.elements();
            while (e.hasMoreElements()) {
                StartAdminCmd cmd = (StartAdminCmd)e.nextElement();
                this.startScript.remove(cmd);
            }
            if (this.startScript.size() == 0) {
                this.startScript = null;
            }
            throw exc;
        }
    }

    private void stop() throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.stop()\nstopScript = " + this.stopScript));
        }
        if (this.stopScript == null) {
            return;
        }
        Vector<StopAdminCmd> toRemove = new Vector<StopAdminCmd>();
        try {
            StopAdminCmd cmd;
            Enumeration e = this.stopScript.elements();
            while (e.hasMoreElements()) {
                cmd = (StopAdminCmd)e.nextElement();
                if (cmd instanceof StopNetworkCmd) {
                    this.doReact((StopNetworkCmd)cmd);
                } else if (cmd instanceof StopServiceCmd) {
                    this.doReact((StopServiceCmd)cmd);
                }
                toRemove.addElement(cmd);
            }
            e = toRemove.elements();
            while (e.hasMoreElements()) {
                cmd = (StopAdminCmd)e.nextElement();
                this.stopScript.remove(cmd);
            }
            if (this.stopScript.size() == 0) {
                this.stopScript = null;
            }
        }
        catch (Exception exc) {
            Enumeration e = toRemove.elements();
            while (e.hasMoreElements()) {
                StartAdminCmd cmd = (StartAdminCmd)e.nextElement();
                this.startScript.remove(cmd);
            }
            if (this.startScript.size() == 0) {
                this.startScript = null;
            }
            throw exc;
        }
    }

    private void doReact(Script script) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + script + ")"));
        }
        this.a3cmlConfig = script.newConfig ? new A3CMLConfig() : AgentServer.getConfig();
        if (this.a3cmlConfig == null) {
            throw new ExceptionCmd("a3cmlConfig is null");
        }
        Enumeration e = script.elements();
        while (e.hasMoreElements()) {
            AdminCmd cmd = (AdminCmd)e.nextElement();
            if (cmd instanceof NewDomainCmd) {
                this.doReact((NewDomainCmd)cmd);
                continue;
            }
            if (cmd instanceof NewServerCmd) {
                this.doReact((NewServerCmd)cmd);
                continue;
            }
            if (cmd instanceof NewServiceCmd) {
                this.doReact((NewServiceCmd)cmd);
                continue;
            }
            if (cmd instanceof NewNetworkCmd) {
                this.doReact((NewNetworkCmd)cmd);
                continue;
            }
            if (cmd instanceof SetJvmArgsCmd) {
                this.doReact((SetJvmArgsCmd)cmd);
                continue;
            }
            if (cmd instanceof SetServerPropertyCmd) {
                this.doReact((SetServerPropertyCmd)cmd);
                continue;
            }
            if (cmd instanceof SetPropertyCmd) {
                this.doReact((SetPropertyCmd)cmd);
                continue;
            }
            if (cmd instanceof SetServerNatCmd) {
                this.doReact((SetServerNatCmd)cmd);
                continue;
            }
            if (cmd instanceof RemoveDomainCmd) {
                this.doReact((RemoveDomainCmd)cmd);
                continue;
            }
            if (cmd instanceof RemoveNetworkCmd) {
                this.doReact((RemoveNetworkCmd)cmd);
                continue;
            }
            if (cmd instanceof RemoveServerCmd) {
                this.doReact((RemoveServerCmd)cmd);
                continue;
            }
            if (cmd instanceof RemoveServiceCmd) {
                this.doReact((RemoveServiceCmd)cmd);
                continue;
            }
            if (cmd instanceof UnsetServerPropertyCmd) {
                this.doReact((UnsetServerPropertyCmd)cmd);
                continue;
            }
            if (cmd instanceof UnsetPropertyCmd) {
                this.doReact((UnsetPropertyCmd)cmd);
                continue;
            }
            if (cmd instanceof UnsetJvmArgsCmd) {
                this.doReact((UnsetJvmArgsCmd)cmd);
                continue;
            }
            if (cmd instanceof UnsetServerNatCmd) {
                this.doReact((UnsetServerNatCmd)cmd);
                continue;
            }
            if (!(cmd instanceof SetNetworkPortCmd)) continue;
            this.doReact((SetNetworkPortCmd)cmd);
        }
        A3CMLServer root = this.a3cmlConfig.getServer(AgentServer.getServerId());
        this.a3cmlConfig.configure(root);
        if (script.newConfig) {
            AgentServer.setConfig(this.a3cmlConfig);
        }
        this.a3cmlConfig.save();
    }

    private void doReact(NewDomainCmd cmd) throws DomainCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            if (this.a3cmlConfig.containsDomain(cmd.name)) {
                if (this.silence) {
                    return;
                }
                throw new DomainCmdException("Domain " + cmd.name + " already exist.");
            }
            this.a3cmlConfig.addDomain(new A3CMLDomain(cmd.name, cmd.networkClass));
            this.rollback.add(new RemoveDomainCmd(cmd.name, cmd.networkClass));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new DomainCmdException(exc);
        }
    }

    private void doReact(NewServerCmd cmd) throws ServerCmdException {
        block11: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
            }
            try {
                if (!this.a3cmlConfig.containsServer(cmd.name)) {
                    Short id = null;
                    if (cmd.sid == null) {
                        id = this.getSid();
                        if (id == null) {
                            throw new ServerCmdException("AgentAdmin : NewServerCmd(" + cmd + ")not authorized on " + AgentServer.getServerId());
                        }
                    } else {
                        id = cmd.sid;
                    }
                    this.a3cmlConfig.addServer(new A3CMLServer(id, cmd.name, cmd.hostname));
                    this.rollback.add(new RemoveServerCmd(cmd.name, cmd.hostname));
                    ServerDesc sd = new ServerDesc(id, cmd.name, cmd.hostname, -1);
                    sd.gateway = id;
                    this.startScript.serverDesc.put(id, sd);
                    this.startScript.add(new StartServerCmd(id, cmd.name));
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin startScript.serverDesc.put(" + id + "," + sd + ")"));
                    }
                    break block11;
                }
                if (this.silence) {
                    short sid = cmd.sid == null ? this.a3cmlConfig.getServerIdByName(cmd.name) : cmd.sid.shortValue();
                    if (sid != AgentServer.getServerId()) {
                        this.startScript.add(new StartServerCmd(sid, cmd.name));
                    }
                    break block11;
                }
                throw new ServerCmdException("Server " + cmd.name + " already exists");
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)"AgentAdmin.doReact(NewServerCmd)", (Throwable)exc);
                }
                throw new ServerCmdException(exc);
            }
        }
    }

    private void doReact(NewServiceCmd cmd) throws ServiceCmdException {
        block8: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
            }
            try {
                A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
                A3CMLService newService = new A3CMLService(cmd.className, cmd.args);
                if (!server.services.contains(newService)) {
                    server.services.addElement(newService);
                    this.rollback.add(new RemoveServiceCmd(cmd.serverName, cmd.className, cmd.args));
                    A3CMLServer adm = this.a3cmlConfig.getServer(AgentServer.getServerId());
                    if (cmd.serverName.equals(adm.name)) {
                        if (logmon.isLoggable(BasicLevel.DEBUG)) {
                            logmon.log(BasicLevel.DEBUG, (Object)("NewServiceCmd startScript.add(" + cmd.className + ")"));
                        }
                        this.startScript.add(new StartServiceCmd(cmd.className, cmd.args));
                    }
                    break block8;
                }
                if (this.silence) {
                    this.startScript.add(new StartServiceCmd(cmd.className, cmd.args));
                    return;
                }
                throw new ServiceCmdException("Service " + newService + " already exist in server " + server);
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.ERROR)) {
                    logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                }
                throw new ServiceCmdException(exc);
            }
        }
    }

    private void doReact(NewNetworkCmd cmd) throws NetworkCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            A3CMLNetwork toadd = new A3CMLNetwork(cmd.domain, cmd.port);
            if (server.networks.contains(toadd)) {
                if (this.silence) {
                    if (server.sid == AgentServer.getServerId()) {
                        this.startScript.add(new StartNetworkCmd(server.sid, cmd.domain));
                    }
                    return;
                }
                throw new NetworkCmdException(cmd.serverName + " already contains network " + toadd);
            }
            server.networks.addElement(toadd);
            this.rollback.add(new RemoveNetworkCmd(cmd.serverName, cmd.domain));
            if (!cmd.domain.equals("transient")) {
                ServerDesc serverDesc;
                A3CMLDomain domain = this.a3cmlConfig.getDomain(cmd.domain);
                domain.addServer(server);
                if (server.sid == AgentServer.getServerId()) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("startScript.add(" + server.sid + ")"));
                    }
                    this.startScript.add(new StartNetworkCmd(server.sid, cmd.domain));
                }
                if ((serverDesc = (ServerDesc)this.startScript.serverDesc.get(new Short(server.sid))) == null) {
                    serverDesc = AgentServer.getServerDesc(server.sid);
                }
            }
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NetworkCmdException(exc);
        }
    }

    private void doReact(SetNetworkPortCmd cmd) throws NetworkCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            A3CMLNetwork network = null;
            for (int i = 0; i < server.networks.size(); ++i) {
                A3CMLNetwork nw = (A3CMLNetwork)server.networks.elementAt(i);
                if (!nw.domain.equals(cmd.domain)) continue;
                network = nw;
            }
            if (network == null) {
                throw new Exception("Unknown network");
            }
            network.port = cmd.port;
            this.startScript.add(new StartNetworkCmd(server.sid, cmd.domain));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NetworkCmdException(exc);
        }
    }

    private void doReact(SetJvmArgsCmd cmd) throws JvmArgsCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            server.jvmArgs = cmd.args;
            this.rollback.add(new UnsetJvmArgsCmd(cmd.serverName, cmd.args));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new JvmArgsCmdException(exc);
        }
    }

    private void doReact(SetPropertyCmd cmd) throws PropertyCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            if (this.a3cmlConfig.containsProperty(cmd.name)) {
                if (this.silence) {
                    return;
                }
                throw new PropertyCmdException("Property " + cmd.name + " already exist.");
            }
            this.a3cmlConfig.addProperty(new A3CMLProperty(cmd.name, cmd.value));
            this.rollback.add(new UnsetPropertyCmd(cmd.name, cmd.value));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new PropertyCmdException(exc);
        }
    }

    private void doReact(SetServerPropertyCmd cmd) throws PropertyCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            if (server.containsProperty(cmd.name)) {
                if (this.silence) {
                    return;
                }
                throw new PropertyCmdException("Property " + cmd.name + " already exist in server " + cmd.serverName);
            }
            server.addProperty(new A3CMLProperty(cmd.name, cmd.value));
            this.rollback.add(new UnsetServerPropertyCmd(cmd.serverName, cmd.name, cmd.value));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new PropertyCmdException(exc);
        }
    }

    private void doReact(SetServerNatCmd cmd) throws NatCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            short sid = this.a3cmlConfig.getServerIdByName(cmd.translationServerName);
            if (server.containsNat(sid)) {
                if (this.silence) {
                    return;
                }
                throw new NatCmdException("Nat " + cmd.translationServerName + " already exist in server " + cmd.serverName);
            }
            server.addNat(new A3CMLNat(sid, cmd.translationHostName, cmd.translationHostPort));
            this.rollback.add(new UnsetServerNatCmd(cmd.serverName, cmd.translationServerName, cmd.translationHostName, cmd.translationHostPort));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NatCmdException(exc);
        }
    }

    private void doReact(StartServiceCmd cmd) throws ServiceCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer a3cmlServer = this.a3cmlConfig.getServer(AgentServer.getServerId());
            A3CMLService a3cmlService = a3cmlServer.getService(cmd.className);
            ServiceManager.register(a3cmlService.classname, a3cmlService.args);
            ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(a3cmlService.classname);
            if (desc.running) {
                return;
            }
            ServiceManager.start(desc);
            if (this.stopScript == null) {
                this.stopScript = new StopScript();
            }
            this.stopScript.add(new StopServiceCmd(a3cmlService.classname, a3cmlService.args));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new ServiceCmdException(exc);
        }
    }

    private void doReact(StartNetworkCmd cmd) throws NetworkCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            if (this.a3cmlConfig == null) {
                this.a3cmlConfig = AgentServer.getConfig();
            }
            A3CMLServer a3cmlServer = this.a3cmlConfig.getServer(cmd.sid);
            A3CMLNetwork a3cmlNetwork = null;
            for (int i = 0; i < a3cmlServer.networks.size(); ++i) {
                A3CMLNetwork nw = (A3CMLNetwork)a3cmlServer.networks.elementAt(i);
                if (!nw.domain.equals(cmd.domainName)) continue;
                a3cmlNetwork = nw;
            }
            if (a3cmlNetwork == null) {
                throw new NetworkCmdException("Unknown network: " + cmd.sid + '.' + cmd.domainName);
            }
            if (cmd.sid == AgentServer.getServerId()) {
                Network network;
                try {
                    network = (Network)AgentServer.getConsumer(cmd.domainName);
                }
                catch (Exception exc) {
                    network = null;
                }
                if (network != null) {
                    if (network.getPort() != a3cmlNetwork.port) {
                        if (logmon.isLoggable(BasicLevel.DEBUG)) {
                            logmon.log(BasicLevel.DEBUG, (Object)(" -> port change (before = " + network.getPort() + ", after = " + a3cmlNetwork.port + ')'));
                        }
                        network.stop();
                        network.setPort(a3cmlNetwork.port);
                    }
                    network.start();
                } else {
                    A3CMLDomain a3cmlDomain = this.a3cmlConfig.getDomain(cmd.domainName);
                    network = (Network)Class.forName(a3cmlDomain.network).newInstance();
                    short[] domainSids = new short[a3cmlDomain.servers.size()];
                    for (int i = 0; i < domainSids.length; ++i) {
                        domainSids[i] = ((A3CMLServer)a3cmlDomain.servers.elementAt((int)i)).sid;
                    }
                    AgentServer.addConsumer(cmd.domainName, network);
                    network.init(a3cmlDomain.name, a3cmlNetwork.port, domainSids);
                    network.start();
                }
            } else {
                try {
                    ServerDesc serverDesc = AgentServer.getServerDesc(cmd.sid);
                    if (cmd.domainName.equals(serverDesc.getDomainName())) {
                        serverDesc.updateSockAddr(serverDesc.getHostname(), a3cmlNetwork.port);
                    }
                }
                catch (UnknownServerException exc) {
                    // empty catch block
                }
            }
            if (this.stopScript == null) {
                this.stopScript = new StopScript();
            }
            this.stopScript.add(new StopNetworkCmd(cmd.sid, cmd.domainName));
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NetworkCmdException(exc);
        }
    }

    private void doReact(StartServerCmd cmd) throws ServerCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            if (this.a3cmlConfig == null) {
                this.a3cmlConfig = AgentServer.getConfig();
            }
            A3CMLServer current = this.a3cmlConfig.getServer(AgentServer.getServerId());
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.sid);
            ServerDesc desc = AgentServer.getServerDesc(server.sid);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.StartServerCmd : desc = " + desc));
            }
            AgentServer.initServerDesc(desc, server);
            if (desc.gateway == desc.sid) {
                ((Network)desc.domain).addServer(server.sid);
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.StartServerCmd : desc = " + AgentServer.getServerDesc(server.sid)));
            }
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new ServerCmdException(exc);
        }
    }

    private void doReact(StopNetworkCmd cmd) throws NetworkCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            Enumeration c = AgentServer.getConsumers();
            while (c.hasMoreElements()) {
                MessageConsumer consumer = (MessageConsumer)c.nextElement();
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin consumer = " + consumer));
                }
                if (!consumer.getDomainName().equals(cmd.domainName) || !consumer.isRunning()) continue;
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin Stop domain = " + cmd.domainName));
                }
                consumer.stop();
                A3CMLNetwork nw = this.getNetwork(AgentServer.getServerId(), cmd.domainName);
                if (nw != null) continue;
                AgentServer.removeConsumer(cmd.domainName);
            }
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NetworkCmdException(exc);
        }
    }

    private A3CMLNetwork getNetwork(short sid, String domainName) throws Exception {
        A3CMLServer server;
        if (this.a3cmlConfig == null) {
            this.a3cmlConfig = AgentServer.getConfig();
        }
        if ((server = this.a3cmlConfig.getServer(sid)) == null) {
            return null;
        }
        for (int i = 0; i < server.networks.size(); ++i) {
            A3CMLNetwork network = (A3CMLNetwork)server.networks.elementAt(i);
            if (!network.domain.equals(domainName)) continue;
            return network;
        }
        return null;
    }

    private void doReact(StopServiceCmd cmd) throws ServiceCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            ServiceManager.stop(cmd.className);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new ServiceCmdException(exc);
        }
    }

    private void doReact(RemoveDomainCmd cmd) throws DomainCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            if (this.a3cmlConfig.containsDomain(cmd.name)) {
                A3CMLDomain domain = this.a3cmlConfig.getDomain(cmd.name);
                if (domain.servers == null) {
                    this.removeDomain(cmd.name);
                    return;
                }
                Vector<RemoveServerCmd> toRemove = new Vector<RemoveServerCmd>();
                Enumeration s = domain.servers.elements();
                while (s.hasMoreElements()) {
                    A3CMLServer server = (A3CMLServer)s.nextElement();
                    if (server.networks.size() > 2) {
                        this.doReact(new RemoveNetworkCmd(server.name, cmd.name));
                        continue;
                    }
                    if (server.networks.size() == 2) {
                        if (((A3CMLNetwork)server.networks.elementAt((int)0)).domain.equals("transient") && ((A3CMLNetwork)server.networks.elementAt((int)1)).domain.equals(cmd.name) || ((A3CMLNetwork)server.networks.elementAt((int)1)).domain.equals("transient") && ((A3CMLNetwork)server.networks.elementAt((int)0)).domain.equals(cmd.name)) {
                            toRemove.addElement(new RemoveServerCmd(server.name, server.hostname));
                            continue;
                        }
                        this.doReact(new RemoveNetworkCmd(server.name, cmd.name));
                        continue;
                    }
                    toRemove.addElement(new RemoveServerCmd(server.name, server.hostname));
                }
                for (int i = 0; i < toRemove.size(); ++i) {
                    this.doReact((RemoveServerCmd)toRemove.elementAt(i));
                }
                this.removeDomain(cmd.name);
            }
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new DomainCmdException(exc);
        }
    }

    private void doReact(RemoveNetworkCmd cmd) throws NetworkCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        A3CMLServer server = null;
        try {
            server = this.a3cmlConfig.getServer(cmd.serverName);
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException e) {
            return;
        }
        if (server == null) {
            return;
        }
        try {
            if (server.sid == AgentServer.getServerId()) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("stopScript.add( StopNetworkCmd(" + cmd.serverName + "))"));
                }
                this.stopScript.add(new StopNetworkCmd(server.sid, cmd.domain));
            }
            this.removeNetwork(server.sid, cmd.domain);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NetworkCmdException(exc);
        }
    }

    private void doReact(RemoveServerCmd cmd) throws ServerCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        A3CMLServer svr = null;
        try {
            svr = this.a3cmlConfig.getServer(cmd.name);
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException exc) {
            return;
        }
        if (svr == null) {
            return;
        }
        try {
            this.removeServer(svr.sid);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new ServerCmdException(exc);
        }
    }

    private void doReact(RemoveServiceCmd cmd) throws ServiceCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        A3CMLServer server = null;
        try {
            server = this.a3cmlConfig.getServer(cmd.serverName);
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException exc) {
            return;
        }
        if (server == null) {
            return;
        }
        try {
            if (server.sid == AgentServer.getServerId()) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("stopScript.add( StopServiceCmd(" + cmd.className + "))"));
                }
                this.stopScript.add(new StopServiceCmd(cmd.className, cmd.args));
            }
            this.removeService(server.sid, cmd.className);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new ServiceCmdException(exc);
        }
    }

    private void doReact(UnsetServerPropertyCmd cmd) throws PropertyCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        A3CMLServer server = null;
        try {
            server = this.a3cmlConfig.getServer(cmd.serverName);
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException exc) {
            return;
        }
        if (server == null) {
            return;
        }
        try {
            this.unsetServerProperty(server.sid, cmd.name);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new PropertyCmdException(exc);
        }
    }

    private void doReact(UnsetPropertyCmd cmd) throws PropertyCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            this.unsetProperty(cmd.name);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new PropertyCmdException(exc);
        }
    }

    private void doReact(UnsetServerNatCmd cmd) throws NatCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(cmd.serverName);
            short sid = this.a3cmlConfig.getServerIdByName(cmd.translationServerName);
            server.removeNat(sid);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new NatCmdException(exc);
        }
    }

    private void doReact(UnsetJvmArgsCmd cmd) throws JvmArgsCmdException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.doReact(" + cmd + ")"));
        }
        A3CMLServer server = null;
        try {
            server = this.a3cmlConfig.getServer(cmd.serverName);
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException exc) {
            return;
        }
        if (server == null) {
            return;
        }
        try {
            this.unsetJvmArgs(server.sid, cmd.args);
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new JvmArgsCmdException(exc);
        }
    }

    private void removeDomain(String domainName) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeDomain(" + domainName + ")"));
        }
        this.a3cmlConfig.removeDomain(domainName);
    }

    private void removeNetwork(short sid, String domainName) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeNetwork(" + sid + "," + domainName + ")"));
        }
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(sid);
            if (server == null) {
                return;
            }
            for (int i = 0; i < server.networks.size(); ++i) {
                A3CMLNetwork network = (A3CMLNetwork)server.networks.elementAt(i);
                if (!network.domain.equals(domainName)) continue;
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeNetwork remove : " + network));
                }
                server.networks.removeElementAt(i);
            }
        }
        catch (fr.dyade.aaa.agent.conf.UnknownServerException exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            return;
        }
    }

    private void removeServer(short sid) throws Exception {
        block10: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeServer(" + sid + ")"));
            }
            try {
                ServerDesc servDesc = AgentServer.getServerDesc(sid);
                if (servDesc.domain instanceof Network) {
                    ((Network)servDesc.domain).delServer(sid);
                }
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeServer remove server #" + sid), (Throwable)exc);
                }
                return;
            }
            try {
                AgentServer.removeServerDesc(sid);
                Enumeration e = AgentServer.elementsServerDesc();
                while (e.hasMoreElements()) {
                    ServerDesc sd = (ServerDesc)e.nextElement();
                    if (sd.gateway != sid) continue;
                    sd.gateway = (short)-1;
                    sd.domain = null;
                }
            }
            catch (Exception exc) {
                if (!logmon.isLoggable(BasicLevel.DEBUG)) break block10;
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeServer remove server #" + sid), (Throwable)exc);
            }
        }
        this.a3cmlConfig.removeServer(sid);
        Enumeration d = this.a3cmlConfig.domains.elements();
        while (d.hasMoreElements()) {
            A3CMLDomain domain = (A3CMLDomain)d.nextElement();
            for (int i = 0; i < domain.servers.size(); ++i) {
                A3CMLServer server = (A3CMLServer)domain.servers.elementAt(i);
                if (server.sid != sid) continue;
                domain.servers.removeElementAt(i);
                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeServer remove server #" + sid + " in domain " + domain));
            }
        }
    }

    private void removeService(short sid, String className) throws Exception {
        A3CMLServer server;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeService(" + sid + "," + className + ")"));
        }
        if ((server = this.a3cmlConfig.getServer(sid)) == null) {
            return;
        }
        for (int i = 0; i < server.services.size(); ++i) {
            A3CMLService service = (A3CMLService)server.services.elementAt(i);
            if (!service.classname.equals(className)) continue;
            server.services.removeElementAt(i);
            if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.removeService service = " + service));
        }
    }

    private void unsetServerProperty(short sid, String name) throws Exception {
        A3CMLServer server;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.unsetServerProperty(" + sid + "," + name + ")"));
        }
        if ((server = this.a3cmlConfig.getServer(sid)) == null) {
            return;
        }
        server.removeProperty(name);
    }

    private void unsetProperty(String name) throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.unsetProperty(" + name + ")"));
        }
        this.a3cmlConfig.removeProperty(name);
    }

    private void unsetJvmArgs(short sid, String args) throws Exception {
        A3CMLServer server;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.unsetArgs(" + sid + "," + this.name + ")"));
        }
        if ((server = this.a3cmlConfig.getServer(sid)) == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(args);
        while (st.hasMoreTokens()) {
            String toRemove = st.nextToken();
            int i = server.jvmArgs.indexOf(toRemove);
            if (i <= -1) continue;
            String begin = server.jvmArgs.substring(0, i);
            String end = server.jvmArgs.substring(i + toRemove.length());
            server.jvmArgs = begin.concat(end);
        }
        if (server.jvmArgs == "") {
            server.jvmArgs = null;
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("AgentAdmin.unsetArgs jvmArgs = " + server.jvmArgs));
        }
    }

    public Short getSid() {
        if (this.maxId > -1) {
            this.maxId = (short)(this.maxId + 1);
            return new Short(this.maxId);
        }
        return null;
    }

    static {
        statusName = new String[]{"NONE", "CONFIGURED", "STOPED", "STARTED"};
    }
}

