/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Driver;
import fr.dyade.aaa.agent.DriverDone;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.NotificationOutputStream;
import fr.dyade.aaa.agent.ProxyAgent;
import fr.dyade.aaa.util.Queue;
import java.io.IOException;
import org.objectweb.util.monolog.api.BasicLevel;

class DriverOut
extends Driver {
    protected ProxyAgent proxy;
    protected Queue mq;
    protected NotificationOutputStream out;
    private int key = 0;

    DriverOut(int id, ProxyAgent proxy, Queue mq, NotificationOutputStream out) {
        super(id);
        this.proxy = proxy;
        this.mq = mq;
        this.out = out;
        this.name = proxy.getName() + ".DriverOut#" + id;
        String classname = this.getClass().getName();
        this.logmon = Debug.getLogger(proxy.getLogTopic() + '.' + classname.substring(classname.lastIndexOf(46) + 1));
    }

    DriverOut(int id, ProxyAgent proxy, Queue mq, NotificationOutputStream out, int key) {
        this(id, proxy, mq, out);
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Notification m = null;
        while (this.isRunning) {
            try {
                this.canStop = true;
                m = (Notification)this.mq.get();
                if (!this.isRunning) break;
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", write: " + m));
                }
                this.canStop = false;
                this.out.writeNotification(m);
            }
            catch (IOException exc) {
                this.canStop = false;
                if (this.proxy.finalizing) break;
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", write failed" + m), (Throwable)exc);
                break;
            }
            catch (InterruptedException exc) {
                this.canStop = false;
                break;
            }
            finally {
                Thread.interrupted();
                this.canStop = false;
            }
            this.mq.pop();
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out = null;
    }

    void sendTo(Notification not) {
        this.mq.push(not);
    }

    protected void end() {
        try {
            if (this.key == 0) {
                this.sendTo(this.proxy.getId(), new DriverDone(this.id));
            } else {
                this.sendTo(this.proxy.getId(), new DriverDone(this.id, this.key));
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error in reporting end"), (Throwable)exc);
        }
    }

    protected void clean() {
        this.mq.removeAllElements();
    }
}

