/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.SCAdminHelper;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import java.io.File;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SCAdminBase {
    protected A3CMLConfig a3config = null;
    protected Logger logmon = Debug.getLogger("fr.dyade.aaa.agent.SCAdmin");
    protected SCAdminHelper scadmin = new SCAdminHelper();

    public SCAdminBase() {
    }

    public SCAdminBase(String path) throws Exception {
        this();
        this.update(path);
    }

    public String startAgentServer(short sid) throws Exception {
        return this.startAgentServer(sid, null);
    }

    public String startAgentServer(short sid, File dir) throws Exception {
        StringTokenizer st = new StringTokenizer(this.a3config.getJvmArgs(sid));
        int nb = st.countTokens();
        String[] jvmargs = new String[nb];
        for (int i = 0; i < nb; ++i) {
            jvmargs[i] = st.nextToken();
        }
        return this.scadmin.startAgentServer(sid, dir, jvmargs);
    }

    public String startAgentServer(short sid, File dir, String[] jvmargs) throws Exception {
        return this.scadmin.startAgentServer(sid, dir, jvmargs);
    }

    public String startAgentServer(short sid, File dir, String[] jvmargs, String[] servargs) throws Exception {
        return this.scadmin.startAgentServer(sid, dir, jvmargs, servargs);
    }

    public void killAgentServer(short sid) throws Exception {
        this.scadmin.killAgentServer(sid);
    }

    public int joinAgentServer(short sid) throws Exception {
        return this.scadmin.joinAgentServer(sid);
    }

    public int exitValue(short sid) throws IllegalThreadStateException, UnknownServerException {
        return this.scadmin.exitValue(sid);
    }

    public void stopAgentServer(short sid) throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: stop AgentServer#" + sid));
        A3CMLServer server = this.a3config.getServer(sid);
        String host = server.hostname;
        int port = Integer.parseInt(this.a3config.getServiceArgs(sid, "fr.dyade.aaa.agent.AdminProxy"));
        this.scadmin.stopAgentServer(sid, host, port);
    }

    public void crashAgentServer(short sid) throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: stop AgentServer#" + sid));
        A3CMLServer server = this.a3config.getServer(sid);
        String host = server.hostname;
        int port = Integer.parseInt(this.a3config.getServiceArgs(sid, "fr.dyade.aaa.agent.AdminProxy"));
        this.scadmin.crashAgentServer(sid, host, port);
    }

    public void update() throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)"SCAdmin: update()");
        try {
            this.a3config = A3CML.getXMLConfig();
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)"SCAdmin: problem during configuration parsing", (Throwable)exc);
            throw new Exception("Problem during configuration parsing");
        }
    }

    public void update(String path) throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: update(" + path + ")"));
        try {
            this.a3config = A3CML.getXMLConfig(path);
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)"SCAdmin: problem during configuration parsing", (Throwable)exc);
            throw new Exception("Problem during configuration parsing");
        }
    }
}

