/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.soap;

import fr.dyade.aaa.jndi2.client.NamingContextImpl;
import fr.dyade.aaa.jndi2.client.Trace;
import fr.dyade.aaa.jndi2.soap.SoapObjectHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManagerClient;
import org.objectweb.util.monolog.api.BasicLevel;

public class SoapExt_NamingContextImpl
extends NamingContextImpl {
    private URL serviceUrl;
    private Call bindCall = null;
    private Call rebindCall = null;
    private Call lookupCall = null;
    private Call unbindCall = null;

    public SoapExt_NamingContextImpl(String soapHost, int soapPort, String jndiHost, int jndiPort) throws NamingException {
        try {
            this.serviceUrl = new URL("http://" + soapHost + ":" + soapPort + "/soap/servlet/rpcrouter");
        }
        catch (MalformedURLException exc) {
            // empty catch block
        }
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("Starting the SOAP service on host " + soapHost + " listening on port " + soapPort));
        }
        try {
            ServiceManagerClient smc = new ServiceManagerClient(this.serviceUrl);
            smc.deploy(this.getDeploymentDescriptor());
        }
        catch (Exception exc) {
            NamingException nEx = new NamingException("Could not deploy the SOAP service");
            nEx.setRootCause(exc);
            throw nEx;
        }
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"SOAP service deployed.");
        }
        Call initCall = new Call();
        initCall.setTargetObjectURI("urn:JndiService");
        initCall.setMethodName("init");
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(new Parameter("jndiHost", String.class, (Object)jndiHost, null));
        params.add(new Parameter("jndiPort", Integer.class, (Object)new Integer(jndiPort), null));
        initCall.setParams(params);
        try {
            Response resp = initCall.invoke(this.serviceUrl, "");
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"SOAP service initialized.");
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SoapExt_NamingContextImpl.bind(" + name + ',' + obj + ')'));
        }
        if (this.bindCall == null) {
            this.bindCall = new Call();
            this.bindCall.setTargetObjectURI("urn:JndiService");
            this.bindCall.setMethodName("bind");
            this.bindCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        }
        Hashtable codedObj = SoapObjectHelper.soapCode(obj);
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(new Parameter("name", String.class, (Object)name, null));
        params.add(new Parameter("map", Hashtable.class, (Object)codedObj, null));
        this.bindCall.setParams(params);
        try {
            Response resp = this.bindCall.invoke(this.serviceUrl, "");
            if (resp.generatedFault()) {
                throw new NamingException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
            }
        }
        catch (SOAPException exc) {
            throw new NamingException("The SOAP call failed: " + exc.getMessage());
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SoapExt_NamingContextImpl.rebind(" + name + ',' + obj + ')'));
        }
        if (this.rebindCall == null) {
            this.rebindCall = new Call();
            this.rebindCall.setTargetObjectURI("urn:JndiService");
            this.rebindCall.setMethodName("rebind");
            this.rebindCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        }
        Hashtable codedObj = SoapObjectHelper.soapCode(obj);
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(new Parameter("name", String.class, (Object)name, null));
        params.add(new Parameter("map", Hashtable.class, (Object)codedObj, null));
        this.rebindCall.setParams(params);
        try {
            Response resp = this.rebindCall.invoke(this.serviceUrl, "");
            if (resp.generatedFault()) {
                throw new NamingException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
            }
        }
        catch (SOAPException exc) {
            throw new NamingException("The SOAP call failed: " + exc.getMessage());
        }
    }

    public Object lookup(String name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SoapExt_NamingContextImpl.lookup(" + name + ')'));
        }
        if (this.lookupCall == null) {
            this.lookupCall = new Call();
            this.lookupCall.setTargetObjectURI("urn:JndiService");
            this.lookupCall.setMethodName("lookup");
            this.lookupCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(new Parameter("name", String.class, (Object)name, null));
        this.lookupCall.setParams(params);
        Response resp = null;
        try {
            resp = this.lookupCall.invoke(this.serviceUrl, "");
            if (resp.generatedFault()) {
                throw new NamingException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
            }
        }
        catch (SOAPException exc) {
            throw new NamingException("The SOAP call failed: " + exc.getMessage());
        }
        Map codedObj = (Map)resp.getReturnValue().getValue();
        return SoapObjectHelper.soapDecode((Hashtable)codedObj);
    }

    public void unbind(String name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SoapExt_NamingContextImpl.unbind(" + name + ')'));
        }
        if (this.unbindCall == null) {
            this.unbindCall = new Call();
            this.unbindCall.setTargetObjectURI("urn:JndiService");
            this.unbindCall.setMethodName("unbind");
            this.unbindCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(new Parameter("name", String.class, (Object)name, null));
        this.unbindCall.setParams(params);
        Response resp = null;
        try {
            resp = this.unbindCall.invoke(this.serviceUrl, "");
            if (resp.generatedFault()) {
                throw new NamingException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
            }
        }
        catch (SOAPException exc) {
            throw new NamingException("The SOAP call failed: " + exc.getMessage());
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new NamingException("Method not implemented.");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new NamingException("Method not implemented.");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("Method not implemented.");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("Method not implemented.");
    }

    private DeploymentDescriptor getDeploymentDescriptor() {
        DeploymentDescriptor dd = new DeploymentDescriptor();
        dd.setID("urn:JndiService");
        dd.setProviderType((byte)0);
        dd.setProviderClass("fr.dyade.aaa.jndi2.soap.JndiSoapService");
        dd.setScope(2);
        String[] methods = new String[]{"init", "bind", "rebind", "lookup", "unbind"};
        dd.setMethods(methods);
        String[] listener = new String[]{"org.apache.soap.server.DOMFaultListener"};
        dd.setFaultListener(listener);
        return dd;
    }
}

