/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.JarVisitor;

public class ExplodedJarVisitor
extends JarVisitor {
    private static Log log = LogFactory.getLog(ExplodedJarVisitor.class);

    public ExplodedJarVisitor(URL url, JarVisitor.Filter[] filters) {
        super(url, filters);
    }

    public ExplodedJarVisitor(String fileName, JarVisitor.Filter[] filters) {
        super(fileName, filters);
    }

    protected void doProcessElements() throws IOException {
        File jarFile;
        try {
            jarFile = new File(this.jarUrl.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            log.warn("Malformed url: " + this.jarUrl, e);
            return;
        }
        if (!jarFile.exists()) {
            log.warn("Exploded jar does not exists (ignored): " + this.jarUrl);
            return;
        }
        if (!jarFile.isDirectory()) {
            log.warn("Exploded jar file not a directory (ignored): " + this.jarUrl);
            return;
        }
        this.getClassNamesInTree(jarFile, null);
    }

    private void getClassNamesInTree(File jarFile, String header) throws IOException {
        File[] files = jarFile.listFiles();
        header = header == null ? "" : header + "/";
        for (File localFile : files) {
            if (!localFile.isDirectory()) {
                String entryName = localFile.getName();
                this.addElement(header + entryName, new BufferedInputStream(new FileInputStream(localFile)), new BufferedInputStream(new FileInputStream(localFile)));
                continue;
            }
            this.getClassNamesInTree(localFile, header + localFile.getName());
        }
    }
}

