/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.CMTTransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JoinableCMTTransaction
extends CMTTransaction {
    private JoinStatus status;

    public JoinableCMTTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        super(jdbcContext, transactionContext);
    }

    public boolean isTransactionInProgress(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        try {
            return this.status == JoinStatus.JOINED && this.isTransactionInProgress(transactionContext.getFactory().getTransactionManager().getTransaction());
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", (Throwable)se);
        }
    }

    private boolean isTransactionInProgress() {
        try {
            Transaction transaction = this.transactionContext.getFactory().getTransactionManager().getTransaction();
            return this.isTransactionInProgress(transaction);
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", (Throwable)se);
        }
    }

    private boolean isTransactionInProgress(Transaction tx) throws SystemException {
        return JTAHelper.isTransactionInProgress(tx) && !JTAHelper.isRollback(tx.getStatus());
    }

    void tryJoiningTransaction() {
        if (this.status == JoinStatus.MARKED_FOR_JOINED) {
            this.status = this.isTransactionInProgress() ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
        }
    }

    public void begin() throws HibernateException {
        super.begin();
        this.status = JoinStatus.JOINED;
    }

    public void commit() throws HibernateException {
        super.commit();
    }

    public JoinStatus getStatus() {
        return this.status;
    }

    public void resetStatus() {
        this.status = JoinStatus.NOT_JOINED;
    }

    public void markForJoined() {
        if (this.status != JoinStatus.JOINED) {
            this.status = JoinStatus.MARKED_FOR_JOINED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinStatus {
        NOT_JOINED,
        MARKED_FOR_JOINED,
        JOINED;

    }
}

