/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.util.IdentitySet;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.PersistentClassConstraint;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Valid;
import org.hibernate.validator.Validator;
import org.hibernate.validator.ValidatorClass;
import org.hibernate.validator.Version;
import org.hibernate.validator.interpolator.DefaultMessageInterpolatorAggerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassValidator<T>
implements Serializable {
    private static Log log = LogFactory.getLog(ClassValidator.class);
    private static final InvalidValue[] EMPTY_INVALID_VALUE_ARRAY = new InvalidValue[0];
    private static final String DEFAULT_VALIDATOR_MESSAGE = "org.hibernate.validator.resources.DefaultValidatorMessages";
    private static final String VALIDATOR_MESSAGE = "ValidatorMessages";
    private static final Set<Class> INDEXABLE_CLASS = new HashSet<Class>();
    private final Class<T> beanClass;
    private transient ResourceBundle messageBundle;
    private transient ResourceBundle defaultMessageBundle;
    private transient boolean isUserProvidedResourceBundle;
    private transient ReflectionManager reflectionManager;
    private final transient Map<XClass, ClassValidator> childClassValidators;
    private transient List<Validator> beanValidators;
    private transient List<Validator> memberValidators;
    private transient List<XMember> memberGetters;
    private transient List<XMember> childGetters;
    private transient DefaultMessageInterpolatorAggerator defaultInterpolator;
    private transient MessageInterpolator userInterpolator;
    private static final Filter GET_ALL_FILTER;

    public ClassValidator(Class<T> beanClass) {
        this(beanClass, (ResourceBundle)null);
    }

    public ClassValidator(Class<T> beanClass, ResourceBundle resourceBundle) {
        this(beanClass, resourceBundle, null, new HashMap<XClass, ClassValidator>(), null);
    }

    public ClassValidator(Class<T> beanClass, MessageInterpolator interpolator) {
        this(beanClass, null, interpolator, new HashMap<XClass, ClassValidator>(), null);
    }

    public ClassValidator(Class<T> beanClass, ResourceBundle resourceBundle, MessageInterpolator interpolator, Map<XClass, ClassValidator> childClassValidators, ReflectionManager reflectionManager) {
        this.reflectionManager = reflectionManager != null ? reflectionManager : new JavaReflectionManager();
        XClass beanXClass = this.reflectionManager.toXClass(beanClass);
        this.beanClass = beanClass;
        this.messageBundle = resourceBundle == null ? this.getDefaultResourceBundle() : resourceBundle;
        this.defaultMessageBundle = ResourceBundle.getBundle(DEFAULT_VALIDATOR_MESSAGE);
        this.userInterpolator = interpolator;
        this.childClassValidators = childClassValidators != null ? childClassValidators : new HashMap();
        this.initValidator(beanXClass, this.childClassValidators);
    }

    protected ClassValidator(XClass beanXClass, ResourceBundle resourceBundle, MessageInterpolator userInterpolator, Map<XClass, ClassValidator> childClassValidators, ReflectionManager reflectionManager) {
        this.reflectionManager = reflectionManager;
        this.beanClass = reflectionManager.toClass(beanXClass);
        this.messageBundle = resourceBundle == null ? this.getDefaultResourceBundle() : resourceBundle;
        this.defaultMessageBundle = ResourceBundle.getBundle(DEFAULT_VALIDATOR_MESSAGE);
        this.userInterpolator = userInterpolator;
        this.childClassValidators = childClassValidators;
        this.initValidator(beanXClass, childClassValidators);
    }

    private ResourceBundle getDefaultResourceBundle() {
        ResourceBundle rb;
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw new MissingResourceException("No context classloader", null, VALIDATOR_MESSAGE);
            }
            rb = ResourceBundle.getBundle(VALIDATOR_MESSAGE, Locale.getDefault(), contextClassLoader);
        }
        catch (MissingResourceException e) {
            log.trace("ResourceBundle ValidatorMessages not found in thread context classloader");
            try {
                rb = ResourceBundle.getBundle(VALIDATOR_MESSAGE, Locale.getDefault(), this.getClass().getClassLoader());
            }
            catch (MissingResourceException ee) {
                log.debug("ResourceBundle ValidatorMessages not found in Validator classloader. Delegate to org.hibernate.validator.resources.DefaultValidatorMessages");
                rb = null;
            }
        }
        this.isUserProvidedResourceBundle = true;
        return rb;
    }

    private void initValidator(XClass xClass, Map<XClass, ClassValidator> childClassValidators) {
        this.beanValidators = new ArrayList<Validator>();
        this.memberValidators = new ArrayList<Validator>();
        this.memberGetters = new ArrayList<XMember>();
        this.childGetters = new ArrayList<XMember>();
        this.defaultInterpolator = new DefaultMessageInterpolatorAggerator();
        this.defaultInterpolator.initialize(this.messageBundle, this.defaultMessageBundle);
        childClassValidators.put(xClass, this);
        HashSet<XClass> classes = new HashSet<XClass>();
        this.addSuperClassesAndInterfaces(xClass, classes);
        for (XClass currentClass : classes) {
            Annotation[] classAnnotations = currentClass.getAnnotations();
            for (int i = 0; i < classAnnotations.length; ++i) {
                Annotation classAnnotation = classAnnotations[i];
                Validator beanValidator = this.createValidator(classAnnotation);
                if (beanValidator != null) {
                    this.beanValidators.add(beanValidator);
                }
                this.handleAggregateAnnotations(classAnnotation, null);
            }
        }
        for (XClass currClass : classes) {
            List<XMethod> methods = currClass.getDeclaredMethods();
            for (XMethod method : methods) {
                this.createMemberValidator(method);
                this.createChildValidator(method);
            }
            List<XProperty> fields = currClass.getDeclaredProperties("field", GET_ALL_FILTER);
            for (XProperty field : fields) {
                this.createMemberValidator(field);
                this.createChildValidator(field);
            }
        }
    }

    private void addSuperClassesAndInterfaces(XClass clazz, Collection<XClass> classes) {
        for (XClass currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            XClass[] interfaces;
            if (!classes.add(currClass)) {
                return;
            }
            for (XClass interf : interfaces = currClass.getInterfaces()) {
                this.addSuperClassesAndInterfaces(interf, classes);
            }
        }
    }

    private boolean handleAggregateAnnotations(Annotation annotation, XMember member) {
        Object[] values;
        try {
            Method valueMethod = annotation.getClass().getMethod("value", new Class[0]);
            if (!valueMethod.getReturnType().isArray()) {
                return false;
            }
            values = (Object[])valueMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        boolean validatorPresent = false;
        for (Object value : values) {
            Validator validator;
            if (!(value instanceof Annotation) || (validator = this.createValidator(annotation = (Annotation)value)) == null) continue;
            if (member != null) {
                this.memberValidators.add(validator);
                ClassValidator.setAccessible(member);
                this.memberGetters.add(member);
            } else {
                this.beanValidators.add(validator);
            }
            validatorPresent = true;
        }
        return validatorPresent;
    }

    private void createChildValidator(XMember member) {
        if (member.isAnnotationPresent(Valid.class)) {
            ClassValidator.setAccessible(member);
            this.childGetters.add(member);
            XClass clazz = member.isCollection() || member.isArray() ? member.getElementClass() : member.getType();
            if (!this.childClassValidators.containsKey(clazz)) {
                new ClassValidator<T>(clazz, this.messageBundle, this.userInterpolator, this.childClassValidators, this.reflectionManager);
            }
        }
    }

    private void createMemberValidator(XMember member) {
        Annotation[] memberAnnotations;
        boolean validatorPresent = false;
        for (Annotation methodAnnotation : memberAnnotations = member.getAnnotations()) {
            Validator propertyValidator = this.createValidator(methodAnnotation);
            if (propertyValidator != null) {
                this.memberValidators.add(propertyValidator);
                ClassValidator.setAccessible(member);
                this.memberGetters.add(member);
                validatorPresent = true;
            }
            boolean agrValidPresent = this.handleAggregateAnnotations(methodAnnotation, member);
            validatorPresent = validatorPresent || agrValidPresent;
        }
        if (validatorPresent && !member.isTypeResolved()) {
            log.warn("Original type of property " + member + " is unbound and has been approximated.");
        }
    }

    private static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    private Validator createValidator(Annotation annotation) {
        try {
            ValidatorClass validatorClass = annotation.annotationType().getAnnotation(ValidatorClass.class);
            if (validatorClass == null) {
                return null;
            }
            Validator beanValidator = validatorClass.value().newInstance();
            beanValidator.initialize(annotation);
            this.defaultInterpolator.addInterpolator(annotation, beanValidator);
            return beanValidator;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not instantiate ClassValidator", e);
        }
    }

    public boolean hasValidationRules() {
        return this.beanValidators.size() != 0 || this.memberValidators.size() != 0;
    }

    public InvalidValue[] getInvalidValues(T bean) {
        return this.getInvalidValues(bean, new IdentitySet());
    }

    protected InvalidValue[] getInvalidValues(T bean, Set<Object> circularityState) {
        Object value;
        XMember getter;
        int i;
        if (bean == null || circularityState.contains(bean)) {
            return EMPTY_INVALID_VALUE_ARRAY;
        }
        circularityState.add(bean);
        if (!this.beanClass.isInstance(bean)) {
            throw new IllegalArgumentException("not an instance of: " + bean.getClass());
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (i = 0; i < this.beanValidators.size(); ++i) {
            Validator validator = this.beanValidators.get(i);
            if (validator.isValid(bean)) continue;
            results.add(new InvalidValue(this.interpolate(validator), this.beanClass, null, bean, bean));
        }
        for (i = 0; i < this.memberValidators.size(); ++i) {
            getter = this.memberGetters.get(i);
            if (!Hibernate.isPropertyInitialized(bean, this.getPropertyName(getter))) continue;
            value = this.getMemberValue(bean, getter);
            Validator validator = this.memberValidators.get(i);
            if (validator.isValid(value)) continue;
            String propertyName = this.getPropertyName(getter);
            results.add(new InvalidValue(this.interpolate(validator), this.beanClass, propertyName, value, bean));
        }
        for (i = 0; i < this.childGetters.size(); ++i) {
            getter = this.childGetters.get(i);
            if (!Hibernate.isPropertyInitialized(bean, this.getPropertyName(getter)) || (value = this.getMemberValue(bean, getter)) == null || !Hibernate.isInitialized(value)) continue;
            String propertyName = this.getPropertyName(getter);
            if (getter.isCollection()) {
                int index = 0;
                boolean isIterable = value instanceof Iterable;
                Map map = !isIterable ? (Map)value : null;
                Set elements = isIterable ? (Set)value : map.keySet();
                for (Object element : elements) {
                    Object actualElement;
                    Object object = actualElement = isIterable ? element : map.get(element);
                    if (actualElement == null) {
                        ++index;
                        continue;
                    }
                    InvalidValue[] invalidValues = this.getClassValidator(actualElement).getInvalidValues(actualElement, circularityState);
                    String indexedPropName = MessageFormat.format("{0}[{1}]", propertyName, INDEXABLE_CLASS.contains(element.getClass()) ? "'" + element + "'" : Integer.valueOf(index));
                    ++index;
                    for (InvalidValue invalidValue : invalidValues) {
                        invalidValue.addParentBean(bean, indexedPropName);
                        results.add(invalidValue);
                    }
                }
            }
            if (getter.isArray()) {
                int index = 0;
                for (Object element : (Object[])value) {
                    if (element == null) {
                        ++index;
                        continue;
                    }
                    InvalidValue[] invalidValues = this.getClassValidator(element).getInvalidValues(element, circularityState);
                    String indexedPropName = MessageFormat.format("{0}[{1}]", propertyName, index);
                    ++index;
                    for (InvalidValue invalidValue : invalidValues) {
                        invalidValue.addParentBean(bean, indexedPropName);
                        results.add(invalidValue);
                    }
                }
                continue;
            }
            InvalidValue[] invalidValues = this.getClassValidator(value).getInvalidValues(value, circularityState);
            for (InvalidValue invalidValue : invalidValues) {
                invalidValue.addParentBean(bean, propertyName);
                results.add(invalidValue);
            }
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    private String interpolate(Validator validator) {
        String message = this.defaultInterpolator.getAnnotationMessage(validator);
        if (this.userInterpolator != null) {
            return this.userInterpolator.interpolate(message, validator, this.defaultInterpolator);
        }
        return this.defaultInterpolator.interpolate(message, validator, null);
    }

    private ClassValidator getClassValidator(Object value) {
        Class<?> clazz = value.getClass();
        ClassValidator validator = this.childClassValidators.get(this.reflectionManager.toXClass(clazz));
        if (validator == null) {
            validator = new ClassValidator(clazz);
        }
        return validator;
    }

    public InvalidValue[] getInvalidValues(T bean, String propertyName) {
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (int i = 0; i < this.memberValidators.size(); ++i) {
            XMember getter = this.memberGetters.get(i);
            if (!this.getPropertyName(getter).equals(propertyName)) continue;
            Object value = this.getMemberValue(bean, getter);
            Validator validator = this.memberValidators.get(i);
            if (validator.isValid(value)) continue;
            results.add(new InvalidValue(this.interpolate(validator), this.beanClass, propertyName, value, bean));
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    public InvalidValue[] getPotentialInvalidValues(String propertyName, Object value) {
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (int i = 0; i < this.memberValidators.size(); ++i) {
            Validator validator;
            XMember getter = this.memberGetters.get(i);
            if (!this.getPropertyName(getter).equals(propertyName) || (validator = this.memberValidators.get(i)).isValid(value)) continue;
            results.add(new InvalidValue(this.interpolate(validator), this.beanClass, propertyName, value, null));
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    private Object getMemberValue(T bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public String getPropertyName(XMember member) {
        String propertyName;
        if (XProperty.class.isAssignableFrom(member.getClass())) {
            propertyName = member.getName();
        } else if (XMethod.class.isAssignableFrom(member.getClass())) {
            propertyName = member.getName();
            if (propertyName.startsWith("is")) {
                propertyName = Introspector.decapitalize(propertyName.substring(2));
            } else if (propertyName.startsWith("get")) {
                propertyName = Introspector.decapitalize(propertyName.substring(3));
            }
        } else {
            throw new AssertionFailure("Unexpected member: " + member.getClass().getName());
        }
        return propertyName;
    }

    private String replace(String message, Annotation parameters) {
        StringTokenizer tokens = new StringTokenizer(message, "#{}", true);
        StringBuilder buf = new StringBuilder(30);
        boolean escaped = false;
        boolean el = false;
        while (tokens.hasMoreTokens()) {
            Method member;
            String token = tokens.nextToken();
            if (!escaped && "#".equals(token)) {
                el = true;
            }
            if (!el && "{".equals(token)) {
                escaped = true;
                continue;
            }
            if (escaped && "}".equals(token)) {
                escaped = false;
                continue;
            }
            if (!escaped) {
                if ("{".equals(token)) {
                    el = false;
                }
                buf.append(token);
                continue;
            }
            try {
                member = parameters.getClass().getMethod(token, null);
            }
            catch (NoSuchMethodException nsfme) {
                member = null;
            }
            if (member != null) {
                try {
                    buf.append(member.invoke((Object)parameters, new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("could not render message", e);
                }
            }
            String string = null;
            try {
                string = this.messageBundle != null ? this.messageBundle.getString(token) : null;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (string == null) {
                try {
                    string = this.defaultMessageBundle.getString(token);
                }
                catch (MissingResourceException e) {
                    throw new MissingResourceException("Can't find resource in validator bundles, key " + token, this.defaultMessageBundle.getClass().getName(), token);
                }
            }
            if (string == null) continue;
            buf.append(this.replace(string, parameters));
        }
        return buf.toString();
    }

    public void apply(PersistentClass persistentClass) {
        for (Validator validator : this.beanValidators) {
            if (!(validator instanceof PersistentClassConstraint)) continue;
            ((PersistentClassConstraint)((Object)validator)).apply(persistentClass);
        }
        Iterator<Validator> validators = this.memberValidators.iterator();
        Iterator<XMember> getters = this.memberGetters.iterator();
        while (validators.hasNext()) {
            Validator validator = validators.next();
            String propertyName = this.getPropertyName(getters.next());
            if (!(validator instanceof PropertyConstraint)) continue;
            try {
                Property property = ClassValidator.findPropertyByName(persistentClass, propertyName);
                if (property == null) continue;
                ((PropertyConstraint)((Object)validator)).apply(property);
            }
            catch (MappingException pnfe) {}
        }
    }

    public void assertValid(T bean) {
        InvalidValue[] values = this.getInvalidValues(bean);
        if (values.length > 0) {
            throw new InvalidStateException(values);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ResourceBundle rb = this.messageBundle;
        MessageInterpolator interpolator = this.userInterpolator;
        if (rb != null && !(rb instanceof Serializable)) {
            this.messageBundle = null;
            if (!this.isUserProvidedResourceBundle) {
                log.warn("Serializing a ClassValidator with a non serializable ResourceBundle: ResourceBundle ignored");
            }
        }
        if (interpolator != null && !(interpolator instanceof Serializable)) {
            this.userInterpolator = null;
            log.warn("Serializing a non serializable MessageInterpolator");
        }
        oos.defaultWriteObject();
        oos.writeObject(this.messageBundle);
        oos.writeObject(this.userInterpolator);
        this.messageBundle = rb;
        this.userInterpolator = interpolator;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ResourceBundle rb = (ResourceBundle)ois.readObject();
        if (rb == null) {
            rb = this.getDefaultResourceBundle();
        }
        this.messageBundle = rb;
        this.userInterpolator = (MessageInterpolator)ois.readObject();
        this.defaultMessageBundle = ResourceBundle.getBundle(DEFAULT_VALIDATOR_MESSAGE);
        this.reflectionManager = new JavaReflectionManager();
        this.initValidator(this.reflectionManager.toXClass(this.beanClass), new HashMap<XClass, ClassValidator>());
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    static {
        INDEXABLE_CLASS.add(Integer.class);
        INDEXABLE_CLASS.add(Long.class);
        INDEXABLE_CLASS.add(String.class);
        Version.touch();
        GET_ALL_FILTER = new Filter(){

            public boolean returnStatic() {
                return true;
            }

            public boolean returnTransient() {
                return true;
            }
        };
    }
}

