/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class DistributedQueue
implements MessageListener,
MembershipListener,
Cloneable {
    protected Log logger = LogFactory.getLog(this.getClass());
    private long internal_timeout = 10000L;
    protected final Object mutex = new Object();
    protected boolean stopped = false;
    protected LinkedList internalQueue;
    protected Channel channel;
    protected RpcDispatcher disp = null;
    protected String groupname = null;
    protected Vector notifs = new Vector();
    protected Vector members = new Vector();
    private Class[] add_signature = null;
    private Class[] addAtHead_signature = null;
    private Class[] addAll_signature = null;
    private Class[] reset_signature = null;
    private Class[] remove_signature = null;

    public DistributedQueue(String groupname, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DistributedQueue(" + groupname + ',' + properties + ',' + state_timeout);
        }
        this.groupname = groupname;
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedQueue(JChannel channel) {
        this.groupname = channel.getClusterName();
        this.channel = channel;
        this.init();
    }

    public DistributedQueue(PullPushAdapter adapter, Serializable id) {
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getClusterName();
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
        this.disp.setDeadlockDetection(false);
    }

    protected final void init() {
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
    }

    public final void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this.logger.debug("DistributedQueue.initState(" + this.groupname + "): starting state retrieval");
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            this.logger.info("DistributedQueue.initState(" + this.groupname + "): state was retrieved successfully");
        } else {
            this.logger.info("DistributedQueue.initState(" + this.groupname + "): state could not be retrieved (first member)");
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (n != null && !this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void removeNotifier(Notification n) {
        this.notifs.removeElement(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            if (this.disp != null) {
                this.disp.stop();
                this.disp = null;
            }
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.stopped = true;
        }
    }

    public void add(Object value) {
        try {
            Object retval = null;
            RspList rsp = this.disp.callRemoteMethods(null, "_add", new Object[]{value}, this.add_signature, 2, 0L);
            Vector<Object> results = rsp.getResults();
            if (results.size() > 0) {
                retval = results.elementAt(0);
                if (this.logger.isDebugEnabled()) {
                    this.checkResult(rsp, retval);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to add value " + value, e);
        }
    }

    public void addAtHead(Object value) {
        try {
            this.disp.callRemoteMethods(null, "_addAtHead", new Object[]{value}, this.addAtHead_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error("Unable to addAtHead value " + value, e);
        }
    }

    public void addAll(Collection values) {
        try {
            this.disp.callRemoteMethods(null, "_addAll", new Object[]{values}, this.addAll_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error("Unable to addAll value: " + values, e);
        }
    }

    public Vector getContents() {
        Vector result = new Vector();
        Iterator e = this.internalQueue.iterator();
        while (e.hasNext()) {
            result.add(e.next());
        }
        return result;
    }

    public int size() {
        return this.internalQueue.size();
    }

    public Object peek() {
        Object retval = null;
        try {
            retval = this.internalQueue.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return retval;
    }

    public void reset() {
        try {
            this.disp.callRemoteMethods(null, "_reset", null, this.reset_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error("DistributedQueue.reset(" + this.groupname + ')', e);
        }
    }

    protected void checkResult(RspList rsp, Object retval) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Value updated from " + this.groupname + " :" + retval);
        }
        Vector<Object> results = rsp.getResults();
        for (int i = 0; i < results.size(); ++i) {
            Object data = results.elementAt(i);
            if (data.equals(retval)) continue;
            this.logger.error("Reference value differs from returned value " + retval + " != " + data);
        }
    }

    public Object remove() {
        Object retval = null;
        RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
        Vector<Object> results = rsp.getResults();
        if (results.size() > 0) {
            retval = results.elementAt(0);
            if (this.logger.isDebugEnabled()) {
                this.checkResult(rsp, retval);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) {
        Object retval = null;
        long start = System.currentTimeMillis();
        if (timeout <= 0L) {
            while (!this.stopped && retval == null) {
                RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
                Vector<Object> results = rsp.getResults();
                if (results.size() > 0) {
                    retval = results.elementAt(0);
                    if (this.logger.isDebugEnabled()) {
                        this.checkResult(rsp, retval);
                    }
                }
                if (retval != null) continue;
                try {
                    Object object = this.mutex;
                    synchronized (object) {
                        this.mutex.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        } else {
            while (System.currentTimeMillis() - start < timeout && !this.stopped && retval == null) {
                RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
                Vector<Object> results = rsp.getResults();
                if (results.size() > 0) {
                    retval = results.elementAt(0);
                    if (this.logger.isDebugEnabled()) {
                        this.checkResult(rsp, retval);
                    }
                }
                if (retval != null) continue;
                try {
                    long delay = timeout - (System.currentTimeMillis() - start);
                    Object object = this.mutex;
                    synchronized (object) {
                        if (delay > 0L) {
                            this.mutex.wait(delay);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        return retval;
    }

    public String toString() {
        return this.internalQueue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _add(" + value + ')');
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.add(value);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAtHead(Object value) {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addFirst(value);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
        }
    }

    public void _reset() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _reset()");
        }
        this._private_reset();
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _private_reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _remove() {
        Object retval = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                retval = this.internalQueue.removeFirst();
                this.mutex.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.groupname + '@' + this.getLocalAddress() + "_remove(" + retval + ')');
            }
            for (int i = 0; i < this.notifs.size(); ++i) {
                ((Notification)this.notifs.elementAt(i)).entryRemoved(retval);
            }
        }
        catch (NoSuchElementException e) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + "_remove(): nothing to remove");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAll(Collection c) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _addAll(" + c + ')');
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addAll(c);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(c);
        }
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Vector copy = (Vector)this.getContents().clone();
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            this.logger.error("DistributedQueue.getState(): exception marshalling state.", ex);
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Vector new_copy;
        try {
            new_copy = (Vector)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            this.logger.error("DistributedQueue.setState(): exception unmarshalling state.", ex);
            return;
        }
        this._private_reset();
        this._addAll(new_copy);
    }

    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    final void initSignatures() {
        try {
            if (this.add_signature == null) {
                this.add_signature = new Class[]{Object.class};
            }
            if (this.addAtHead_signature == null) {
                this.addAtHead_signature = new Class[]{Object.class};
            }
            if (this.addAll_signature == null) {
                this.addAll_signature = new Class[]{Collection.class};
            }
            if (this.reset_signature == null) {
                this.reset_signature = new Class[0];
            }
            if (this.remove_signature == null) {
                this.remove_signature = new Class[0];
            }
        }
        catch (Throwable ex) {
            this.logger.error("DistributedQueue.initMethods()", ex);
        }
    }

    public static void main(String[] args) {
        try {
            JChannel c = new JChannel("file:/c:/JGroups-2.0/conf/conf/total-token.xml");
            DistributedQueue ht = new DistributedQueue(c);
            c.connect("demo");
            ht.start(5000L);
            ht.add("name");
            ht.add("Michelle Ban");
            Object old_key = ht.remove();
            System.out.println("old key was " + old_key);
            old_key = ht.remove();
            System.out.println("old value was " + old_key);
            ht.add("name 'Michelle Ban'");
            System.out.println("queue is " + ht);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface Notification {
        public void entryAdd(Object var1);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsCleared();

        public void contentsSet(Collection var1);
    }
}

