/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Discovery
extends Protocol {
    final Vector<Address> members = new Vector(11);
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    int num_initial_members = 2;
    boolean is_server = false;
    TimeScheduler timer = null;
    int num_ping_requests = 2;
    int num_discovery_requests = 0;
    private final Set<Responses> ping_responses = new HashSet<Responses>();
    private final PingSenderTask sender = new PingSenderTask(this.timeout, this.num_ping_requests);

    @Override
    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void localAddressSet(Address addr) {
    }

    public abstract void sendGetMembersRequest();

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getNumInitialMembers() {
        return this.num_initial_members;
    }

    public void setNumInitialMembers(int num_initial_members) {
        this.num_initial_members = num_initial_members;
    }

    public int getNumPingRequests() {
        return this.num_ping_requests;
    }

    public void setNumPingRequests(int num_ping_requests) {
        this.num_ping_requests = num_ping_requests;
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    @Override
    public Vector<Integer> providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>(1);
        ret.addElement(new Integer(12));
        return ret;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            if (this.timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("timeout must be > 0");
                }
                return false;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = Integer.parseInt(str);
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("num_ping_requests")) != null) {
            this.num_ping_requests = Integer.parseInt(str);
            props.remove("num_ping_requests");
            if (this.num_ping_requests < 1) {
                this.num_ping_requests = 1;
            }
        }
        if (!props.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error("The following properties are not recognized: " + sb);
            }
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        this.is_server = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PingRsp> findInitialMembers(Promise<JoinRsp> promise) {
        ++this.num_discovery_requests;
        Responses rsps = new Responses(this.num_initial_members, promise);
        Collection<Object> collection = this.ping_responses;
        synchronized (collection) {
            this.ping_responses.add(rsps);
        }
        this.sender.start();
        try {
            collection = rsps.get(this.timeout);
            return collection;
        }
        catch (Exception e) {
            LinkedList<PingRsp> linkedList = new LinkedList<PingRsp>();
            return linkedList;
        }
        finally {
            this.sender.stop();
            Set<Responses> set = this.ping_responses;
            synchronized (set) {
                this.ping_responses.remove(rsps);
            }
        }
    }

    public String findInitialMembersAsString() {
        List<PingRsp> results = this.findInitialMembers(null);
        if (results == null || results.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (PingRsp rsp : results) {
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PingHeader hdr = (PingHeader)msg.getHeader(this.getName());
                if (hdr == null) {
                    return this.up_prot.up(evt);
                }
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (this.local_addr != null && msg.getSrc() != null && this.local_addr.equals(msg.getSrc())) {
                            return null;
                        }
                        Vector<Address> vector = this.members;
                        synchronized (vector) {
                            coord = !this.members.isEmpty() ? this.members.firstElement() : this.local_addr;
                        }
                        PingRsp ping_rsp = new PingRsp(this.local_addr, coord, this.is_server);
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        rsp_msg.setFlag((byte)1);
                        PingHeader rsp_hdr = new PingHeader(2, ping_rsp);
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received GET_MBRS_REQ from " + msg.getSrc() + ", sending response " + rsp_hdr);
                        }
                        this.down_prot.down(new Event(1, rsp_msg));
                        return null;
                    }
                    case 2: {
                        PingRsp rsp = hdr.arg;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received GET_MBRS_RSP, rsp=" + rsp);
                        }
                        Set<Responses> set = this.ping_responses;
                        synchronized (set) {
                            for (Responses rsps : this.ping_responses) {
                                rsps.addResponse(rsp);
                            }
                        }
                        return null;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn("got PING header with unknown type (" + hdr.type + ')');
                }
                return null;
            }
            case 8: {
                this.up_prot.up(evt);
                this.local_addr = (Address)evt.getArg();
                this.localAddressSet(this.local_addr);
                break;
            }
            default: {
                this.up_prot.up(evt);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                return this.findInitialMembers((Promise)evt.getArg());
            }
            case 6: 
            case 15: {
                Vector<Address> tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector<Address> vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                return this.down_prot.down(evt);
            }
            case 16: {
                this.down_prot.down(evt);
                this.is_server = true;
                return null;
            }
            case 2: 
            case 80: {
                this.group_addr = (String)evt.getArg();
                Object ret = this.down_prot.down(evt);
                this.handleConnect();
                return ret;
            }
            case 4: {
                this.handleDisconnect();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    protected final View makeView(Vector mbrs) {
        ViewId view_id = new ViewId(this.local_addr);
        Address coord = view_id.getCoordAddress();
        long id = view_id.getId();
        return new View(coord, id, mbrs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Responses {
        final Promise<JoinRsp> promise;
        final List<PingRsp> ping_rsps = new LinkedList<PingRsp>();
        final int num_expected_rsps;

        public Responses(int num_expected_rsps, Promise<JoinRsp> promise) {
            this.num_expected_rsps = num_expected_rsps;
            this.promise = promise != null ? promise : new Promise();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResponse(PingRsp rsp) {
            if (rsp == null) {
                return;
            }
            this.promise.getLock().lock();
            try {
                if (!this.ping_rsps.contains(rsp)) {
                    this.ping_rsps.add(rsp);
                    if (this.ping_rsps.size() >= this.num_expected_rsps) {
                        this.promise.getCond().signalAll();
                    }
                }
            }
            finally {
                this.promise.getLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<PingRsp> get(long timeout) throws InterruptedException {
            long start_time = System.currentTimeMillis();
            long time_to_wait = timeout;
            this.promise.getLock().lock();
            try {
                while (this.ping_rsps.size() < this.num_expected_rsps && time_to_wait > 0L && !this.promise.hasResult()) {
                    this.promise.getCond().await(time_to_wait, TimeUnit.MILLISECONDS);
                    time_to_wait = timeout - (System.currentTimeMillis() - start_time);
                }
                LinkedList<PingRsp> linkedList = new LinkedList<PingRsp>(this.ping_rsps);
                return linkedList;
            }
            finally {
                this.promise.getLock().unlock();
            }
        }
    }

    class PingSenderTask {
        private double interval;
        private Future<?> senderFuture;

        public PingSenderTask(long timeout, int num_requests) {
            this.interval = (double)timeout / (double)num_requests;
        }

        public synchronized void start() {
            if (this.senderFuture == null || this.senderFuture.isDone()) {
                this.senderFuture = Discovery.this.timer.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                Discovery.this.sendGetMembersRequest();
                            }
                            catch (Exception ex) {
                                if (!Discovery.this.log.isErrorEnabled()) break block2;
                                Discovery.this.log.error("failed sending discovery request", ex);
                            }
                        }
                    }
                }, 0L, (long)this.interval, TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void stop() {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
                this.senderFuture = null;
            }
        }
    }
}

