/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD_SOCK
extends Protocol
implements Runnable {
    long get_cache_timeout = 1000L;
    long suspect_msg_interval = 5000L;
    int num_tries = 3;
    final Vector<Address> members = new Vector(11);
    boolean srv_sock_sent = false;
    final Vector<Address> pingable_mbrs = new Vector(11);
    final Promise<Map<Address, IpAddress>> get_cache_promise = new Promise();
    boolean got_cache_from_coord = false;
    Address local_addr = null;
    ServerSocket srv_sock = null;
    InetAddress bind_addr = null;
    String group_name = null;
    private ServerSocketHandler srv_sock_handler = null;
    IpAddress srv_sock_addr = null;
    Address ping_dest = null;
    Socket ping_sock = null;
    InputStream ping_input = null;
    volatile Thread pinger_thread = null;
    final ConcurrentMap<Address, IpAddress> cache = new ConcurrentHashMap<Address, IpAddress>(11);
    int start_port = 0;
    final Promise<IpAddress> ping_addr_promise = new Promise();
    final Object sock_mutex = new Object();
    TimeScheduler timer = null;
    private final BroadcastTask bcast_task = new BroadcastTask();
    boolean regular_sock_close = false;
    int num_suspect_events = 0;
    private static final int INTERRUPT = 8;
    private static final int NORMAL_TERMINATION = 9;
    private static final int ABNORMAL_TERMINATION = -1;
    private static final String name = "FD_SOCK";
    final BoundedList<Address> suspect_history = new BoundedList(20);
    private boolean keep_alive = true;
    private volatile boolean running = false;

    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address suspect : this.suspect_history) {
            sb.append(new Date()).append(": ").append(suspect).append("\n");
        }
        return sb.toString();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("get_cache_timeout");
        if (str != null) {
            this.get_cache_timeout = Long.parseLong(str);
            props.remove("get_cache_timeout");
        }
        if ((str = props.getProperty("suspect_msg_interval")) != null) {
            this.suspect_msg_interval = Long.parseLong(str);
            props.remove("suspect_msg_interval");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = Integer.parseInt(str);
            props.remove("num_tries");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("keep_alive")) != null) {
            this.keep_alive = Boolean.parseBoolean(str);
            props.remove("keep_alive");
        }
        if ((str = props.getProperty("srv_sock_bind_addr")) != null) {
            this.log.error("srv_sock_bind_addr is deprecated and will be ignored - use bind_addr instead");
            props.remove("srv_sock_bind_addr");
        }
        try {
            this.bind_addr = Util.getBindAddress(props);
        }
        catch (UnknownHostException unknown) {
            this.log.fatal("failed getting bind_addr", unknown);
            return false;
        }
        catch (SocketException ex) {
            this.log.fatal("failed getting bind_addr", ex);
            return false;
        }
        if (!props.isEmpty()) {
            this.log.error("the following properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.cache.entrySet()) {
            sb.append(entry.getKey()).append(" has server socket at ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public void init() throws Exception {
        this.srv_sock_handler = new ServerSocketHandler();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("FD_SOCK.init(): timer == null");
        }
    }

    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        this.bcast_task.removeAll();
        FD_SOCK fD_SOCK = this;
        synchronized (fD_SOCK) {
            this.stopPingerThread();
        }
        this.stopServerSocket(true);
    }

    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.clear();
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.getHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbrs != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("[SUSPECT] hdr=" + hdr);
                            }
                            for (Address m : hdr.mbrs) {
                                if (this.local_addr != null && m.equals(this.local_addr)) {
                                    if (!this.log.isWarnEnabled()) continue;
                                    this.log.warn("I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT message");
                                    continue;
                                }
                                this.up_prot.up(new Event(9, m));
                                this.down_prot.down(new Event(9, m));
                            }
                            break;
                        }
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn("[SUSPECT]: hdr.mbrs == null");
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return null;
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("hdr.mbr is null");
                            }
                            return null;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("who-has-sock " + hdr.mbr);
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return null;
                        }
                        IpAddress addr = (IpAddress)this.cache.get(hdr.mbr);
                        if (addr == null) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, addr);
                        break;
                    }
                    case 12: {
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("[I_HAVE_SOCK]: hdr.mbr is null or hdr.sock_addr == null");
                            }
                            return null;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ')');
                        }
                        if (this.ping_dest == null || !hdr.mbr.equals(this.ping_dest)) break;
                        this.ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        Address sender = msg.getSrc();
                        hdr = new FdHeader(14, new HashMap<Address, IpAddress>(this.cache));
                        msg = new Message(sender, null, null);
                        msg.setFlag((byte)1);
                        msg.putHeader(name, hdr);
                        this.down_prot.down(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cachedAddrs == null) {
                            if (this.log.isWarnEnabled()) {
                                this.log.warn("(GET_CACHE_RSP): cache is null");
                            }
                            return null;
                        }
                        this.get_cache_promise.setResult(hdr.cachedAddrs);
                    }
                }
                return null;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                break;
            }
            case 2: 
            case 80: {
                Object ret = this.down_prot.down(evt);
                this.group_name = (String)evt.getArg();
                this.srv_sock = Util.createServerSocket(this.bind_addr, this.start_port);
                this.srv_sock_addr = new IpAddress(this.bind_addr, this.srv_sock.getLocalPort());
                this.startServerSocket();
                return ret;
            }
            case 4: {
                this.stopServerSocket(true);
                break;
            }
            case 79: {
                this.stopServerSocket(false);
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                final Vector<Address> new_mbrs = v.getMembers();
                Runnable reshuffleSockets = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FD_SOCK fD_SOCK = FD_SOCK.this;
                        synchronized (fD_SOCK) {
                            FD_SOCK.this.members.removeAllElements();
                            FD_SOCK.this.members.addAll(new_mbrs);
                            FD_SOCK.this.cache.keySet().retainAll(FD_SOCK.this.members);
                            FD_SOCK.this.bcast_task.adjustSuspectedMembers(FD_SOCK.this.members);
                            FD_SOCK.this.pingable_mbrs.removeAllElements();
                            FD_SOCK.this.pingable_mbrs.addAll(FD_SOCK.this.members);
                            if (FD_SOCK.this.log.isDebugEnabled()) {
                                FD_SOCK.this.log.debug("VIEW_CHANGE received: " + FD_SOCK.this.members);
                            }
                            if (FD_SOCK.this.members.size() > 1) {
                                if (FD_SOCK.this.pinger_thread != null && FD_SOCK.this.pinger_thread.isAlive()) {
                                    Address tmp_ping_dest = FD_SOCK.this.determinePingDest();
                                    if (FD_SOCK.this.ping_dest != null && tmp_ping_dest != null && !FD_SOCK.this.ping_dest.equals(tmp_ping_dest)) {
                                        FD_SOCK.this.interruptPingerThread();
                                    }
                                } else {
                                    FD_SOCK.this.startPingerThread();
                                }
                            } else {
                                FD_SOCK.this.ping_dest = null;
                                FD_SOCK.this.stopPingerThread();
                            }
                        }
                    }
                };
                this.timer.submit(reshuffleSockets);
                break;
            }
            default: {
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.srv_sock_sent) {
            if (this.srv_sock_addr != null) {
                this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
                this.srv_sock_sent = true;
            } else if (this.log.isWarnEnabled()) {
                this.log.warn("(VIEW_CHANGE): srv_sock_addr == null");
            }
        }
        if (!this.got_cache_from_coord) {
            this.getCacheFromCoordinator();
            this.got_cache_from_coord = true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("pinger_thread started");
        }
        while (this.pinger_thread != null && Thread.currentThread().equals(this.pinger_thread) && this.running) {
            Address tmp_ping_dest = this.determinePingDest();
            if (this.log.isDebugEnabled()) {
                this.log.debug("determinePingDest()=" + tmp_ping_dest + ", pingable_mbrs=" + this.pingable_mbrs);
            }
            if (tmp_ping_dest == null) {
                this.ping_dest = null;
                FD_SOCK fD_SOCK = this;
                synchronized (fD_SOCK) {
                    this.pinger_thread = null;
                    break;
                }
            }
            this.ping_dest = tmp_ping_dest;
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                if (!this.running) break;
                if (this.log.isErrorEnabled()) {
                    this.log.error("socket address for " + this.ping_dest + " could not be fetched, retrying");
                }
                Util.sleep(1000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("could not create socket to " + this.ping_dest + "; suspecting " + this.ping_dest);
                }
                this.broadcastSuspectMessage(this.ping_dest);
                this.pingable_mbrs.removeElement(this.ping_dest);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ping_dest=" + this.ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache);
            }
            try {
                if (this.ping_input == null) continue;
                int c = this.ping_input.read();
                switch (c) {
                    case 9: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("peer closed socket normally");
                        }
                        FD_SOCK fD_SOCK = this;
                        synchronized (fD_SOCK) {
                            this.pinger_thread = null;
                            break;
                        }
                    }
                    case -1: {
                        this.handleSocketClose(null);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                this.log.error("exception", catch_all_the_rest);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("pinger thread terminated");
        }
        FD_SOCK fD_SOCK = this;
        synchronized (fD_SOCK) {
            this.pinger_thread = null;
        }
    }

    void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ')');
            }
            this.broadcastSuspectMessage(this.ping_dest);
            this.pingable_mbrs.removeElement(this.ping_dest);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("socket to " + this.ping_dest + " was reset");
            }
            this.regular_sock_close = false;
        }
    }

    void startPingerThread() {
        this.running = true;
        if (this.pinger_thread == null) {
            this.pinger_thread = this.getProtocolStack().getThreadFactory().newThread(this, "FD_SOCK pinger");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
        }
    }

    void stopPingerThread() {
        this.running = false;
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.pinger_thread = null;
            this.sendPingTermination();
            this.teardownPingSocket();
            this.ping_addr_promise.setResult(null);
            this.get_cache_promise.setResult(null);
        }
    }

    void sendPingTermination() {
        this.sendPingSignal(9);
    }

    void sendPingInterrupt() {
        this.sendPingSignal(8);
    }

    void sendPingSignal(int signal) {
        block4: {
            if (this.ping_sock != null) {
                try {
                    OutputStream out = this.ping_sock.getOutputStream();
                    if (out != null) {
                        out.write(signal);
                        out.flush();
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isTraceEnabled()) break block4;
                    this.log.trace("problem sending signal " + FD_SOCK.signalToString(signal), t);
                }
            }
        }
    }

    void interruptPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.sendPingInterrupt();
            this.teardownPingSocket();
        }
    }

    void startServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
        }
    }

    void stopServerSocket(boolean graceful) {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop(graceful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupPingSocket(IpAddress dest) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (dest == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("destination address is null");
                }
                return false;
            }
            try {
                this.ping_sock = new Socket(dest.getIpAddress(), dest.getPort());
                this.ping_sock.setSoLinger(true, 1);
                this.ping_sock.setKeepAlive(this.keep_alive);
                this.ping_input = this.ping_sock.getInputStream();
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.ping_sock != null) {
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ping_sock = null;
            }
            Util.close(this.ping_input);
            this.ping_input = null;
        }
    }

    void getCacheFromCoordinator() {
        this.get_cache_promise.reset();
        for (int attempts = this.num_tries; attempts > 0 && this.running; --attempts) {
            Address coord = this.determineCoordinator();
            if (coord == null) continue;
            if (coord.equals(this.local_addr)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("first member; cache is empty");
                }
                return;
            }
            FdHeader hdr = new FdHeader(13);
            Message msg = new Message(coord, null, null);
            msg.setFlag((byte)1);
            msg.putHeader(name, hdr);
            this.down_prot.down(new Event(1, msg));
            Map<Address, IpAddress> result = this.get_cache_promise.getResult(this.get_cache_timeout);
            if (result != null) {
                this.cache.putAll(result);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("got cache from " + coord + ": cache is " + this.cache);
                }
                return;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("received null cache; retrying");
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')');
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbrs = new HashSet<Address>(1);
        hdr.mbrs.add(suspected_mbr);
        Message suspect_msg = new Message();
        suspect_msg.setFlag((byte)1);
        suspect_msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, suspect_msg));
        this.bcast_task.addSuspectedMember(suspected_mbr);
        if (this.stats) {
            ++this.num_suspect_events;
            this.suspect_history.add(suspected_mbr);
        }
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        msg.setFlag((byte)1);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, msg));
    }

    private IpAddress fetchPingAddress(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("mbr == null");
            }
            return null;
        }
        IpAddress ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        this.ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        ping_addr_req.setFlag((byte)1);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.down_prot.down(new Event(1, ping_addr_req));
        if (!this.running) {
            return null;
        }
        ret = this.ping_addr_promise.getResult(500L);
        if (ret != null) {
            return ret;
        }
        ping_addr_req = new Message(null);
        ping_addr_req.setFlag((byte)1);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.down_prot.down(new Event(1, ping_addr_req));
        ret = this.ping_addr_promise.getResult(500L);
        return ret;
    }

    private Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < this.pingable_mbrs.size(); ++i) {
            Address tmp = this.pingable_mbrs.elementAt(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= this.pingable_mbrs.size()) {
                return this.pingable_mbrs.elementAt(0);
            }
            return this.pingable_mbrs.elementAt(i + 1);
        }
        return null;
    }

    Address determineCoordinator() {
        return !this.members.isEmpty() ? this.members.elementAt(0) : null;
    }

    static String signalToString(int signal) {
        switch (signal) {
            case 9: {
                return "NORMAL_TERMINATION";
            }
            case -1: {
                return "ABNORMAL_TERMINATION";
            }
            case 8: {
                return "INTERRUPT";
            }
        }
        return "n/a";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BroadcastTask
    implements Runnable {
        final Set<Address> suspected_mbrs = new HashSet<Address>();
        Future future;

        private BroadcastTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Set<Address> set = this.suspected_mbrs;
            synchronized (set) {
                if (this.suspected_mbrs.add(mbr)) {
                    this.startTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug("member is " + suspected_mbr);
            }
            Set<Address> set = this.suspected_mbrs;
            synchronized (set) {
                this.suspected_mbrs.remove(suspected_mbr);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Set<Address> set = this.suspected_mbrs;
            synchronized (set) {
                this.suspected_mbrs.clear();
                this.stopTask();
            }
        }

        private void startTask() {
            block3: {
                if (this.future == null || this.future.isDone()) {
                    try {
                        this.future = FD_SOCK.this.timer.scheduleWithFixedDelay(this, FD_SOCK.this.suspect_msg_interval, FD_SOCK.this.suspect_msg_interval, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException e) {
                        if (!FD_SOCK.this.log.isWarnEnabled()) break block3;
                        FD_SOCK.this.log.warn("task " + this + " was rejected as timer thread pool is shutting down");
                    }
                }
            }
        }

        private void stopTask() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustSuspectedMembers(Vector<Address> new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            Set<Address> set = this.suspected_mbrs;
            synchronized (set) {
                boolean modified = this.suspected_mbrs.retainAll(new_mbrship);
                if (FD_SOCK.this.log.isTraceEnabled() && modified) {
                    FD_SOCK.this.log.trace("adjusted suspected_mbrs: " + this.suspected_mbrs);
                }
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug("broadcasting SUSPECT message (suspected_mbrs=" + this.suspected_mbrs + ") to group");
            }
            Set<Address> set = this.suspected_mbrs;
            synchronized (set) {
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopTask();
                    if (FD_SOCK.this.log.isDebugEnabled()) {
                        FD_SOCK.this.log.debug("task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(10);
                hdr.mbrs = new HashSet<Address>(this.suspected_mbrs);
            }
            Message suspect_msg = new Message();
            suspect_msg.setFlag((byte)1);
            suspect_msg.putHeader(FD_SOCK.name, hdr);
            FD_SOCK.this.down_prot.down(new Event(1, suspect_msg));
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug("task done");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientConnectionHandler
    implements Runnable {
        Socket client_sock = null;
        InputStream in;
        final Object mutex = new Object();
        final List<ClientConnectionHandler> clients = new ArrayList<ClientConnectionHandler>();

        ClientConnectionHandler(Socket client_sock, List<ClientConnectionHandler> clients) {
            this.client_sock = client_sock;
            this.clients.addAll(clients);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread(boolean graceful) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.client_sock != null) {
                    try {
                        if (graceful) {
                            OutputStream out = this.client_sock.getOutputStream();
                            out.write(9);
                            out.flush();
                        }
                        this.closeClientSocket();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeClientSocket() {
            Object object = this.mutex;
            synchronized (object) {
                Util.close(this.client_sock);
                this.client_sock = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    block25: {
                        if (this.client_sock != null) break block25;
                        return;
                    }
                    this.in = this.client_sock.getInputStream();
                }
                int b = 0;
                while ((b = this.in.read()) != -1 && b != 9) {
                }
            }
            catch (IOException ex) {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
            finally {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
        }
    }

    private class ServerSocketHandler
    implements Runnable {
        Thread acceptor = null;
        final List<ClientConnectionHandler> clients = new LinkedList<ClientConnectionHandler>();

        String getName() {
            return this.acceptor != null ? this.acceptor.getName() : null;
        }

        ServerSocketHandler() {
            this.start();
        }

        final void start() {
            if (this.acceptor == null) {
                this.acceptor = FD_SOCK.this.getProtocolStack().getThreadFactory().newThread(this, "FD_SOCK server socket acceptor");
                this.acceptor.setDaemon(true);
                this.acceptor.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void stop(boolean graceful) {
            if (this.acceptor != null && this.acceptor.isAlive()) {
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<ClientConnectionHandler> list = this.clients;
            synchronized (list) {
                for (ClientConnectionHandler handler : this.clients) {
                    handler.stopThread(graceful);
                }
                this.clients.clear();
            }
            this.acceptor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.acceptor != null && FD_SOCK.this.srv_sock != null) {
                try {
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace("waiting for client connections on " + FD_SOCK.this.srv_sock.getInetAddress() + ":" + FD_SOCK.this.srv_sock.getLocalPort());
                    }
                    Socket client_sock = FD_SOCK.this.srv_sock.accept();
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace("accepted connection from " + client_sock.getInetAddress() + ':' + client_sock.getPort());
                    }
                    ClientConnectionHandler client_conn_handler = new ClientConnectionHandler(client_sock, this.clients);
                    Thread t = FD_SOCK.this.getProtocolStack().getThreadFactory().newThread(client_conn_handler, "FD_SOCK client connection handler");
                    t.setDaemon(true);
                    List<ClientConnectionHandler> list = this.clients;
                    synchronized (list) {
                        this.clients.add(client_conn_handler);
                    }
                    t.start();
                }
                catch (IOException io_ex2) {
                    // empty catch block
                    break;
                }
            }
            this.acceptor = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte SUSPECT = 10;
        public static final byte WHO_HAS_SOCK = 11;
        public static final byte I_HAVE_SOCK = 12;
        public static final byte GET_CACHE = 13;
        public static final byte GET_CACHE_RSP = 14;
        byte type = (byte)10;
        Address mbr = null;
        IpAddress sock_addr;
        Map<Address, IpAddress> cachedAddrs = null;
        Set<Address> mbrs = null;
        private static final long serialVersionUID = -7025890133989522764L;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public FdHeader(byte type, Set<Address> mbrs) {
            this.type = type;
            this.mbrs = mbrs;
        }

        public FdHeader(byte type, Map<Address, IpAddress> cachedAddrs) {
            this.type = type;
            this.cachedAddrs = cachedAddrs;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=").append(this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=").append(this.sock_addr);
            }
            if (this.cachedAddrs != null) {
                sb.append(", cache=").append(this.cachedAddrs);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=").append(this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(byte type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.sock_addr);
            out.writeObject(this.cachedAddrs);
            out.writeObject(this.mbrs);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.mbr = (Address)in.readObject();
            this.sock_addr = (IpAddress)in.readObject();
            this.cachedAddrs = (Map)in.readObject();
            this.mbrs = (Set)in.readObject();
        }

        @Override
        public int size() {
            int retval = 1;
            retval += Util.size(this.mbr);
            retval += Util.size(this.sock_addr);
            retval += 4;
            if (this.cachedAddrs != null) {
                for (Map.Entry entry : this.cachedAddrs.entrySet()) {
                    Address key = (Address)entry.getKey();
                    if (key != null) {
                        retval += Util.size(key);
                    }
                    ++retval;
                    IpAddress val = (IpAddress)entry.getValue();
                    if (val == null) continue;
                    retval += val.size();
                }
            }
            retval += 4;
            if (this.mbrs != null) {
                for (Address address : this.mbrs) {
                    retval += Util.size(address);
                }
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.sock_addr, out);
            int size = this.cachedAddrs != null ? this.cachedAddrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Map.Entry<Address, IpAddress> entry : this.cachedAddrs.entrySet()) {
                    Address key = entry.getKey();
                    IpAddress val = entry.getValue();
                    Util.writeAddress(key, out);
                    Util.writeStreamable(val, out);
                }
            }
            size = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Address address : this.mbrs) {
                    Util.writeAddress(address, out);
                }
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int i;
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.sock_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
            int size = in.readInt();
            if (size > 0) {
                if (this.cachedAddrs == null) {
                    this.cachedAddrs = new HashMap<Address, IpAddress>(size);
                }
                for (i = 0; i < size; ++i) {
                    Address key = Util.readAddress(in);
                    IpAddress val = (IpAddress)Util.readStreamable(IpAddress.class, in);
                    this.cachedAddrs.put(key, val);
                }
            }
            if ((size = in.readInt()) > 0) {
                if (this.mbrs == null) {
                    this.mbrs = new HashSet<Address>();
                }
                for (i = 0; i < size; ++i) {
                    Address addr = Util.readAddress(in);
                    this.mbrs.add(addr);
                }
            }
        }
    }
}

