/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.Digest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GmsImpl {
    protected GMS gms = null;
    protected final Log log;
    final boolean trace;
    final boolean warn;
    volatile boolean leaving = false;

    protected GmsImpl() {
        this.log = null;
        this.warn = false;
        this.trace = false;
    }

    protected GmsImpl(GMS gms) {
        this.gms = gms;
        this.log = gms.getLog();
        this.trace = this.log.isTraceEnabled();
        this.warn = this.log.isWarnEnabled();
    }

    public abstract void join(Address var1);

    public abstract void joinWithStateTransfer(Address var1);

    public abstract void leave(Address var1);

    public abstract void handleJoinResponse(JoinRsp var1);

    public abstract void handleLeaveResponse();

    public abstract void suspect(Address var1);

    public abstract void unsuspect(Address var1);

    public void merge(Vector<Address> other_coords) {
    }

    public void handleMergeRequest(Address sender, ViewId merge_id) {
    }

    public void handleMergeResponse(MergeData data, ViewId merge_id) {
    }

    public void handleMergeView(MergeData data, ViewId merge_id) {
    }

    public void handleMergeCancelled(ViewId merge_id) {
    }

    public abstract void handleMembershipChange(Collection<Request> var1);

    public abstract void handleViewChange(View var1, Digest var2);

    public void handleExit() {
    }

    public boolean handleUpEvent(Event evt) {
        return true;
    }

    public void init() throws Exception {
        this.leaving = false;
    }

    public void start() throws Exception {
        this.leaving = false;
    }

    public void stop() {
        this.leaving = true;
    }

    protected void sendMergeRejectedResponse(Address sender, ViewId merge_id) {
        Message msg = new Message(sender, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("response=" + hdr);
        }
        this.gms.getDownProtocol().down(new Event(67, sender));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    protected void wrongMethod(String method_name) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(method_name + "() should not be invoked on an instance of " + this.getClass().getName());
        }
    }

    protected boolean iWouldBeCoordinator(Vector new_mbrs) {
        Membership tmp_mbrs = this.gms.members.copy();
        tmp_mbrs.merge(new_mbrs, null);
        tmp_mbrs.sort();
        return tmp_mbrs.size() > 0 && this.gms.local_addr != null && this.gms.local_addr.equals(tmp_mbrs.elementAt(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request {
        static final int JOIN = 1;
        static final int LEAVE = 2;
        static final int SUSPECT = 3;
        static final int MERGE = 4;
        static final int VIEW = 5;
        static final int JOIN_WITH_STATE_TRANSFER = 6;
        int type = -1;
        Address mbr;
        boolean suspected;
        Vector<Address> coordinators;
        View view;
        Digest digest;
        List<Address> target_members;

        Request(int type) {
            this.type = type;
        }

        Request(int type, Address mbr, boolean suspected, Vector<Address> coordinators) {
            this.type = type;
            this.mbr = mbr;
            this.suspected = suspected;
            this.coordinators = coordinators;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "JOIN(" + this.mbr + ")";
                }
                case 6: {
                    return "JOIN_WITH_STATE_TRANSFER(" + this.mbr + ")";
                }
                case 2: {
                    return "LEAVE(" + this.mbr + ", " + this.suspected + ")";
                }
                case 3: {
                    return "SUSPECT(" + this.mbr + ")";
                }
                case 4: {
                    return "MERGE(" + this.coordinators + ")";
                }
                case 5: {
                    return "VIEW (" + this.view.getVid() + ")";
                }
            }
            return "<invalid (type=" + this.type + ")";
        }

        public boolean canBeProcessedTogether(Request other) {
            if (other == null) {
                return false;
            }
            int other_type = other.getType();
            return !(this.type != 1 && this.type != 2 && this.type != 3 || other_type != 1 && other_type != 2 && other_type != 3);
        }
    }
}

