/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STREAMING_STATE_TRANSFER
extends Protocol {
    private static final String NAME = "STREAMING_STATE_TRANSFER";
    private Address local_addr = null;
    private final Vector<Address> members = new Vector();
    private boolean waiting_for_state_response = false;
    private AtomicInteger num_state_reqs = new AtomicInteger(0);
    private AtomicLong num_bytes_sent = new AtomicLong(0L);
    private volatile double avg_state_size = 0.0;
    private InetAddress bind_addr;
    private int bind_port = 0;
    private int max_pool = 5;
    private long pool_thread_keep_alive;
    private int socket_buffer_size = 8192;
    private volatile boolean flushProtocolInStack = false;
    private StateProviderThreadSpawner spawner;

    @Override
    public final String getName() {
        return NAME;
    }

    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("use_flush");
        if (str != null) {
            this.log.warn("use_flush has been deprecated and its value will be ignored");
            props.remove("use_flush");
        }
        if ((str = props.getProperty("flush_timeout")) != null) {
            this.log.warn("flush_timeout has been deprecated and its value will be ignored");
            props.remove("flush_timeout");
        }
        if ((str = props.getProperty("use_reading_thread")) != null) {
            this.log.warn("use_reading_thread has been deprecated and its value will be ignored");
            props.remove("use_reading_thread");
        }
        try {
            this.bind_addr = Util.parseBindAddress(props, "bind_addr");
        }
        catch (UnknownHostException e) {
            this.log.error("(bind_addr): host " + e.getLocalizedMessage() + " not known");
            return false;
        }
        this.bind_port = Util.parseInt(props, "start_port", 0);
        this.socket_buffer_size = Util.parseInt(props, "socket_buffer_size", 8192);
        this.max_pool = Util.parseInt(props, "max_pool", 5);
        this.pool_thread_keep_alive = Util.parseLong(props, "pool_thread_keep_alive", 30000L);
        if (!props.isEmpty()) {
            this.log.error("the following properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", Boolean.TRUE);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
    }

    @Override
    public void stop() {
        super.stop();
        this.waiting_for_state_response = false;
        if (this.spawner != null) {
            this.spawner.stop();
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.getName());
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("type " + hdr.type + " not known in StateHeader");
                    }
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (this.bind_addr == null && config != null && config.containsKey("bind_addr")) {
                    this.bind_addr = (InetAddress)config.get("bind_addr");
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("using bind_addr from CONFIG event " + this.bind_addr);
                    }
                }
                if (config == null || !config.containsKey("state_transfer")) break;
                this.log.error("Protocol stack cannot contain two state transfer protocols. Remove either one of them");
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: first member (no state)");
                    }
                    this.up_prot.up(new Event(20, new StateTransferInfo()));
                } else {
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(NAME, new StateHeader(1, this.local_addr, info.state_id));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: asking " + target + " for state, passing down a SUSPEND_STABLE event, timeout=" + info.timeout);
                    }
                    this.down_prot.down(new Event(65, new Long(info.timeout)));
                    this.waiting_for_state_response = true;
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 73: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("STATE_TRANSFER_INPUTSTREAM_CLOSED received,passing down a RESUME_STABLE event");
                }
                this.down_prot.down(new Event(66));
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
            }
        }
        return this.down_prot.down(evt);
    }

    private boolean isDigestNeeded() {
        return !this.flushProtocolInStack;
    }

    private void respondToStateRequester(String id, Address stateRequester, boolean open_barrier) {
        if (this.spawner == null) {
            ServerSocket serverSocket = Util.createServerSocket(this.bind_addr, this.bind_port);
            this.spawner = new StateProviderThreadSpawner(this.setupThreadPool(), serverSocket);
            Thread t = this.getProtocolStack().getThreadFactory().newThread(this.spawner, "STREAMING_STATE_TRANSFER server socket acceptor");
            t.start();
        }
        Digest digest = null;
        if (this.isDigestNeeded()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("passing down GET_DIGEST");
            }
            digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
        }
        Message state_rsp = new Message(stateRequester);
        StateHeader hdr = new StateHeader(2, this.local_addr, this.spawner.getServerSocketAddress(), digest, id);
        state_rsp.putHeader(NAME, hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Responding to state requester " + state_rsp.getDest() + " with address " + this.spawner.getServerSocketAddress() + " and digest " + digest);
        }
        this.down_prot.down(new Event(1, state_rsp));
        if (this.stats) {
            this.num_state_reqs.incrementAndGet();
        }
        if (open_barrier) {
            this.down_prot.down(new Event(77));
        }
    }

    private ThreadPoolExecutor setupThreadPool() {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, this.max_pool, this.pool_thread_keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable command) {
                return STREAMING_STATE_TRANSFER.this.getProtocolStack().getThreadFactory().newThread(command, "STREAMING_STATE_TRANSFER sender");
            }
        };
        threadPool.setThreadFactory(factory);
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Vector<Address> vector = this.members;
        synchronized (vector) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Address old_coord;
        Vector<Address> new_members = v.getMembers();
        boolean send_up_null_state_rsp = false;
        Vector<Address> vector = this.members;
        synchronized (vector) {
            old_coord = !this.members.isEmpty() ? this.members.firstElement() : null;
            this.members.clear();
            this.members.addAll(new_members);
            if (this.waiting_for_state_response && old_coord != null && !this.members.contains(old_coord)) {
                send_up_null_state_rsp = true;
            }
        }
        if (send_up_null_state_rsp) {
            this.log.warn("discovered that the state provider (" + old_coord + ") crashed; will return null state to application");
        }
    }

    private void handleStateReq(StateHeader hdr) {
        block6: {
            Address sender = hdr.sender;
            String id = hdr.state_id;
            if (sender == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("sender is null !");
                }
                return;
            }
            if (this.isDigestNeeded()) {
                this.down_prot.down(new Event(76));
            }
            try {
                this.respondToStateRequester(id, sender, this.isDigestNeeded());
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed fetching state from application", t);
                }
                if (!this.isDigestNeeded()) break block6;
                this.down_prot.down(new Event(77));
            }
        }
    }

    void handleStateRsp(StateHeader hdr) {
        Digest tmp_digest = hdr.my_digest;
        this.waiting_for_state_response = false;
        if (this.isDigestNeeded()) {
            if (tmp_digest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("digest received from " + hdr.sender + " is null, skipping setting digest !");
                }
            } else {
                this.down_prot.down(new Event(41, tmp_digest));
            }
        }
        this.connectToStateProvider(hdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToStateProvider(StateHeader hdr) {
        block10: {
            Socket socket;
            StreamingInputStreamWrapper wrapper;
            block9: {
                IpAddress address = hdr.bind_addr;
                String tmp_state_id = hdr.getStateId();
                wrapper = null;
                StateTransferInfo sti = null;
                socket = new Socket();
                try {
                    socket.bind(new InetSocketAddress(this.bind_addr, 0));
                    int bufferSize = socket.getReceiveBufferSize();
                    socket.setReceiveBufferSize(this.socket_buffer_size);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connecting to state provider " + address.getIpAddress() + ":" + address.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getReceiveBufferSize());
                    }
                    socket.connect(new InetSocketAddress(address.getIpAddress(), address.getPort()));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connected to state provider, my end of the socket is " + socket.getLocalAddress() + ":" + socket.getLocalPort() + " passing inputstream up...");
                    }
                    ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                    out.writeObject(tmp_state_id);
                    out.writeObject(this.local_addr);
                    wrapper = new StreamingInputStreamWrapper(socket);
                    sti = new StateTransferInfo(hdr.sender, wrapper, tmp_state_id);
                    this.up_prot.up(new Event(71, sti));
                    if (socket.isConnected() || !this.log.isWarnEnabled()) break block9;
                    this.log.warn("Could not connect to state provider. Closing socket...");
                }
                catch (IOException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("State reader socket thread spawned abnormaly", e);
                    }
                    InputStream is = null;
                    sti = new StateTransferInfo(hdr.sender, is, tmp_state_id);
                    this.up_prot.up(new Event(71, sti));
                    break block10;
                }
                finally {
                    if (!socket.isConnected() && this.log.isWarnEnabled()) {
                        this.log.warn("Could not connect to state provider. Closing socket...");
                    }
                    Util.close(wrapper);
                    Util.close(socket);
                }
            }
            Util.close(wrapper);
            Util.close(socket);
        }
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        long id = 0L;
        byte type = 0;
        Address sender;
        Digest my_digest = null;
        IpAddress bind_addr = null;
        String state_id = null;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, String state_id) {
            this.type = type;
            this.sender = sender;
            this.state_id = state_id;
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public StateHeader(byte type, Address sender, IpAddress bind_addr, Digest digest, String state_id) {
            this.type = type;
            this.sender = sender;
            this.my_digest = digest;
            this.bind_addr = bind_addr;
            this.state_id = state_id;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public String getStateId() {
            return this.state_id;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender).append(" id=").append(this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
            out.writeObject(this.bind_addr);
            out.writeUTF(this.state_id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
            this.bind_addr = (IpAddress)in.readObject();
            this.state_id = in.readUTF();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.bind_addr, out);
            Util.writeString(this.state_id, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.bind_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
            this.state_id = Util.readString(in);
        }

        public int size() {
            int retval = 9;
            retval += Util.size(this.sender);
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            retval += Util.size(this.bind_addr);
            ++retval;
            if (this.state_id != null) {
                retval += this.state_id.length() + 2;
            }
            return retval;
        }
    }

    private class StreamingOutputStreamWrapper
    extends OutputStream {
        private Socket outputStreamOwner;
        private OutputStream delegate;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private long bytesWrittenCounter = 0L;

        public StreamingOutputStreamWrapper(Socket outputStreamOwner) throws IOException {
            this.outputStreamOwner = outputStreamOwner;
            this.delegate = new BufferedOutputStream(outputStreamOwner.getOutputStream());
        }

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State writer is closing the socket ");
                }
                Util.close(this.delegate);
                Util.close(this.outputStreamOwner);
                STREAMING_STATE_TRANSFER.this.up_prot.up(new Event(74));
                STREAMING_STATE_TRANSFER.this.down(new Event(74));
                if (STREAMING_STATE_TRANSFER.this.stats) {
                    STREAMING_STATE_TRANSFER.this.avg_state_size = (double)STREAMING_STATE_TRANSFER.this.num_bytes_sent.addAndGet(this.bytesWrittenCounter) / STREAMING_STATE_TRANSFER.this.num_state_reqs.doubleValue();
                }
            }
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.bytesWrittenCounter += (long)len;
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            if (b != null) {
                this.bytesWrittenCounter += (long)b.length;
            }
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++this.bytesWrittenCounter;
        }
    }

    private class StreamingInputStreamWrapper
    extends InputStream {
        private InputStream delegate;
        private Socket inputStreamOwner;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public StreamingInputStreamWrapper(Socket inputStreamOwner) throws IOException {
            this.inputStreamOwner = inputStreamOwner;
            this.delegate = new BufferedInputStream(inputStreamOwner.getInputStream());
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State reader is closing the socket ");
                }
                Util.close(this.delegate);
                Util.close(this.inputStreamOwner);
                STREAMING_STATE_TRANSFER.this.up_prot.up(new Event(73));
                STREAMING_STATE_TRANSFER.this.down(new Event(73));
            }
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }
    }

    private class StateProviderHandler {
        private StateProviderHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void process(Socket socket) {
            block12: {
                StreamingOutputStreamWrapper wrapper;
                block11: {
                    wrapper = null;
                    ObjectInputStream ois = null;
                    try {
                        int bufferSize = socket.getSendBufferSize();
                        socket.setSendBufferSize(STREAMING_STATE_TRANSFER.this.socket_buffer_size);
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Running on " + Thread.currentThread() + ". Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getSendBufferSize() + ", passing outputstream up... ");
                        }
                        ois = new ObjectInputStream(socket.getInputStream());
                        String state_id = (String)ois.readObject();
                        Address stateRequester = (Address)ois.readObject();
                        wrapper = new StreamingOutputStreamWrapper(socket);
                        StateTransferInfo sti = new StateTransferInfo(stateRequester, wrapper, state_id);
                        STREAMING_STATE_TRANSFER.this.up_prot.up(new Event(72, sti));
                        if (socket.isConnected() || !STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) break block11;
                        STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                    }
                    catch (IOException e) {
                        if (STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("State writer socket thread spawned abnormaly", e);
                        }
                        break block12;
                    }
                    catch (ClassNotFoundException e2) {
                        if (!socket.isConnected() && STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                        }
                        Util.close(wrapper);
                        Util.close(socket);
                        break block12;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (!socket.isConnected() && STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                        }
                        Util.close(wrapper);
                        Util.close(socket);
                    }
                }
                Util.close(wrapper);
                Util.close(socket);
            }
        }
    }

    private class StateProviderThreadSpawner
    implements Runnable {
        ExecutorService pool;
        ServerSocket serverSocket;
        IpAddress address;
        Thread runner;
        volatile boolean running = true;

        public StateProviderThreadSpawner(ExecutorService pool, ServerSocket stateServingSocket) {
            this.pool = pool;
            this.serverSocket = stateServingSocket;
            this.address = new IpAddress(STREAMING_STATE_TRANSFER.this.bind_addr, this.serverSocket.getLocalPort());
        }

        public void run() {
            this.runner = Thread.currentThread();
            while (this.running) {
                try {
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("StateProviderThreadSpawner listening at " + this.getServerSocketAddress() + "...");
                    }
                    final Socket socket = this.serverSocket.accept();
                    this.pool.execute(new Runnable(){

                        public void run() {
                            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                                STREAMING_STATE_TRANSFER.this.log.debug("Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + " handing of to PooledExecutor thread");
                            }
                            new StateProviderHandler().process(socket);
                        }
                    });
                }
                catch (IOException e) {
                    if (!STREAMING_STATE_TRANSFER.this.log.isWarnEnabled() || this.serverSocket == null || this.serverSocket.isClosed()) continue;
                    STREAMING_STATE_TRANSFER.this.log.warn("Spawning socket from server socket finished abnormaly", e);
                }
            }
        }

        public IpAddress getServerSocketAddress() {
            return this.address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void stop() {
            block24: {
                InterruptedException ignored2;
                block22: {
                    block21: {
                        this.running = false;
                        if (this.serverSocket == null || this.serverSocket.isClosed()) break block21;
                        this.serverSocket.close();
                    }
                    Object var3_1 = null;
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                    }
                    if (this.runner == null) break block22;
                    try {
                        this.runner.join(3000L);
                    }
                    catch (InterruptedException ignored2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                }
                this.pool.shutdownNow();
                try {
                    this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored2) {
                    Thread.currentThread().interrupt();
                }
                break block24;
                {
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                        }
                        if (this.runner != null) {
                            try {
                                this.runner.join(3000L);
                            }
                            catch (InterruptedException ignored2) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                        }
                        this.pool.shutdownNow();
                        try {
                            this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ignored2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                    }
                    if (this.runner != null) {
                        try {
                            this.runner.join(3000L);
                        }
                        catch (InterruptedException ignored2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                    }
                    this.pool.shutdownNow();
                    try {
                        this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ignored2) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug("Thread pool is shutdown. All pool threads are cleaned up.");
            }
        }
    }
}

