/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.MPING;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class MergeTest
extends ChannelTestBase {
    public boolean useBlocking() {
        return false;
    }

    public void testMerging2Members() {
        String[] names = null;
        names = MergeTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1, 2) : this.createApplicationNames(2);
        this.mergeHelper(names);
    }

    public void testMerging4Members() {
        String[] names = null;
        names = MergeTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1, 4) : this.createApplicationNames(4);
        this.mergeHelper(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeHelper(String[] names) {
        block14: {
            int count = names.length;
            ChannelTestBase.MemberRetrievable[] channels = new MergeApplication[count];
            try {
                int j;
                DISCARD discard;
                int i;
                Semaphore semaphore = new Semaphore(count);
                semaphore.acquire(count);
                for (int i2 = 0; i2 < count; ++i2) {
                    channels[i2] = new MergeApplication(names[i2], semaphore, false);
                    ((ChannelTestBase.ChannelApplication)channels[i2]).start();
                    semaphore.release(1);
                    MergeTest.sleepRandom(1000, 1500);
                }
                MergeTest.blockUntilViewsReceived(channels, 60000L);
                Util.sleep(2000L);
                int split = count / 2;
                for (i = 0; i < split; ++i) {
                    discard = (DISCARD)((JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel()).getProtocolStack().findProtocol("DISCARD");
                    for (j = split; j < count; ++j) {
                        discard.addIgnoreMember(((ChannelTestBase.ChannelApplication)channels[j]).getLocalAddress());
                    }
                }
                for (i = count - 1; i >= split; --i) {
                    discard = (DISCARD)((JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel()).getProtocolStack().findProtocol("DISCARD");
                    for (j = 0; j < split; ++j) {
                        discard.addIgnoreMember(((ChannelTestBase.ChannelApplication)channels[j]).getLocalAddress());
                    }
                }
                System.out.println("Waiting for split to be detected...");
                Util.sleep(35000L);
                System.out.println("Waiting for merging to kick in....");
                for (i = 0; i < count; ++i) {
                    ((JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel()).getProtocolStack().removeProtocol("DISCARD");
                }
                MergeTest.blockUntilViewsReceived(channels, 60000L);
                boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
                if (!acquired) {
                    this.log.warn("Most likely a bug, analyse the stack below:");
                    this.log.warn(Util.dumpThreads());
                }
                Util.sleep(1000L);
            }
            catch (Exception ex) {
                this.log.warn("Exception encountered during test", ex);
                MergeTest.fail((String)ex.getLocalizedMessage());
            }
            finally {
                for (ChannelTestBase.MemberRetrievable channel : channels) {
                    ((ChannelTestBase.ChannelApplication)channel).cleanup();
                    Util.sleep(2000L);
                }
                if (!this.useBlocking()) break block14;
                for (ChannelTestBase.MemberRetrievable channel : channels) {
                    this.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
                }
            }
        }
    }

    private void addDiscardProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol transport = stack.getTransport();
        DISCARD discard = new DISCARD();
        discard.setProtocolStack(ch.getProtocolStack());
        discard.start();
        stack.insertProtocol(discard, 1, transport.getName());
    }

    private void replaceDiscoveryProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol discovery = stack.removeProtocol("TCPPING");
        if (discovery != null) {
            Protocol transport = stack.getTransport();
            MPING mping = new MPING();
            mping.setProperties(new Properties());
            mping.setProtocolStack(ch.getProtocolStack());
            mping.init();
            mping.start();
            stack.insertProtocol(mping, 1, transport.getName());
            System.out.println("Replaced TCPPING with MPING. See http://wiki.jboss.org/wiki/Wiki.jsp?page=JGroupsMERGE2");
        }
    }

    private void modiftFDAndMergeSettings(JChannel ch) {
        MERGE2 merge;
        ProtocolStack stack = ch.getProtocolStack();
        FD fd = (FD)stack.findProtocol("FD");
        if (fd != null) {
            fd.setMaxTries(3);
            fd.setTimeout(1000L);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }

    public static Test suite() {
        return new TestSuite(MergeTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MergeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class MergeApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        public MergeApplication(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            MergeTest.this.replaceDiscoveryProtocol((JChannel)this.channel);
            MergeTest.this.addDiscardProtocol((JChannel)this.channel);
            MergeTest.this.modiftFDAndMergeSettings((JChannel)this.channel);
        }

        public void useChannel() throws Exception {
            this.channel.connect("test");
        }

        public void viewAccepted(View new_view) {
            this.events.add(new_view);
            MergeTest.this.log.info("Channel " + this.getLocalAddress() + "[" + this.getName() + "] accepted view " + new_view);
        }
    }
}

