/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.OutboundProducer;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundSender
extends OutboundProducer
implements QueueSender {
    OutboundSender(MessageProducer producer, OutboundSession session) {
        super(producer, session);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundSender(" + producer + ", " + session + ")"));
        }
    }

    public Queue getQueue() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getQueue() = " + this.producer.getDestination()));
        }
        this.checkValidity();
        return (Queue)this.producer.getDestination();
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + queue + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + queue + ", " + message + ")"));
        }
        this.checkValidity();
        this.producer.send(queue, message);
    }
}

