/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.ant;

import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class MonologBuildListener
implements BuildListener {
    private LoggerFactory loggerFactory;
    private Logger log;

    public MonologBuildListener() {
        this(Monolog.initialize());
    }

    public MonologBuildListener(Logger log) {
        this.log = log;
        if (log == null) {
            throw new IllegalArgumentException("Non null Logger is required");
        }
    }

    public MonologBuildListener(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        if (loggerFactory == null) {
            throw new IllegalArgumentException("Non null LoggerFactory is required");
        }
    }

    private void log(BuildEvent be) {
        int level;
        Logger logger = this.log == null ? this.loggerFactory.getLogger(be.getProject().getName() + "." + be.getTarget().getName() + "." + be.getTask().getTaskName()) : this.log;
        switch (be.getPriority()) {
            case 0: {
                level = BasicLevel.ERROR;
                break;
            }
            case 1: {
                level = BasicLevel.WARN;
                break;
            }
            case 2: {
                level = BasicLevel.INFO;
                break;
            }
            default: {
                level = BasicLevel.DEBUG;
            }
        }
        if (be.getSource() != null) {
            if (be.getException() != null) {
                logger.log(level, (Object)be.getMessage(), be.getException(), be.getSource(), be.getSource());
            } else {
                logger.log(level, (Object)be.getMessage(), be.getSource(), be.getSource());
            }
        } else if (be.getException() != null) {
            logger.log(level, (Object)be.getMessage(), be.getException());
        } else {
            logger.log(level, (Object)be.getMessage());
        }
    }

    public void buildStarted(BuildEvent be) {
        this.log(be);
    }

    public void buildFinished(BuildEvent be) {
        this.log(be);
    }

    public void targetStarted(BuildEvent be) {
        this.log(be);
    }

    public void targetFinished(BuildEvent be) {
        this.log(be);
    }

    public void taskStarted(BuildEvent be) {
        this.log(be);
    }

    public void taskFinished(BuildEvent be) {
        this.log(be);
    }

    public void messageLogged(BuildEvent be) {
        this.log(be);
    }
}

