/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.UID;
import java.util.Arrays;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JClientInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorStore;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.jrmp.server.JLocalObjectStore;
import org.ow2.carol.rmi.jrmp.server.JRemoteCall;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;

public class JUnicastRef
extends UnicastRef {
    private transient boolean localRef = false;
    private transient byte[] raddr = null;
    private transient UID ruid = null;
    protected transient JClientRequestInterceptor[] cis = null;
    protected transient String[] initializers = null;
    private transient int localId = -2;

    public JUnicastRef() {
    }

    public JUnicastRef(LiveRef liveRef) {
        super(liveRef);
    }

    public JUnicastRef(LiveRef liveRef, JClientRequestInterceptor[] cis, String[] initial, int local) {
        super(liveRef);
        this.initializers = initial;
        this.cis = cis;
        this.raddr = JInterceptorHelper.getInetAddress();
        this.ruid = JInterceptorHelper.getSpaceID();
        this.localId = local;
    }

    public String getRefClass(ObjectOutput out) {
        super.getRefClass(out);
        return null;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        if (this.localRef && this.localId != -2) {
            try {
                return method.invoke(JLocalObjectStore.getObject(this.localId), params);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new Exception("Unsupported exception", t);
            }
            catch (IllegalArgumentException iae) {
                return this.performRemoteCall(method, params, opnum);
            }
        }
        return this.performRemoteCall(method, params, opnum);
    }

    /*
     * Exception decompiling
     */
    private Object performRemoteCall(Method method, Object[] params, long opnum) throws RemoteException, Exception, Error {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void invoke(RemoteCall call) throws Exception {
        super.invoke(call);
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        Connection conn = this.ref.getChannel().newConnection();
        try {
            JRemoteCall call = new JRemoteCall(conn, this.ref.getObjID(), opnum, hash, this.cis);
            try {
                this.marshalCustomCallData(call.getOutputStream());
            }
            catch (IOException e) {
                throw new MarshalException("error marshaling custom call data");
            }
            return call;
        }
        catch (RemoteException e) {
            this.ref.getChannel().free(conn, false);
            throw e;
        }
    }

    protected void marshalCustomCallData(ObjectOutput out) throws IOException {
        JClientInterceptorHelper.send_request(out, this.cis, this.localRef);
        super.marshalCustomCallData(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, false);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, false);
    }

    public void readExternal(ObjectInput in, boolean newFormat) throws IOException, ClassNotFoundException {
        this.raddr = new byte[in.readInt()];
        in.read(this.raddr);
        this.ruid = UID.read(in);
        this.localRef = Arrays.equals(this.raddr, JInterceptorHelper.getInetAddress()) && this.ruid.equals(JInterceptorHelper.getSpaceID());
        String[] ia = new String[in.readInt()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = in.readUTF();
        }
        this.initializers = ia;
        this.cis = JInterceptorStore.getJInterceptorStore().setRemoteInterceptors(ia);
        this.localId = in.readInt();
        this.ref = LiveRef.read(in, newFormat);
    }

    public void writeExternal(ObjectOutput out, boolean newFormat) throws IOException {
        out.writeInt(this.raddr.length);
        out.write(this.raddr);
        this.ruid.write(out);
        String[] ia = this.initializers;
        out.writeInt(ia.length);
        for (int i = 0; i < ia.length; ++i) {
            out.writeUTF(ia[i]);
        }
        out.writeInt(this.getLocalId());
        this.ref.write(out, newFormat);
        out.flush();
    }

    public int getLocalId() {
        return this.localId;
    }
}

