/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.config.CMIConfigException;

@Immutable
public final class UtilConfig {
    private UtilConfig() {
    }

    public static Properties getPropertiesFromURL(URL url) throws CMIConfigException {
        if (url == null) {
            return new Properties();
        }
        InputStream is = null;
        try {
            URLConnection urlConnect = null;
            urlConnect = url.openConnection();
            urlConnect.setDefaultUseCaches(false);
            is = urlConnect.getInputStream();
        }
        catch (IOException ioe) {
            throw new CMIConfigException("Invalid URL '" + url + "' : " + ioe.getMessage(), ioe);
        }
        if (is == null) {
            throw new CMIConfigException("No inputstream for URL '" + url + "'.");
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ioe) {
            throw new CMIConfigException("Could not load input stream of  URL '" + url + "' : " + ioe.getMessage());
        }
        try {
            is.close();
        }
        catch (IOException ioe) {
            throw new CMIConfigException("Cannot close inputStream", ioe);
        }
        return p;
    }
}

