/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIAdminConnectorManager;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.cmi.controller.server.ClusteredDummyRegistry;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.FirstAvailable;
import org.ow2.cmi.lb.policy.HASingleton;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.policy.Random;
import org.ow2.cmi.lb.policy.RoundRobin;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.LoadFactorComparator;
import org.ow2.cmi.lb.strategy.LoadFactorSort;
import org.ow2.cmi.lb.strategy.LocalPreference;
import org.ow2.cmi.lb.strategy.NoStrategy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsServerClusterViewManager
extends AbsClusterViewManager
implements ServerClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsServerClusterViewManager.class);
    private final Map<String, String> initialContextFactories = new ConcurrentHashMap<String, String>();
    private final Map<String, ServerRef> refsOnLocalRegistries = new ConcurrentHashMap<String, ServerRef>();
    private final Map<String, Remote> clientClusterViewProviders = new ConcurrentHashMap<String, Remote>();
    private final Map<String, Context> contexts = new ConcurrentHashMap<String, Context>();
    private InetAddress inetAddress = null;
    private ClusteredObjectInfo clusteredObjectInfoForDummyRegistry;
    private boolean replicationManagerStarted = false;
    private static boolean started = false;
    private final ConcurrentHashMap<String, Class<?>> interfaces = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends IPolicy>> policyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends IStrategy>> strategyMap = new ConcurrentHashMap();
    private final Class<?>[] embeddedPolicyClasses = new Class[]{FirstAvailable.class, HASingleton.class, Random.class, RoundRobin.class};
    private final Class<?>[] embeddedStrategyClasses = new Class[]{NoStrategy.class, LoadFactorSort.class, LoadFactorComparator.class, LocalPreference.class};

    public static synchronized ServerClusterViewManager start() throws ServerClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (!started && clusterViewManager != null) {
            LOGGER.warn("CMI has been already started with the creation of a new initial context.", new Object[0]);
            started = true;
            if (!(clusterViewManager instanceof ServerClusterViewManager)) {
                throw new ServerClusterViewManagerException("A cluster view manager already exists but doesn't implement the interface ServerClusterViewManager");
            }
        } else if (!started) {
            clusterViewManager = AbsServerClusterViewManager.getServerClusterViewManager();
            ((AbsServerClusterViewManager)clusterViewManager).doStart();
            started = true;
        }
        return (ServerClusterViewManager)clusterViewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (started) {
            AbsServerClusterViewManager serverClusterViewManager = (AbsServerClusterViewManager)AbsServerClusterViewManager.getServerClusterViewManager();
            try {
                MBeanUtils.unregisterCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot unregister CMIMBean", e);
            }
            for (String protocol : serverClusterViewManager.initialContextFactories.keySet()) {
                try {
                    serverClusterViewManager.contexts.get(protocol).unbind(CMIConfig.getBindNameForProvider());
                }
                catch (NamingException e) {
                    LOGGER.error("Cannot unbind the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
                }
                System.setProperty("carol.multipro.protocol", protocol);
                try {
                    PortableRemoteObject.unexportObject((Remote)serverClusterViewManager.clientClusterViewProviders.get(protocol));
                }
                catch (NoSuchObjectException e) {
                    LOGGER.error("Cannot unexport the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
                }
                finally {
                    System.setProperty("carol.multipro.protocol", "any");
                }
            }
            serverClusterViewManager.doStop();
            AbsClusterViewManager.setClusterViewManager(null);
            started = false;
            LOGGER.info("The server-side manager is now stopped.", new Object[0]);
        }
    }

    public abstract void doStart();

    public abstract void doStop();

    public static final synchronized ServerClusterViewManager getServerClusterViewManager() throws ServerClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager == null) {
            AbsServerClusterViewManager serverClusterViewManager;
            Class<? extends ServerClusterViewManager> serverClusterViewManagerClass;
            try {
                MBeanUtils.initCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot initializes CMIMBean", e);
            }
            try {
                serverClusterViewManagerClass = CMIConfig.getServerClusterViewManagerClass();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot load the class implementing a server-side manager.", new Object[0]);
                throw new ServerClusterViewManagerException("Cannot load the class implementing a server-side manager.", e);
            }
            LOGGER.debug("The ServerClusterViewManager is: {0}", serverClusterViewManagerClass.getName());
            try {
                Method factory = serverClusterViewManagerClass.getDeclaredMethod("getJGroupsClusterViewManager", new Class[0]);
                if (!factory.isAccessible()) {
                    factory.setAccessible(true);
                }
                serverClusterViewManager = (AbsServerClusterViewManager)factory.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot create the instance (singleton) of ServerClusterViewManager", e);
                throw new ServerClusterViewManagerException("Cannot get an instance of ServerClusterViewManager", e);
            }
            LOGGER.debug("ServerClusterViewManager has been created", new Object[0]);
            serverClusterViewManager.loadEmbeddedLBClasses();
            try {
                serverClusterViewManager.clusteredObjectInfoForDummyRegistry = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(CMIConfig.getBindNameForDummyRegistry(), null, ClusteredDummyRegistry.class, false, false, null);
            }
            catch (CMIInfoExtractorException e) {
                LOGGER.error("Cannot get infos for dummy context", e);
                throw new ServerClusterViewManagerException("Cannot get infos for dummy context", e);
            }
            serverClusterViewManager.setDelayToRefresh(CMIConfig.getRefreshTime());
            try {
                MBeanUtils.registerCMIMBean(serverClusterViewManager);
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot register CMIMBean", e);
            }
            serverClusterViewManager.initStats();
            clusterViewManager = serverClusterViewManager;
            AbsClusterViewManager.setClusterViewManager(clusterViewManager);
            LOGGER.info("The server-side manager was successfully started", new Object[0]);
        } else if (!(clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("An instance of the manager that is not a ServerClusterViewManager already exists in the JVM", new Object[0]);
            throw new ServerClusterViewManagerException("An instance of the manager that is not a ServerClusterViewManager already exists in the JVM");
        }
        return (ServerClusterViewManager)clusterViewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addProtocol(String initialContextFactoryName, ServerRef serverRef, Context cmiContext) throws ServerClusterViewManagerException {
        String protocol = serverRef.getProtocol();
        String providerURL = serverRef.getProviderURL();
        String string = initialContextFactoryName;
        synchronized (string) {
            if (!this.initialContextFactories.containsKey(protocol)) {
                LOGGER.debug("New protocol {0} added", protocol);
                this.initialContextFactories.put(protocol, initialContextFactoryName);
                if (CMIConfig.isProviderBound()) {
                    LOGGER.debug("Binds a provider of the cluster view for protocol {0}", protocol);
                    this.bindClientClusterViewProvider(cmiContext, protocol);
                }
                if (CMIConfig.isRegistryBound()) {
                    LOGGER.debug("Binds a dummy object that represents the registry for protocol {0}", protocol);
                    this.bindDummyRegistry(serverRef);
                }
                this.refsOnLocalRegistries.put(protocol, serverRef);
                InetAddress newInetAddress = serverRef.getInetAddress();
                try {
                    if (NetworkInterface.getByInetAddress(newInetAddress) == null) {
                        LOGGER.error("The referenced server is not local", new Object[0]);
                        throw new ServerClusterViewManagerException("The referenced server is not local");
                    }
                }
                catch (SocketException e) {
                    LOGGER.error("Cannot know if the IP is local", e);
                    throw new ServerClusterViewManagerException("Cannot know if the IP is local", e);
                }
                if (this.inetAddress == null) {
                    LOGGER.debug("InetAdress of manager is {0}", newInetAddress);
                    this.inetAddress = newInetAddress;
                } else if (!newInetAddress.equals(this.inetAddress)) {
                    LOGGER.error("Host name expected: {0} - Host name found : {1}. All the protocol have to use the same host name !", this.inetAddress, newInetAddress);
                    throw new ServerClusterViewManagerException("Host name expected: " + this.inetAddress.getHostName() + " - Host name found : " + newInetAddress.getHostName() + ". All the protocol have to use the same host name !");
                }
                this.setLoadFactor(serverRef, CMIConfig.getLoadFactor());
                if (!CMIConfig.isEmbedded() && CMIConfig.isConnectorEnabled(protocol)) {
                    try {
                        CMIAdminConnectorManager.startConnector(protocol, providerURL);
                    }
                    catch (CMIMBeanConfigException e) {
                        LOGGER.error("The connector for the protocol {0} cannot be added", protocol, e);
                        throw new ServerClusterViewManagerException("The connector for the protocol " + protocol + " cannot be added", e);
                    }
                }
            }
        }
    }

    private void bindClientClusterViewProvider(Context cmiContext, String protocol) throws ServerClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        ClusteredClientClusterViewProvider clientClusterViewProvider = null;
        System.setProperty("carol.multipro.protocol", protocol);
        try {
            clientClusterViewProvider = new ClusteredClientClusterViewProvider(this);
        }
        catch (RemoteException e) {
            LOGGER.error("Cannot export the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot export the instance of ClientClusterViewProvider for the protocol " + protocol, e);
        }
        finally {
            System.setProperty("carol.multipro.protocol", "any");
        }
        String bindName = CMIConfig.getBindNameForProvider();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(bindName, ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error("Cannot get infos for client provider", e);
            throw new ServerClusterViewManagerException("Cannot get infos for client provider", e);
        }
        CMIInfoRepository.addClusteredObjectInfo(bindName, clusteredObjectInfo);
        try {
            cmiContext.rebind(bindName, (Object)clientClusterViewProvider);
        }
        catch (NamingException e) {
            LOGGER.error("Cannot rebind a ClientClusterViewProvider for protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot rebind a ClientClusterViewProvider " + protocol, e);
        }
        this.clientClusterViewProviders.put(protocol, clientClusterViewProvider);
        this.contexts.put(protocol, cmiContext);
        LOGGER.debug("ClientClusterViewProvider has been rebound for the protocol {0} with the name {1}", protocol, bindName);
    }

    private void bindDummyRegistry(ServerRef serverRef) {
        String bindName = CMIConfig.getBindNameForDummyRegistry();
        CMIReference cmiReference = new CMIReference(serverRef, bindName);
        this.addObjectInstance(this.clusteredObjectInfoForDummyRegistry, cmiReference);
    }

    @Override
    public final synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException {
        if (!this.isWatched(objectName)) {
            LOGGER.debug("Adding {0} to the set of watched object", objectName);
            this.watch(objectName);
            this.updatePolicy(objectName);
        }
    }

    @Override
    public final synchronized void addObjectInstance(ClusteredObjectInfo clusteredObjectInfo, CMIReference cmiReference) {
        Class<?> itfClass = clusteredObjectInfo.getItfClass();
        String businessName = null;
        String itfName = null;
        if (itfClass != null) {
            Class<? extends EJBObject> businessClass = clusteredObjectInfo.getBusinessClass();
            itfName = itfClass.getName();
            this.interfaces.putIfAbsent(itfName, itfClass);
            if (businessClass != null) {
                businessName = businessClass.getName();
                this.interfaces.putIfAbsent(businessName, businessClass);
            }
        }
        Class<IPolicy<?>> policyClass = clusteredObjectInfo.getPolicyType();
        Class<IStrategy<?>> strategyClass = clusteredObjectInfo.getStrategyType();
        String clusterName = clusteredObjectInfo.getClusterName();
        IPoolConfiguration poolConfiguration = clusteredObjectInfo.getPoolConfiguration();
        String policyType = policyClass.getName();
        String strategyType = strategyClass.getName();
        Map<String, Object> properties = clusteredObjectInfo.getProperties();
        boolean hasState = clusteredObjectInfo.hasState();
        boolean replicated = clusteredObjectInfo.isReplicated();
        Set<String> applicationExceptionNames = clusteredObjectInfo.getApplicationExceptionNames();
        new PolicyFactory(this).getPolicy(policyClass, strategyClass, properties);
        PolicyData policyData = new PolicyData(policyType, strategyType, properties);
        String objectName = cmiReference.getObjectName();
        DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(clusterName, objectName, itfName, businessName, policyData, hasState, replicated, applicationExceptionNames, poolConfiguration);
        this.addDistributedObjectInfo(objectName, distributedObjectInfo);
        LOGGER.debug("Adding {0}...", cmiReference);
        this.addCMIReference(cmiReference);
    }

    protected abstract boolean containObject(String var1);

    protected abstract DistributedObjectInfo getDistributedObjectInfo(String var1) throws ObjectNotFoundException;

    protected abstract void addDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    protected abstract void setDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    @Override
    public final String getItfName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getItfName();
    }

    @Override
    public final Class<?> getInterface(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getItfName(objectName));
    }

    @Override
    public final String getBusinessName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getBusinessName();
    }

    @Override
    public final Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getBusinessName(objectName));
    }

    @Override
    public final List<String> getProviderURLs(String protocolName) throws ServerClusterViewManagerException {
        String providerName = CMIConfig.getBindNameForProvider();
        ArrayList<String> providerURLs = new ArrayList<String>();
        try {
            for (CMIReference cmiReference : this.getCMIReferences(providerName, protocolName)) {
                providerURLs.add(cmiReference.getServerRef().getProviderURL());
            }
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Cannot get CMIReferences for the provider whith name {0}", providerName, e);
            throw new ServerClusterViewManagerException("Cannot get CMIReferences for the provider whith name " + providerName, e);
        }
        return providerURLs;
    }

    @Override
    public final Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String policyClassName = this.getPolicyClassName(objectName);
        try {
            Class<?> policyClass = Class.forName(policyClassName);
            this.policyMap.putIfAbsent(policyClassName, policyClass);
            return policyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the class for policy " + policyClassName, e);
            throw new ServerClusterViewManagerException("Cannot load the class for policy " + policyClassName, e);
        }
    }

    @Override
    public final Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String strategyClassName = this.getStrategyClassName(objectName);
        try {
            Class<?> strategyClass = Class.forName(strategyClassName);
            this.strategyMap.putIfAbsent(strategyClassName, strategyClass);
            return strategyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the class for strategy " + strategyClassName, e);
            throw new ServerClusterViewManagerException("Cannot load the class for strategy " + strategyClassName, e);
        }
    }

    @Override
    public final long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getDateOfProperties();
    }

    @Override
    public final Map<String, Object> getPropertiesForPolicy(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties();
    }

    @Override
    public final Object getPropertyForPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertiesForPolicy(String objectName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            for (String propertyName : properties.keySet()) {
                distributedObjectInfo.getPolicyData().setProperty(propertyName, properties.get(propertyName));
            }
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertyForPolicy(String objectName, String propertyName, Object valueName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setProperty(propertyName, valueName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getInitialContextFactoryName(String protocolName) {
        return this.initialContextFactories.get(protocolName);
    }

    @Override
    public final boolean isClustered(String objectName) {
        return this.containObject(objectName);
    }

    @Override
    public final String getClusterName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getClusterName();
    }

    @Override
    public final String getPolicyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getPolicyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPolicyClassName(String objectName, String policyType) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setPolicyType(policyType);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getStrategyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getStrategyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStrategyClassName(String objectName, String strategyClassName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setStrategyType(strategyClassName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAlgorithmForPolicy(String objectName, String policyClassName, String strategyClassName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            PolicyData policyData = distributedObjectInfo.getPolicyData();
            policyData.setPolicyType(policyClassName);
            policyData.setStrategyType(strategyClassName);
            policyData.setProperties(properties);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public IPoolConfiguration getPoolConfiguration(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPoolConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolConfiguration(String objectName, IPoolConfiguration poolConfiguration) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.setPoolConfiguration(poolConfiguration);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public final Set<String> getProtocols() {
        return new HashSet<String>(this.refsOnLocalRegistries.keySet());
    }

    @Override
    public final JMXServiceURL getJMXServiceURL(String protocolName) {
        return CMIAdminConnectorManager.getJMXServiceURL(protocolName);
    }

    @Override
    public final ServerRef getRefOnLocalRegistry(String protocolName) {
        return this.refsOnLocalRegistries.get(protocolName);
    }

    protected abstract void initStats();

    @Override
    public final boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return this.isReplicationManagerStarted() && this.getDistributedObjectInfo(objectName).isReplicated();
    }

    @Override
    public final Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getApplicationExceptionNames();
    }

    @Override
    public boolean hasState(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).hasState();
    }

    @Override
    public final boolean isReplicationManagerStarted() {
        return this.replicationManagerStarted;
    }

    @Override
    public final void setReplicationManagerStarted(boolean replicationManagerStarted) {
        this.replicationManagerStarted = replicationManagerStarted;
    }

    @Override
    public Map<String, Set<String>> getAvailablePoliciesAndStrategies() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        ret.put("policies", new HashSet(this.policyMap.keySet()));
        ret.put("strategies", new HashSet(this.strategyMap.keySet()));
        return ret;
    }

    private void loadEmbeddedLBClasses() {
        for (Class<?> embeddedPolicyClass : this.embeddedPolicyClasses) {
            try {
                this.policyMap.put(embeddedPolicyClass.getName(), embeddedPolicyClass);
            }
            catch (Exception e) {
                LOGGER.error("Cannot load the class for policy " + embeddedPolicyClass.getName(), e);
                throw new ServerClusterViewManagerException("Cannot load the class for policy " + embeddedPolicyClass.getName(), e);
            }
        }
        for (Class<?> embeddedStrategyClass : this.embeddedStrategyClasses) {
            try {
                this.strategyMap.put(embeddedStrategyClass.getName(), embeddedStrategyClass);
            }
            catch (Exception e) {
                LOGGER.error("Cannot load the class for strategy " + embeddedStrategyClass.getName(), e);
                throw new ServerClusterViewManagerException("Cannot load the class for startegy " + embeddedStrategyClass.getName(), e);
            }
        }
    }

    public boolean isEmbeddedPolicy(String className) {
        for (Class<?> embeddedPolicyClass : this.embeddedPolicyClasses) {
            if (!embeddedPolicyClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmbeddedStrategy(String className) {
        for (Class<?> embeddedStrategyClass : this.embeddedStrategyClasses) {
            if (!embeddedStrategyClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

