/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jgroups;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import javax.management.MBeanServer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.stack.IpAddress;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.common.CMIThreadFactory;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.impl.jgroups.IIntercepted;
import org.ow2.cmi.controller.server.impl.jgroups.JGroupsClusterViewManagerException;
import org.ow2.cmi.controller.server.impl.jgroups.JGroupsServerConfig;
import org.ow2.cmi.controller.server.impl.jgroups.ResumableRunnable;
import org.ow2.cmi.controller.server.impl.jgroups.SynchronizedDistributedTree;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.cluster.jgroups.ConnectionManager;
import org.ow2.util.cluster.jgroups.IDistributedTree;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class JGroupsClusterViewManager
extends AbsServerClusterViewManager
implements IDistributedTree.DistributedTreeListener,
IDistributedTree.ViewListener {
    private static final Log LOGGER = LogFactory.getLog(JGroupsClusterViewManager.class);
    private final IDistributedTree distributedTree;
    public static final boolean isChannelClosed = false;
    private final IpAddress localAddress;
    @GuardedBy(value="pathsToDelete")
    private final Set<String> pathsToDelete = Collections.synchronizedSet(new HashSet());
    private final Thread garbageThread;
    private final ResumableRunnable resumableRunnable;
    private final Object lock = new Object();
    private ConnectionManager connectionManager;

    private JGroupsClusterViewManager() throws Exception {
        String groupName = JGroupsServerConfig.getGroupName();
        LOGGER.debug("Group name: {0}", groupName);
        String stack = JGroupsServerConfig.getStack();
        LOGGER.debug("The stack is :{0}", stack);
        long reconTimeout = JGroupsServerConfig.getJGroupsReconnectionTimeoutProps();
        LOGGER.debug("Reconnection timeout for JGroups DistributedTree is :{0} ms", reconTimeout);
        SynchronizedDistributedTree distributedTreeCopy = new SynchronizedDistributedTree(groupName, stack);
        distributedTreeCopy.addDistributedTreeListener(this);
        distributedTreeCopy.addViewListener(this);
        this.connectionManager = new ConnectionManager(reconTimeout, distributedTreeCopy, IIntercepted.class);
        this.distributedTree = (IDistributedTree)Proxy.newProxyInstance(IDistributedTree.class.getClassLoader(), new Class[]{IDistributedTree.class}, (InvocationHandler)this.connectionManager);
        distributedTreeCopy.start();
        JChannel channel = (JChannel)distributedTreeCopy.getChannel();
        channel.addChannelListener(this.connectionManager);
        try {
            JmxConfigurator.registerChannel(channel, MBeanUtils.getMBeanServer(), MBeanUtils.getMBeanDomainName(), channel.getClusterName() + ",name=" + CMIConfig.getCMIAdminMBeanName(), true);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register the channel to the MBean Server", e);
        }
        Address obj = distributedTreeCopy.getLocalAddress();
        if (obj == null) {
            LOGGER.error("Cannot get the local address", new Object[0]);
            throw new JGroupsClusterViewManagerException("Cannot get the local address");
        }
        if (!(obj instanceof IpAddress)) {
            String className = obj.getClass().getName();
            LOGGER.error("At this time only IP address are supported, and not: {0}.", className);
            throw new JGroupsClusterViewManagerException("At this timen only IP address are supported, and not: " + className);
        }
        this.localAddress = (IpAddress)obj;
        LOGGER.debug("IpAddress: {0}", this.localAddress);
        CMIThreadFactory cmiThreadFactory = this.getCmiThreadFactory();
        this.resumableRunnable = new TreeCleaner();
        this.garbageThread = cmiThreadFactory.newThread(this.resumableRunnable);
    }

    private static JGroupsClusterViewManager getJGroupsClusterViewManager() throws Exception {
        JGroupsClusterViewManager jgroupsClusterViewManager = new JGroupsClusterViewManager();
        jgroupsClusterViewManager.garbageThread.start();
        return jgroupsClusterViewManager;
    }

    @Override
    public void doStart() {
    }

    @Override
    public void doStop() {
        this.resumableRunnable.stopExecution();
        String domain = MBeanUtils.getMBeanDomainName();
        JChannel channel = (JChannel)this.distributedTree.getChannel();
        String cluster_name = channel.getClusterName();
        String name = domain + ":type=channel,cluster=" + cluster_name + ",name=" + CMIConfig.getCMIAdminMBeanName();
        MBeanServer mBeanServer = MBeanUtils.getMBeanServer();
        try {
            JmxConfigurator.unregisterChannel(mBeanServer, name);
        }
        catch (Exception e) {
            LOGGER.error("Error when unregistering the channel with name {0} from the MBean server", cluster_name, e);
        }
        String tmp = domain + ":type=protocol,cluster=" + cluster_name + ",name=" + CMIConfig.getCMIAdminMBeanName();
        JmxConfigurator.unregisterProtocols(mBeanServer, channel, tmp);
        this.connectionManager.setTimeout(0L);
        this.distributedTree.stop();
    }

    private void removePath(String pathToDelete) {
        this.distributedTree.remove(pathToDelete);
    }

    @Override
    protected boolean containObject(String objectName) {
        try {
            return this.distributedTree.exists(this.getObjectPath(objectName));
        }
        catch (Exception e) {
            LOGGER.debug("The distributed tree is not available. The object {0} is considered as missing", objectName, e);
            return false;
        }
    }

    @Override
    protected DistributedObjectInfo getDistributedObjectInfo(String objectName) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        Serializable obj = this.distributedTree.get(objectPath);
        if (obj == null) {
            LOGGER.error("Unknown object with name {0}", objectName);
            throw new ObjectNotFoundException("Unknown object with name " + objectName);
        }
        try {
            return ((DistributedObjectInfo)obj).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Amazing bug... I don't believe it !");
        }
    }

    @Override
    protected void addDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        String objectPath = this.getObjectPath(objectName);
        LOGGER.debug("Adding {0} at the path {1}", distributedObjectInfo, objectPath);
        this.distributedTree.add(objectPath, distributedObjectInfo);
    }

    @Override
    protected void setDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        String objectPath = this.getObjectPath(objectName);
        LOGGER.debug("Adding {0} at the path {1}", distributedObjectInfo, objectPath);
        LOGGER.debug("Old infos: {0}", this.distributedTree.get(objectPath));
        this.distributedTree.set(objectPath, distributedObjectInfo);
    }

    private void registerPath(CMIReference cmiReference) {
        String path = this.getCMIReferencePath(cmiReference);
        String hostname = this.localAddress.getIpAddress().getHostAddress();
        int port = this.localAddress.getPort();
        String address = this.getAddressPath(hostname, port);
        String instAddr = this.getInstAddrPath(address, cmiReference.getServerRef().getProtocol() + "_" + cmiReference.getObjectName());
        this.distributedTree.add(instAddr, (Serializable)((Object)path));
    }

    private void unRegisterPath(CMIReference cmiReference) {
        String hostname = this.localAddress.getIpAddress().getHostAddress();
        int port = this.localAddress.getPort();
        String address = this.getAddressPath(hostname, port);
        String instAddr = this.getInstAddrPath(address, cmiReference.getServerRef().getProtocol() + "_" + cmiReference.getObjectName());
        this.distributedTree.remove(instAddr);
    }

    @Override
    public Set<ServerRef> getServerRefs(String protocolName) throws ServerClusterViewManagerException {
        HashSet<ServerRef> serverRefs = new HashSet<ServerRef>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName, false)) {
                    serverRefs.add(cmiRef.getServerRef());
                }
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(protocolName + " is unknown", e);
            }
        }
        return serverRefs;
    }

    @Override
    public Set<String> getServerObjectForProtocol(String serverUrl, String protocolName) throws ServerClusterViewManagerException {
        HashSet<String> objectRefs = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName, false)) {
                    if (!cmiRef.getServerRef().getProviderURL().equals(serverUrl)) continue;
                    objectRefs.add(objectName);
                }
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(protocolName + " is unknown", e);
            }
        }
        if (objectRefs.isEmpty()) {
            throw new ServerClusterViewManagerException(serverUrl + " is unknown for " + protocolName + " protocol");
        }
        return objectRefs;
    }

    @Override
    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        return this.getCMIReferences(objectName, protocolName, true);
    }

    private List<CMIReference> getCMIReferences(String objectName, String protocolName, boolean filter) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        String protoPath = this.getProtocolPath(objectPath, protocolName);
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        Vector<String> childrenNames = this.distributedTree.getChildrenNames(protoPath);
        if (childrenNames.isEmpty()) {
            LOGGER.error("Unknown object {0} or protocol {1}", objectName, protocolName);
            throw new ObjectNotFoundException("Unknown object " + objectName + " or protocol " + protocolName);
        }
        for (String childrenName : childrenNames) {
            CMIReference cmiReference = this.getCMIReference(protoPath, childrenName);
            if (!filter || filter && !this.isServerBlackListed(cmiReference.getServerRef())) {
                cmiReferences.add(cmiReference);
                continue;
            }
            LOGGER.debug("Do not add {0} because the server with ref {1} is black listed", cmiReference, cmiReference.getServerRef());
        }
        return cmiReferences;
    }

    @Override
    public List<CMIReference> getCMIReferences(String objectName) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        Vector<String> protocols = this.distributedTree.getChildrenNames(objectPath);
        if (protocols.isEmpty()) {
            LOGGER.error("Unknown object {0}", objectName);
            throw new ObjectNotFoundException("Unknown object " + objectName);
        }
        for (String p : protocols) {
            String protoPath = this.getProtocolPath(objectPath, p);
            Vector<String> instances = this.distributedTree.getChildrenNames(protoPath);
            for (String nodeName : instances) {
                cmiReferences.add(this.getCMIReference(protoPath, nodeName));
            }
        }
        return cmiReferences;
    }

    private CMIReference getCMIReference(String protocolPath, String nodeName) {
        String cmiReferencePath = this.getCMIReferencePath(protocolPath, nodeName);
        return (CMIReference)this.distributedTree.get(cmiReferencePath);
    }

    @Override
    public void addCMIReference(CMIReference cmiReference) {
        String path = this.getCMIReferencePath(cmiReference);
        this.distributedTree.add(path, cmiReference);
        this.registerPath(cmiReference);
    }

    @Override
    public void removeCMIReference(CMIReference cmiReference) {
        LOGGER.debug("Removing {0}...", cmiReference);
        String objectName = cmiReference.getObjectName();
        String objectPath = this.getObjectPath(objectName);
        String refPath = this.getCMIReferencePath(cmiReference);
        String protocolPath = this.getProtocolPath(objectPath, cmiReference.getServerRef().getProtocol());
        this.distributedTree.remove(refPath);
        this.unRegisterPath(cmiReference);
        Vector<String> childrenNames = this.distributedTree.getChildrenNames(protocolPath);
        if (childrenNames.isEmpty()) {
            this.distributedTree.remove(objectPath);
        }
    }

    @Override
    public Set<String> getClusterNames() {
        HashSet<String> clusterNames = new HashSet<String>();
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        for (String objectName : objectNames) {
            try {
                DistributedObjectInfo distributedObjectInfo = this.getDistributedObjectInfo(objectName);
                clusterNames.add(distributedObjectInfo.getClusterName());
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(objectName + " is missing !", e);
            }
        }
        return clusterNames;
    }

    @Override
    public Set<String> getObjectNames(String clusterName) {
        HashSet<String> objectNamesInCluster = new HashSet<String>();
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        for (String objectName : objectNames) {
            try {
                DistributedObjectInfo distributedObjectInfo = this.getDistributedObjectInfo(objectName);
                if (!distributedObjectInfo.getClusterName().equals(clusterName)) continue;
                objectNamesInCluster.add(objectName);
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(objectName + " is missing !", e);
            }
        }
        return objectNamesInCluster;
    }

    @Override
    public Set<String> getObjectNames() {
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        return new HashSet<String>(objectNames);
    }

    @Override
    public int getDelayToRefresh() {
        return (Integer)this.distributedTree.get(this.getDelayPath());
    }

    @Override
    public void setDelayToRefresh(int delay) {
        this.distributedTree.reset(this.getDelayPath(), Integer.valueOf(delay));
    }

    @Override
    public boolean isPoolToEmpty(String objectName) {
        return this.distributedTree.exists(this.getPoolToEmptyPath(objectName));
    }

    @Override
    public void addPoolToEmpty(String objectName) {
        this.distributedTree.add(this.getPoolToEmptyPath(objectName));
    }

    @Override
    public void removePoolToEmpty(String objectName) {
        this.distributedTree.remove(this.getPoolToEmptyPath(objectName));
    }

    @Override
    public boolean isServerBlackListed(ServerRef serverRef) {
        return this.distributedTree.exists(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    @Override
    public void addServerToBlackList(ServerRef serverRef) {
        this.distributedTree.add(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    @Override
    public void removeServerFromBlackList(ServerRef serverRef) {
        this.distributedTree.remove(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) throws ServerNotFoundException {
        Serializable obj = this.distributedTree.get(this.getLoadFactorPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
        if (obj == null) {
            throw new ServerNotFoundException("Unknown server: " + serverRef, serverRef);
        }
        return (Integer)obj;
    }

    @Override
    public void setLoadFactor(ServerRef serverRef, int loadFactor) {
        this.distributedTree.reset(this.getLoadFactorPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()), Integer.valueOf(loadFactor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStats() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.distributedTree.exists(this.getNbClientsConnectedToProviderPath())) {
                this.distributedTree.add(this.getNbClientsConnectedToProviderPath(), Integer.valueOf(0));
            }
        }
    }

    @Override
    public int getNbClientsConnectedToProvider() {
        return (Integer)this.distributedTree.get(this.getNbClientsConnectedToProviderPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClient(UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            if (this.distributedTree.exists(this.getClientUUIDPath(uuid.toString()))) {
                return;
            }
            this.distributedTree.add(this.getClientUUIDPath(uuid.toString()));
            this.distributedTree.set(this.getNbClientsConnectedToProviderPath(), Integer.valueOf((Integer)this.distributedTree.get(this.getNbClientsConnectedToProviderPath()) + 1));
        }
    }

    private String getInstAddrPath(String address, String instRef) {
        return address + "/" + instRef;
    }

    private String getObjectPath(String objectName) {
        return this.getObjectsPath() + "/" + objectName;
    }

    private String getRootPath() {
        return "/root";
    }

    private String getObjectsPath() {
        return this.getRootPath() + "/objects";
    }

    private String getProtocolPath(String objectPath, String protocol) {
        return objectPath + "/" + protocol;
    }

    private String getCMIReferencePath(String protocolPath, String objectName) {
        return protocolPath + "/" + objectName;
    }

    private String getCMIReferencePath(CMIReference cmiReference) {
        return this.getProtocolPath(this.getObjectPath(cmiReference.getObjectName()), cmiReference.getServerRef().getProtocol()) + "/" + cmiReference.getServerRef().getInetAddress().getHostAddress() + "_" + cmiReference.getServerRef().getPort();
    }

    private String getAddressesPath() {
        return this.getRootPath() + "/addresses";
    }

    private String getAddressPath(String hostname, int port) {
        return this.getAddressesPath() + "/" + hostname + "/" + port;
    }

    private String getDelayPath() {
        return this.getRootPath() + "/delay";
    }

    private String getBlackListPath() {
        return this.getRootPath() + "/black_list";
    }

    private String getPoolToEmptyPath() {
        return this.getRootPath() + "/pool_to_empty";
    }

    private String getLoadFactorsPath() {
        return this.getRootPath() + "/load_factors";
    }

    private String getStatsPath() {
        return this.getRootPath() + "/stats";
    }

    private String getNbClientsConnectedToProviderPath() {
        return this.getStatsPath() + "/nbClientsOnProvider";
    }

    private String getClientUUIDPath() {
        return this.getStatsPath() + "/clientUUID";
    }

    private String getClientUUIDPath(String uuid) {
        return this.getClientUUIDPath() + "/" + uuid;
    }

    private String getPoolToEmptyPath(String objectName) {
        return this.getPoolToEmptyPath() + "/" + objectName;
    }

    private String getServerBlackListedPath(String serverName) {
        return this.getBlackListPath() + "/" + serverName;
    }

    private String getLoadFactorPath(String address) {
        return this.getLoadFactorsPath() + "/" + address;
    }

    @Override
    public void nodeAdded(String fqn, Serializable element) {
        DistributedObjectInfo distributedObjectInfo;
        String objectName;
        LOGGER.debug("{0} has been added", fqn);
        if (element != null && element instanceof DistributedObjectInfo && this.isWatched(objectName = (distributedObjectInfo = (DistributedObjectInfo)element).getObjectName())) {
            try {
                this.updatePolicy(objectName);
            }
            catch (Exception e) {
                LOGGER.error("Cannot update LBPolicy for object with name {0}", objectName, e);
                throw new ServerClusterViewManagerException("Cannot update LBPolicy for object with name " + objectName, e);
            }
            try {
                if (this.hasPool(objectName)) {
                    this.getPool(objectName).setPoolConfiguration(distributedObjectInfo.getPoolConfiguration());
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot update the pool configuration for object with name {0}", objectName, e);
                throw new ServerClusterViewManagerException("Cannot update the pool configuration for object with name " + objectName, e);
            }
        }
    }

    @Override
    public void nodeModified(String fqn, Serializable oldElement, Serializable newElement) {
        DistributedObjectInfo newDistributedObjectInfo;
        String objectName;
        LOGGER.debug("{0} has been modified", fqn);
        LOGGER.debug("Old element: {0} - New element: {1}", oldElement, newElement);
        if (newElement != null && newElement instanceof DistributedObjectInfo && this.isWatched(objectName = (newDistributedObjectInfo = (DistributedObjectInfo)newElement).getObjectName())) {
            PolicyData newLBPolicyData = newDistributedObjectInfo.getPolicyData();
            if (oldElement == null || !((DistributedObjectInfo)oldElement).getPolicyData().equals(newLBPolicyData)) {
                try {
                    this.updatePolicy(objectName);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot update LBPolicy for object with name {0}", objectName, e);
                    throw new ServerClusterViewManagerException("Cannot update LBPolicy for object with name " + objectName, e);
                }
            }
            IPoolConfiguration poolConfiguration = newDistributedObjectInfo.getPoolConfiguration();
            try {
                if (oldElement == null || !((DistributedObjectInfo)oldElement).getPoolConfiguration().equals(poolConfiguration) && this.hasPool(objectName)) {
                    this.getPool(objectName).setPoolConfiguration(poolConfiguration);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot update the pool configuration for object with name {0}", objectName, e);
                throw new ServerClusterViewManagerException("Cannot update the pool configuration for object with name " + objectName, e);
            }
        }
    }

    @Override
    public void nodeRemoved(String fqn) {
        LOGGER.debug("{0} has been removed", fqn);
    }

    @Override
    public void viewChange(Vector<Address> newMbrs, Vector<Address> oldMbrs) {
        LOGGER.debug("view has changed", new Object[0]);
        for (Address oldMbr : oldMbrs) {
            IpAddress ipAddr = (IpAddress)oldMbr;
            InetAddress inetAddress = ipAddr.getIpAddress();
            String hostname = inetAddress.getHostAddress();
            int port = ipAddr.getPort();
            LOGGER.debug("Search instances on {0}:{1}", hostname, String.valueOf(port));
            String addrPath = this.getAddressPath(hostname, port);
            Vector<String> childrenNames = this.distributedTree.getChildrenNames(addrPath);
            for (String instAddrName : childrenNames) {
                String instAddrPath = this.getInstAddrPath(addrPath, instAddrName);
                String pathToDelete = (String)((Object)this.distributedTree.get(instAddrPath));
                LOGGER.debug("Marking {0} to delete", pathToDelete);
                this.pathsToDelete.add(pathToDelete);
            }
            LOGGER.debug("Marking {0} to delete...", addrPath);
            this.pathsToDelete.add(addrPath);
            this.resumableRunnable.resumeExecution();
        }
    }

    private class TreeCleaner
    implements ResumableRunnable {
        private volatile boolean suspended;
        private volatile boolean stopped;

        private TreeCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.suspended = false;
            this.stopped = false;
            while (!this.stopped) {
                Object object = this;
                synchronized (object) {
                    try {
                        while (this.suspended && !this.stopped) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug("Garbage collector interrupted", e);
                    }
                }
                LOGGER.debug("Cleaning the distributed tree...", new Object[0]);
                object = JGroupsClusterViewManager.this.pathsToDelete;
                synchronized (object) {
                    Iterator it = JGroupsClusterViewManager.this.pathsToDelete.iterator();
                    while (it.hasNext()) {
                        String pathToDelete = (String)it.next();
                        JGroupsClusterViewManager.this.removePath(pathToDelete);
                        it.remove();
                    }
                    this.suspended = true;
                }
            }
            LOGGER.debug("Garbage collector stopped", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeExecution() {
            LOGGER.debug("Garbage collector resumed", new Object[0]);
            this.suspended = false;
            TreeCleaner treeCleaner = this;
            synchronized (treeCleaner) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopExecution() {
            LOGGER.debug("Garbage collector stopping...", new Object[0]);
            this.stopped = true;
            TreeCleaner treeCleaner = this;
            synchronized (treeCleaner) {
                this.notifyAll();
            }
        }
    }
}

