/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.rmi.Remote;
import javax.naming.NamingException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCMIReferenceableWrapper<T extends Remote>
extends CMIReferenceableWrapper<T> {
    private static final long serialVersionUID = 1192398491336031370L;
    private String ior;

    public RemoteCMIReferenceableWrapper(CMIReference cmiRef, T referencedObject) {
        super(cmiRef, referencedObject);
    }

    public RemoteCMIReferenceableWrapper(CMIReference cmiRef, String ior) {
        super(cmiRef, null);
        this.ior = ior;
    }

    private Object readResolve() throws ObjectStreamException {
        CMIReference ref = this.getReference();
        if (ref.getServerRef().getProtocol().equals("iiop")) {
            Remote remote;
            try {
                remote = Utility.string_to_remote(this.ior);
            }
            catch (NamingException e) {
                throw new InvalidObjectException("Cannot get the stub from the ior " + this.ior);
            }
            return new RemoteCMIReferenceableWrapper<Remote>(ref, remote);
        }
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        CMIReference ref = this.getReference();
        if (ref.getServerRef().getProtocol().equals("iiop")) {
            String ior;
            try {
                ior = Utility.remote_to_string((Remote)this.getReferencedObject());
            }
            catch (NamingException e) {
                throw new InvalidObjectException("Cannot get the ior from the stub " + this.getReferencedObject());
            }
            return new RemoteCMIReferenceableWrapper<T>(ref, ior);
        }
        return this;
    }
}

