/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.hsqldb.User;
import org.ow2.easybeans.component.itf.EmbeddedDBComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBComponent
implements EmbeddedDBComponent {
    private static Log logger = LogFactory.getLog(HSQLDBComponent.class);
    private List<User> users = null;
    private String databaseName = null;
    private static final String DEFAULT_PORT = "9001";
    private static final int SLEEP_VALUE = 100;
    private static final int MAX_RETRY_NB = 20;
    private String portNumber = "9001";
    private Server server = null;

    @Override
    public void init() throws EZBComponentException {
        this.server = new Server();
        if (!logger.isDebugEnabled()) {
            this.server.setLogWriter(null);
            this.server.setErrWriter(null);
            this.server.setSilent(true);
            this.server.setTrace(false);
            this.server.setLogWriter(null);
        } else {
            this.server.setSilent(false);
            this.server.setTrace(true);
        }
        String baseDir = System.getProperty("java.io.tmpdir") + File.separator + "easybeans" + File.separator + "hsqldb" + File.separator + this.databaseName;
        String pString = "";
        if (this.portNumber != null) {
            pString = ";port=" + this.portNumber;
        }
        String serverProps = "database.0=" + baseDir + ";dbname.0=" + this.databaseName + pString;
        logger.debug("Server properties = {0}", serverProps);
        this.server.putPropertiesFromString(serverProps);
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            throw new EZBComponentException("Cannot access to HSQL Driver 'org.hsqldb.jdbcDriver'.", e);
        }
    }

    @Override
    public void start() throws EZBComponentException {
        logger.info("Starting ''{0}'' ''{1}'' on port ''{2}''", this.server.getProductName(), this.server.getProductVersion(), this.portNumber);
        this.server.start();
        int retryNb = 0;
        while (this.server.getState() != 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                logger.error("Cannot wait that the service is online", ie);
            }
            if (this.server.getState() == 16 && ++retryNb >= 20) {
                Throwable t = this.server.getServerError();
                throw new EZBComponentException("Cannot start the server. The server has not started and is shutdown.", t);
            }
            logger.debug("retry= {0}, serverState= {1}", retryNb, this.server.getState());
        }
        String connURL = "jdbc:hsqldb:hsql://localhost:" + this.portNumber + "/" + this.databaseName;
        logger.info("{0} started with URL {1}", this.server.getProductName(), connURL);
        Connection conn = null;
        Statement st = null;
        try {
            conn = DriverManager.getConnection(connURL, "sa", "");
            st = conn.createStatement();
        }
        catch (SQLException e) {
            throw new EZBComponentException("Cannot access to HSQL", e);
        }
        User user2 = null;
        String userName = null;
        String password = null;
        ResultSet rs = null;
        for (User user2 : this.users) {
            try {
                password = user2.getPassword();
                userName = user2.getUserName();
                logger.debug("Dropping and adding user {0} with password {1}.", userName, password);
                try {
                    rs = st.executeQuery("DROP USER " + userName);
                }
                catch (SQLException e) {
                    logger.debug("User {0} doesn't exists", userName, e);
                }
                rs = st.executeQuery("Create USER " + userName + " PASSWORD " + password + " ADMIN");
                rs.close();
            }
            catch (SQLException e) {
                logger.error("Error while creating/adding user", e);
            }
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            logger.error("Error while closing statement object", e);
        }
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    @Override
    public void stop() throws EZBComponentException {
        this.server.shutdown();
        DatabaseManager.getTimer().shutDown();
    }

    @Override
    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

