/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.ow2.easybeans.component.jdbcpool.AbsProxy;
import org.ow2.easybeans.component.jdbcpool.ConnectionManager;
import org.ow2.easybeans.component.jdbcpool.IConnection;
import org.ow2.easybeans.component.jdbcpool.IManagedConnection;
import org.ow2.easybeans.component.jdbcpool.IPreparedStatement;
import org.ow2.easybeans.component.jdbcpool.JConnection;
import org.ow2.easybeans.component.jdbcpool.JStatement;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JManagedConnection
extends AbsProxy {
    private static Log logger = LogFactory.getLog(JManagedConnection.class);
    private Connection physicalConnection = null;
    private IConnection implConn = null;
    private int pstmtmax = 0;
    private int psOpenNb = 0;
    private Vector<ConnectionEventListener> eventListeners = new Vector();
    private int open = 0;
    private int timeout = 0;
    private Transaction tx = null;
    private static int objcount = 0;
    private final int identifier;
    private int reUsedPreparedStatements = 0;
    private Map<String, IPreparedStatement> psList = null;
    private ConnectionManager ds = null;
    private long deathTime = 0L;
    private long closeTime = 0L;

    public JManagedConnection(Connection physicalConnection, ConnectionManager ds) {
        this.physicalConnection = physicalConnection;
        this.ds = ds;
        IManagedConnection managedConnectionProxy = (IManagedConnection)Proxy.newProxyInstance(IManagedConnection.class.getClassLoader(), new Class[]{IManagedConnection.class}, (InvocationHandler)this);
        this.implConn = (IConnection)Proxy.newProxyInstance(IConnection.class.getClassLoader(), new Class[]{IConnection.class}, (InvocationHandler)new JConnection(managedConnectionProxy, physicalConnection));
        this.open = 0;
        this.deathTime = System.currentTimeMillis() + ds.getMaxAgeMilli();
        this.identifier = objcount++;
        this.pstmtmax = ds.getPstmtMax();
        this.psOpenNb = 0;
        this.psList = Collections.synchronizedMap(new HashMap());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            return this.handleObjectMethods(method, args);
        }
        String methodName = method.getName();
        if ("getIdentifier".equals(methodName)) {
            return this.getIdentifier();
        }
        if ("getXAResource".equals(methodName)) {
            return proxy;
        }
        if ("commit".equals(methodName)) {
            this.commit((Xid)args[0], (Boolean)args[1], (IManagedConnection)proxy);
            return null;
        }
        if ("end".equals(methodName)) {
            this.end((Xid)args[0], (Integer)args[1]);
            return null;
        }
        if ("forget".equals(methodName)) {
            this.forget((Xid)args[0]);
            return null;
        }
        if ("prepare".equals(methodName)) {
            return this.prepare((Xid)args[0]);
        }
        if ("getTransactionTimeout".equals(methodName)) {
            return this.getTransactionTimeout();
        }
        if ("isSameRM".equals(methodName)) {
            return this.isSameRM(args[0]);
        }
        if ("recover".equals(methodName)) {
            return this.recover((Integer)args[0]);
        }
        if ("rollback".equals(methodName)) {
            this.rollback((Xid)args[0], (IManagedConnection)proxy);
            return null;
        }
        if ("setTransactionTimeout".equals(methodName)) {
            this.setTransactionTimeout((Integer)args[0]);
            return null;
        }
        if ("start".equals(methodName)) {
            this.start((Xid)args[0], (Integer)args[1]);
            return null;
        }
        if ("getXAResource".equals(methodName)) {
            return proxy;
        }
        if ("notifyClose".equals(methodName)) {
            this.notifyClose((IManagedConnection)proxy);
            return null;
        }
        if ("notifyError".equals(methodName)) {
            this.notifyError((IManagedConnection)proxy, (SQLException)args[0]);
            return null;
        }
        if ("compareTo".equals(methodName)) {
            return this.compareTo((IManagedConnection)proxy, (IManagedConnection)args[0]);
        }
        if ("getReUsedPreparedStatements".equals(methodName)) {
            return this.getReUsedPreparedStatements();
        }
        if ("setPstmtMax".equals(methodName)) {
            this.setPstmtMax((Integer)args[0]);
            return null;
        }
        if ("getConnection".equals(methodName)) {
            return this.getConnection();
        }
        if ("close".equals(methodName)) {
            this.close();
            return null;
        }
        if ("addConnectionEventListener".equals(methodName)) {
            this.addConnectionEventListener((ConnectionEventListener)args[0]);
            return null;
        }
        if ("removeConnectionEventListener".equals(methodName)) {
            this.removeConnectionEventListener((ConnectionEventListener)args[0]);
            return null;
        }
        if ("beforeCompletion".equals(methodName)) {
            this.beforeCompletion();
            return null;
        }
        if ("afterCompletion".equals(methodName)) {
            this.afterCompletion((Integer)args[0]);
            return null;
        }
        if ("isAged".equals(methodName)) {
            return this.isAged();
        }
        if ("isOpen".equals(methodName)) {
            return this.isOpen();
        }
        if ("getOpenCount".equals(methodName)) {
            return this.getOpenCount();
        }
        if ("inactive".equals(methodName)) {
            return this.inactive();
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed();
        }
        if ("hold".equals(methodName)) {
            this.hold();
            return null;
        }
        if ("release".equals(methodName)) {
            return this.release();
        }
        if ("setTx".equals(methodName)) {
            this.setTx((Transaction)args[0]);
            return null;
        }
        if ("getTx".equals(methodName)) {
            return this.getTx();
        }
        if ("remove".equals(methodName)) {
            this.remove();
            return null;
        }
        if ("addStatementEventListener".equals(methodName) || "removeStatementEventListener".equals(methodName)) {
            throw new UnsupportedOperationException("JDK 6.0 / JDBC 4.0 API Not supported");
        }
        if ("notifyPsClose".equals(methodName)) {
            this.notifyPsClose((JStatement)args[0]);
        } else if ("prepareStatement".equals(methodName)) {
            if (args.length == 1) {
                return this.prepareStatement((String)args[0]);
            }
            return this.prepareStatement((String)args[0], (Integer)args[1], (Integer)args[2]);
        }
        logger.error("Method ''{0}'' not handled by the proxy", method);
        return null;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setPstmtMax(int max) {
        this.pstmtmax = max;
        if (this.psList == null) {
            this.psList = Collections.synchronizedMap(new HashMap(this.pstmtmax));
        }
    }

    public void commit(Xid xid, boolean onePhase, IManagedConnection proxy) throws XAException {
        logger.debug("XA-COMMIT for {0}", xid);
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException e) {
            logger.error("Cannot commit transaction", e);
            this.notifyError(proxy, e);
            throw new XAException("Error on commit");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        logger.debug("XA-END for {0}", xid);
    }

    public void forget(Xid xid) throws XAException {
        logger.debug("XA-FORGET for {0}", xid);
    }

    public int getTransactionTimeout() throws XAException {
        logger.debug("getTransactionTimeout for {0}", this);
        return this.timeout;
    }

    public boolean isSameRM(Object xares) throws XAException {
        if (xares.equals(this)) {
            logger.debug("isSameRM = true {0}", this);
            return true;
        }
        logger.debug("isSameRM = false {0}", this);
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        logger.debug("XA-PREPARE for {0}", xid);
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        logger.debug("XA-RECOVER for {0}", this);
        return null;
    }

    public void rollback(Xid xid, IManagedConnection proxy) throws XAException {
        logger.debug("XA-ROLLBACK for {0}", xid);
        try {
            if (this.physicalConnection.getAutoCommit()) {
                logger.error("Rollback called on XAResource with AutoCommit set", new Object[0]);
                throw new XAException(7);
            }
        }
        catch (SQLException e) {
            logger.error("Cannot getAutoCommit", e);
            this.notifyError(proxy, e);
            throw new XAException("Error on getAutoCommit");
        }
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException e) {
            logger.error("Cannot rollback transaction", e);
            this.notifyError(proxy, e);
            throw new XAException("Error on rollback");
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        logger.debug("setTransactionTimeout to {0} for {1}", seconds, this);
        this.timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        logger.debug("XA-START for {0}", xid);
    }

    public int compareTo(IManagedConnection current, IManagedConnection other) {
        int diff = current.getReUsedPreparedStatements() - other.getReUsedPreparedStatements();
        if (diff == 0) {
            return current.getIdentifier() - other.getIdentifier();
        }
        return diff;
    }

    public int getReUsedPreparedStatements() {
        return this.reUsedPreparedStatements;
    }

    public IConnection getConnection() throws SQLException {
        return this.implConn;
    }

    public void close() throws SQLException {
        if (this.physicalConnection != null) {
            this.physicalConnection.close();
        } else {
            logger.error("Connection already closed. Stack of this new close()", new Exception());
        }
        this.physicalConnection = null;
        this.implConn = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.removeElement(listener);
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (this.tx != null) {
            this.ds.freeConnections(this.tx);
        } else {
            logger.error("NO TX!", new Object[0]);
        }
    }

    public boolean isAged() {
        return this.deathTime < System.currentTimeMillis();
    }

    public boolean isOpen() {
        return this.open > 0;
    }

    public int getOpenCount() {
        return this.open;
    }

    public boolean inactive() {
        return this.open > 0 && this.tx == null && this.closeTime < System.currentTimeMillis();
    }

    public boolean isClosed() {
        return this.open <= 0;
    }

    public void hold() {
        ++this.open;
        this.closeTime = System.currentTimeMillis() + this.ds.getMaxOpenTimeMilli();
    }

    public boolean release() {
        --this.open;
        if (this.open < 0) {
            logger.warn("connection was already closed", new Object[0]);
            this.open = 0;
            return false;
        }
        if (this.tx == null && this.open > 0) {
            logger.error("connection-open counter overflow", new Object[0]);
            this.open = 0;
        }
        return true;
    }

    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    public Transaction getTx() {
        return this.tx;
    }

    public void remove() {
        try {
            this.close();
        }
        catch (SQLException ign) {
            logger.error("Could not close Connection: ", ign);
        }
        this.tx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("sql = {0}", sql);
        if (this.pstmtmax == 0) {
            return this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        IPreparedStatement ps = null;
        Map<String, IPreparedStatement> map = this.psList;
        synchronized (map) {
            ps = this.psList.get(sql);
            if (ps != null) {
                if (!ps.isClosed()) {
                    logger.warn("reuse an open pstmt", new Object[0]);
                }
                ps.reuse();
                ++this.reUsedPreparedStatements;
            } else {
                PreparedStatement aps = this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
                ps = (IPreparedStatement)Proxy.newProxyInstance(IPreparedStatement.class.getClassLoader(), new Class[]{IPreparedStatement.class}, (InvocationHandler)new JStatement(aps, this, sql));
                this.psList.put(sql, ps);
            }
            ++this.psOpenNb;
        }
        return ps;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPsClose(JStatement ps) {
        logger.debug(ps.getSql(), new Object[0]);
        Map<String, IPreparedStatement> map = this.psList;
        synchronized (map) {
            --this.psOpenNb;
            if (this.psList.size() >= this.pstmtmax) {
                IPreparedStatement lru = null;
                Iterator<IPreparedStatement> i = this.psList.values().iterator();
                while (i.hasNext()) {
                    lru = i.next();
                    if (!lru.isClosed()) continue;
                    i.remove();
                    lru.forget();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClose(IManagedConnection proxy) {
        Map<String, IPreparedStatement> map = this.psList;
        synchronized (map) {
            if (this.psOpenNb > 0) {
                IPreparedStatement jst2 = null;
                for (IPreparedStatement jst2 : this.psList.values()) {
                    if (!jst2.forceClose()) continue;
                    --this.psOpenNb;
                }
                if (this.psOpenNb != 0) {
                    logger.warn("Bad psOpenNb value = {0}", this.psOpenNb);
                    this.psOpenNb = 0;
                }
            }
        }
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = this.eventListeners.elementAt(i);
            l.connectionClosed(new ConnectionEvent(proxy));
        }
    }

    public void notifyError(IManagedConnection proxy, SQLException ex) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = this.eventListeners.elementAt(i);
            l.connectionErrorOccurred(new ConnectionEvent(proxy, ex));
        }
    }
}

