/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.ow2.easybeans.component.jdbcpool.AbsProxy;
import org.ow2.easybeans.component.jdbcpool.JManagedConnection;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JStatement
extends AbsProxy {
    private boolean changed = false;
    private boolean opened = false;
    private boolean closing = false;
    private PreparedStatement ps;
    private JManagedConnection mc;
    private int hashCode;
    private String sql;
    private Log logger = LogFactory.getLog(JStatement.class);

    public JStatement(PreparedStatement ps, JManagedConnection mc, String sql) {
        this.ps = ps;
        this.mc = mc;
        this.sql = sql;
        this.hashCode = sql.hashCode();
        this.opened = true;
    }

    public String getSql() {
        return this.sql;
    }

    protected PreparedStatement getInternalPreparedStatement() {
        return this.ps;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object stmt) {
        if (stmt == null) {
            return false;
        }
        if (this.hashCode != stmt.hashCode()) {
            return false;
        }
        if (!(stmt instanceof JStatement)) {
            this.logger.warn("Bad class {0}", stmt);
            return false;
        }
        JStatement psw = (JStatement)stmt;
        if (this.sql == null && psw.getSql() != null) {
            return false;
        }
        if (this.sql != null && !this.sql.equals(psw.getSql())) {
            return false;
        }
        try {
            if (psw.getInternalPreparedStatement().getResultSetType() != this.ps.getResultSetType()) {
                return false;
            }
            if (psw.getInternalPreparedStatement().getResultSetConcurrency() != this.ps.getResultSetConcurrency()) {
                return false;
            }
        }
        catch (SQLException e) {
            this.logger.warn("Cannot compare statements", e);
            return false;
        }
        this.logger.debug("Found", new Object[0]);
        return true;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            return this.handleObjectMethods(method, args);
        }
        String methodName = method.getName();
        if ("forceClose".equals(methodName)) {
            return this.forceClose();
        }
        if ("reuse".equals(methodName)) {
            this.reuse();
            return null;
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed();
        }
        if ("forget".equals(methodName)) {
            this.forget();
            return null;
        }
        if ("close".equals(methodName)) {
            this.close();
            return null;
        }
        if ("addBatch".equals(methodName) || "execute".equals(methodName) || "executeUpdate".equals(methodName) || "setFetchDirection".equals(methodName) || "setFetchSize".equals(methodName) || "setMaxFieldSize".equals(methodName) || "setMaxRows".equals(methodName) || "setQueryTimeout".equals(methodName)) {
            this.changed = true;
        }
        try {
            return method.invoke((Object)this.ps, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
    }

    public boolean forceClose() {
        if (this.opened) {
            this.logger.debug("Statements should be closed explicitly.", new Object[0]);
            this.opened = false;
            return true;
        }
        return false;
    }

    public void reuse() throws SQLException {
        this.ps.clearParameters();
        this.ps.clearWarnings();
        this.opened = true;
        if (this.changed) {
            this.logger.debug("Properties statement have been changed, reset default properties", new Object[0]);
            this.ps.clearBatch();
            this.ps.setFetchDirection(1000);
            this.ps.setMaxFieldSize(0);
            this.ps.setMaxRows(0);
            this.ps.setQueryTimeout(0);
            this.changed = false;
        }
    }

    public boolean isClosed() {
        return !this.opened && !this.closing;
    }

    public void forget() {
        try {
            this.ps.close();
        }
        catch (SQLException e) {
            this.logger.error("Cannot close the PreparedStatement", e);
        }
    }

    public void close() throws SQLException {
        if (!this.opened) {
            this.logger.debug("Statement already closed", new Object[0]);
            return;
        }
        this.opened = false;
        this.closing = true;
        this.mc.notifyPsClose(this);
        this.closing = false;
    }
}

