/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jotm;

import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.TMComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOTMComponent
implements TMComponent {
    private static final int DEFAULT_TIMEOUT = 60;
    private static Log logger = LogFactory.getLog(JOTMComponent.class);
    private TransactionManager transactionManager = null;
    private int timeout = 60;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        TransactionFactoryImpl transactionFactory;
        try {
            transactionFactory = new TransactionFactoryImpl();
        }
        catch (RemoteException e) {
            throw new EZBComponentException("Cannot create transaction factory", e);
        }
        try {
            new InitialContext().rebind("TMFactory", (Object)transactionFactory);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind transaction factory", e);
        }
        this.transactionManager = new Current(transactionFactory);
        try {
            this.transactionManager.setTransactionTimeout(this.timeout);
        }
        catch (SystemException se) {
            throw new EZBComponentException("Cannot set Transaction Timeout", se);
        }
        try {
            new InitialContext().rebind("javax.transaction.UserTransaction", (Object)this.transactionManager);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind user transaction", e);
        }
        logger.info("Register {0} as transaction manager object", "javax.transaction.UserTransaction");
    }

    public void stop() throws EZBComponentException {
        try {
            new InitialContext().unbind("TMFactory");
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot unbind transaction factory", e);
        }
        try {
            new InitialContext().unbind("javax.transaction.UserTransaction");
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot unbind user transaction", e);
        }
        TimerManager.stop(true);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

