/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.mail.factory;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.ow2.easybeans.util.marshalling.Serialization;

public abstract class AbsJavaMailRef
implements Referenceable {
    private String name = null;
    private String jndiName = null;
    private Properties properties = null;
    private String authName = null;
    private String authPass = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getAuthName() {
        return this.authName;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public String getAuthPass() {
        return this.authPass;
    }

    public void setAuthPass(String authPass) {
        this.authPass = authPass;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void updateRefAddr(Reference reference) throws NamingException {
        this.putObject(reference, "mail.properties", this.properties);
        reference.add(new StringRefAddr("auth.name", this.authName));
        reference.add(new StringRefAddr("auth.pass", this.authPass));
    }

    public void putObject(Reference reference, String propertyName, Serializable o) throws NamingException {
        try {
            reference.add(new BinaryRefAddr(propertyName, Serialization.storeObject(o)));
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Cannot get bytes from the to recipients object");
            ne.initCause(e);
            throw ne;
        }
    }

    public abstract Reference getReference() throws NamingException;

    public abstract String getType();
}

