/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.spi;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.easybeans.component.smartclient.client.AskingClassLoader;

public final class SmartBootstrap {
    private static final int DEFAULT_PORT_NUMBER = 2503;
    private String[] args = null;
    private List<String> clientArgs = null;
    private int portNumber = 2503;
    private String host = "localhost";
    private String classpath = null;
    private static Logger logger = Logger.getLogger(SmartBootstrap.class.getName());

    private SmartBootstrap(String[] args) {
        this.args = args;
        this.clientArgs = new LinkedList<String>();
    }

    public static void main(String[] args) {
        SmartBootstrap bootStrap = new SmartBootstrap(args);
        bootStrap.start();
    }

    public void start() {
        Method mainMethod;
        Class<?> mainClazz;
        this.analyzeArgs();
        String mainClass = null;
        if (this.clientArgs.size() > 0) {
            mainClass = this.clientArgs.get(0);
            this.clientArgs.remove(0);
        }
        if (mainClass == null || mainClass.length() == 0) {
            this.usage();
            throw new IllegalArgumentException("No class to launch !");
        }
        AskingClassLoader classLoader = new AskingClassLoader(this.host, this.portNumber, this.getUserClasspathUrls());
        Thread.currentThread().setContextClassLoader(classLoader);
        logger.log(Level.INFO, "Starting Main-Class : '" + mainClass + "' by using Smart Server '" + this.host + ":" + this.portNumber + "' with args '" + this.clientArgs + "'.");
        try {
            mainClazz = classLoader.loadClass(mainClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the main class '" + mainClass + "'.", e);
        }
        try {
            mainMethod = mainClazz.getMethod("main", String[].class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("No such method main found in the main class '" + mainClass + "'.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method main found in the main class '" + mainClass + "'.", e);
        }
        try {
            mainMethod.invoke(null, new Object[]{this.clientArgs.toArray(new String[this.clientArgs.size()])});
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error while invoking client class " + mainClass + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while invoking client class " + mainClass + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Error while invoking client class " + mainClass + "'.", e);
        }
    }

    private void analyzeArgs() throws IllegalArgumentException {
        for (int argn = 0; argn < this.args.length; ++argn) {
            String arg = this.args[argn];
            try {
                if (arg.equals("-port")) {
                    this.portNumber = Integer.valueOf(this.args[++argn]);
                    continue;
                }
                if (arg.equals("-host")) {
                    this.host = this.args[++argn];
                    continue;
                }
                if (arg.equals("-cp")) {
                    this.classpath = this.args[++argn];
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-help") || arg.equals("-h") || arg.equals("-?")) {
                    this.usage();
                    System.exit(1);
                }
                this.clientArgs.add(arg);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("A required parameter was missing after the argument '" + arg + "'.", e);
            }
        }
    }

    private URL[] getUserClasspathUrls() {
        if (this.classpath == null) {
            return new URL[0];
        }
        String sep = File.pathSeparator;
        ArrayList<URL> clUser = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classpath, sep);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            try {
                clUser.add(file.toURI().toURL());
            }
            catch (MalformedURLException uue) {
                logger.log(Level.WARNING, "Cannot transform to URL the file : '" + file + "'", uue);
            }
        }
        return clUser.toArray(new URL[0]);
    }

    private void usage() {
        System.out.println("Usage of this SmartBootStrap :");
        System.out.println("-------------------------------------------------------------------");
        System.out.println("java [options] easybeans-component-smartclient-xxx.jar <My.Client.ClassName> [client-options]");
        System.out.println("-------------------------------------------------------------------");
        System.out.println(" -cp   : Specify the classpath to use for the jar client. ie: -cp <a.jar" + File.pathSeparator + "b.jar>");
        System.out.println(" -port : Specify the port number to use when connecting on Smart Server.");
        System.out.println(" -host : Specify the hostname of the Smart Server.");
        System.out.println("-------------------------------------------------------------------");
        System.out.println(" --help| -help | -h | -?  : Display this help.");
        System.out.println("-------------------------------------------------------------------");
    }
}

